/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.ide;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.lang.javascript.findUsages.JavaScriptFindUsagesProvider;
import com.intellij.lang.typescript.compiler.TypeScriptServiceHolder;
import com.intellij.lang.typescript.compiler.VirtualFileAndTypeScriptService;
import com.intellij.lang.typescript.compiler.languageService.ide.ServiceBackedTypeScriptFindUsagesHandler;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/ide/TypeScriptServiceFindUsagesHandlerFactory;", "Lcom/intellij/find/findUsages/FindUsagesHandlerFactory;", "<init>", "()V", "canFindUsages", "", "element", "Lcom/intellij/psi/PsiElement;", "createFindUsagesHandler", "Lcom/intellij/find/findUsages/FindUsagesHandler;", "forHighlightUsages", "intellij.javascript.backend"})
public final class TypeScriptServiceFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    public boolean canFindUsages(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Project project = element2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project)) {
            return false;
        }
        if (!JavaScriptFindUsagesProvider.canFindUsages(element2)) {
            return false;
        }
        VirtualFileAndTypeScriptService virtualFileAndTypeScriptService = TypeScriptServiceHolder.getForElement$default(element2, false, 2, null);
        if (virtualFileAndTypeScriptService == null) {
            return false;
        }
        VirtualFileAndTypeScriptService serviceInfo = virtualFileAndTypeScriptService;
        return serviceInfo.getService().isFindUsagesEnabled();
    }

    @Nullable
    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element2, boolean forHighlightUsages) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (forHighlightUsages) {
            return null;
        }
        if (!this.canFindUsages(element2)) {
            return null;
        }
        return new ServiceBackedTypeScriptFindUsagesHandler(element2);
    }
}

