/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsRegistry;
import com.intellij.lang.javascript.library.typings.TypeScriptPackageName;
import com.intellij.lang.javascript.library.typings.TypingsNotReadyException;
import com.intellij.lang.typescript.lsp.JSServiceLoader;
import com.intellij.lang.typescript.lsp.LspDownloadService;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0001\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0001\u001a.\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000fH\u0002\u001a\"\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0002\"\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"getDownloadedLspServerPath", "", "packageName", "Lcom/intellij/lang/javascript/library/typings/TypeScriptPackageName;", "relativeScriptPath", "project", "Lcom/intellij/openapi/project/Project;", "scheduleLspServerDownloading", "", "loader", "Lcom/intellij/lang/typescript/lsp/JSServiceLoader;", "scheduleDownloadingTask", "attemptId", "", "onDownloadFinished", "Lkotlin/Function0;", "downloadPackageSync", "Ljava/nio/file/Path;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "npmPackage", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nlspServerDownloading.kt\nKotlin\n*S Kotlin\n*F\n+ 1 lspServerDownloading.kt\ncom/intellij/lang/typescript/lsp/LspServerDownloadingKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,168:1\n30#2,2:169\n13#3:171\n*S KotlinDebug\n*F\n+ 1 lspServerDownloading.kt\ncom/intellij/lang/typescript/lsp/LspServerDownloadingKt\n*L\n113#1:169,2\n167#1:171\n*E\n"})
public final class LspServerDownloadingKt {
    @NotNull
    private static final Logger log;

    @ApiStatus.Experimental
    @Nullable
    public static final String getDownloadedLspServerPath(@NotNull TypeScriptPackageName packageName, @NotNull String relativeScriptPath, @NotNull Project project) {
        String path2;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
                Intrinsics.checkNotNullParameter((Object)relativeScriptPath, (String)"relativeScriptPath");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                path2 = (String)CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(packageName, project, null){
                    int label;
                    final /* synthetic */ TypeScriptPackageName $packageName;
                    final /* synthetic */ Project $project;
                    {
                        this.$packageName = $packageName;
                        this.$project = $project;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                String string;
                                ResultKt.throwOnFailure((Object)$result);
                                try {
                                    String string2;
                                    String string3 = TypeScriptExternalDefinitionsRegistry.Companion.getExactModuleTypingsPath(this.$packageName, this.$project);
                                    if (string3 != null) {
                                        String string4 = string3;
                                        TypeScriptPackageName typeScriptPackageName = this.$packageName;
                                        String it = string4;
                                        boolean bl = false;
                                        string2 = !TypeScriptExternalDefinitionsRegistry.Companion.getInstance().areExternalDefinitionsInstalling(typeScriptPackageName) ? string4 : null;
                                    } else {
                                        string2 = null;
                                    }
                                    string = string2;
                                }
                                catch (TypingsNotReadyException e) {
                                    LspServerDownloadingKt.access$getLog$p().debug("Package " + this.$packageName + " is not ready: " + e.getMessage());
                                    string = null;
                                }
                                return string;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
                if (path2 == null) break block2;
                Path path3 = Paths.get(path2, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
                Path path4 = path3;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.isDirectory(path4, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block3;
            }
            return null;
        }
        log.debug("Found package: " + path2);
        return path2 + FileUtil.toSystemDependentName((String)relativeScriptPath);
    }

    @ApiStatus.Experimental
    public static final void scheduleLspServerDownloading(@NotNull Project project, @NotNull JSServiceLoader loader) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<LspDownloadService> serviceClass$iv = LspDownloadService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        LspDownloadService downloadService = (LspDownloadService)object;
        downloadService.scheduleDownload(loader);
    }

    private static final void scheduleDownloadingTask(Project project, JSServiceLoader loader, int attemptId, Function0<Unit> onDownloadFinished) {
        TypeScriptPackageName serverPackage = loader.getPackageDescriptor().getServerPackage();
        Object[] objectArray = new Object[]{serverPackage.getName()};
        String string = JavaScriptBundle.message((String)"npm.downloading_package", (Object[])objectArray);
        objectArray = Task.Backgroundable.ALWAYS_BACKGROUND;
        new Task.Backgroundable(project, serverPackage, loader, attemptId, onDownloadFinished, string, (PerformInBackgroundOption)objectArray){
            final /* synthetic */ Project $project;
            final /* synthetic */ TypeScriptPackageName $serverPackage;
            final /* synthetic */ JSServiceLoader $loader;
            final /* synthetic */ int $attemptId;
            final /* synthetic */ Function0<Unit> $onDownloadFinished;
            {
                this.$project = $project;
                this.$serverPackage = $serverPackage;
                this.$loader = $loader;
                this.$attemptId = $attemptId;
                this.$onDownloadFinished = $onDownloadFinished;
                super($project, $super_call_param$1, true, $super_call_param$2);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(true);
                Object[] objectArray = new Object[]{this.$serverPackage.getName()};
                indicator.setText2(JavaScriptBundle.message((String)"npm.searching_for_previously_installed_package", (Object[])objectArray));
                String installedPackage = this.$loader.getAbsolutePath(this.$project);
                indicator.setText2(null);
                if (installedPackage != null) {
                    LspServerDownloadingKt.access$getLog$p().info("[attempt #" + this.$attemptId + "] Package " + this.$serverPackage + " is ready, skipping download");
                    this.$loader.restartService(this.$project);
                    return;
                }
                Path packagePath = LspServerDownloadingKt.access$downloadPackageSync(this.$project, indicator, this.$serverPackage);
                LspServerDownloadingKt.access$getLog$p().info("[attempt #" + this.$attemptId + "] Package " + this.$serverPackage + " has been downloaded to " + packagePath);
                if (packagePath != null) {
                    this.$loader.restartService(this.$project);
                }
            }

            public void onFinished() {
                this.$onDownloadFinished.invoke();
            }
        }.queue();
    }

    private static final Path downloadPackageSync(Project project, ProgressIndicator indicator, TypeScriptPackageName npmPackage) {
        TypeScriptExternalDefinitionsRegistry definitionsRegistry = TypeScriptExternalDefinitionsRegistry.Companion.getInstance();
        Future<Path> future = definitionsRegistry.installPackageWithoutVfsRefresh$intellij_javascript_backend(npmPackage, project, indicator);
        try {
            return future.get(2L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{npmPackage.getName()};
            log.info(JavaScriptBundle.message((String)"npm.failed_to_install_package.title.message", (Object[])objectArray), (Throwable)e);
            return null;
        }
    }

    public static final /* synthetic */ Logger access$getLog$p() {
        return log;
    }

    public static final /* synthetic */ void access$scheduleDownloadingTask(Project project, JSServiceLoader loader, int attemptId, Function0 onDownloadFinished) {
        LspServerDownloadingKt.scheduleDownloadingTask(project, loader, attemptId, (Function0<Unit>)onDownloadFinished);
    }

    public static final /* synthetic */ Path access$downloadPackageSync(Project project, ProgressIndicator indicator, TypeScriptPackageName npmPackage) {
        return LspServerDownloadingKt.downloadPackageSync(project, indicator, npmPackage);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LspDownloadService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }
}

