/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.typescript.intentions.TypeScriptReferencesLibraryFix;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.psi.TypeScriptReferencePathValidator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;

public class TypeScriptReferencePathValidatorImpl
implements TypeScriptReferencePathValidator {
    public static final TypeScriptReferencePathValidator INSTANCE = new TypeScriptReferencePathValidatorImpl();
    private static final Key<ParameterizedCachedValue<List<VirtualFile>, JSFile>> OUT_OF_PROJECT_REFERENCES_KEY = Key.create((String)"TS.FILES.OUT.OF.PROJECT.REFS");
    private static final ParameterizedCachedValueProvider<List<VirtualFile>, JSFile> OUT_OF_PROJECT_REFERENCES_PROVIDER = file -> {
        Project project = file.getProject();
        PsiFile originalFile = JSResolveUtil.getOriginalFile((PsiElement)file);
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)originalFile);
        if (virtualFile == null) {
            return CachedValueProvider.Result.create((Object)ContainerUtil.emptyList(), (Object[])new Object[]{file});
        }
        Object[] includedFiles = FileIncludeManager.getManager((Project)project).getIncludedFiles(virtualFile, true, true);
        if (includedFiles.length == 0) {
            return CachedValueProvider.Result.create((Object)ContainerUtil.emptyList(), (Object[])new Object[]{file});
        }
        GlobalSearchScope scope2 = TypeScriptReferencePathValidatorImpl.getAllScope(file);
        List outOfProjectFiles = ContainerUtil.filter((Object[])includedFiles, file1 -> !scope2.accept(file1) && TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(file1.getFileType()));
        ArrayList<JSFile> depends = new ArrayList<JSFile>(outOfProjectFiles.size() + 1);
        depends.add((JSFile)file);
        depends.addAll(outOfProjectFiles);
        return CachedValueProvider.Result.create((Object)outOfProjectFiles, depends);
    };

    public boolean hasOutOfProjectReferences(@NotNull JSFile file) {
        if (file == null) {
            TypeScriptReferencePathValidatorImpl.$$$reportNull$$$0(0);
        }
        return !this.getOutOfProjectReferences(file).isEmpty();
    }

    @NotNull
    public Collection<VirtualFile> getOutOfProjectReferences(@NotNull JSFile file) {
        List value;
        if (file == null) {
            TypeScriptReferencePathValidatorImpl.$$$reportNull$$$0(1);
        }
        List list = (value = (List)CachedValuesManager.getManager((Project)file.getProject()).getParameterizedCachedValue((UserDataHolder)file, OUT_OF_PROJECT_REFERENCES_KEY, OUT_OF_PROJECT_REFERENCES_PROVIDER, false, (Object)file)) == null ? ContainerUtil.emptyList() : value;
        if (list == null) {
            TypeScriptReferencePathValidatorImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void checkReferences(@NotNull PsiComment comment, @NotNull AnnotationHolder holder, boolean error) {
        PsiElement parent;
        if (comment == null) {
            TypeScriptReferencePathValidatorImpl.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            TypeScriptReferencePathValidatorImpl.$$$reportNull$$$0(4);
        }
        if (!((parent = comment.getParent()) instanceof JSFile)) {
            return;
        }
        JSFile file = (JSFile)parent;
        if (!this.hasOutOfProjectReferences(file)) {
            return;
        }
        GlobalSearchScope scope2 = TypeScriptReferencePathValidatorImpl.getAllScope(file);
        if (!scope2.accept(file.getVirtualFile())) {
            return;
        }
        Matcher matcher = TypeScriptPsiUtil.TYPESCRIPT_REFERENCE_PATH.matcher(comment.getText());
        if (!matcher.matches()) {
            return;
        }
        TypeScriptLibraryProvider libraryProvider = TypeScriptLibraryProvider.getService((Project)comment.getProject());
        boolean valid = true;
        for (PsiReference reference : comment.getReferences()) {
            PsiElement resolve;
            if (reference instanceof FileReference && !((FileReference)reference).isLast() || !((resolve = reference.resolve()) instanceof JSFile)) continue;
            JSFile resolvedFile = (JSFile)resolve;
            if (!DialectDetector.isTypeScript((PsiElement)resolve) || libraryProvider.isLibraryFile(resolvedFile.getVirtualFile())) continue;
            if (!scope2.accept(resolvedFile.getVirtualFile())) {
                valid = false;
                break;
            }
            if (!this.hasOutOfProjectReferences(resolvedFile)) continue;
            valid = false;
            error = false;
            break;
        }
        if (!valid) {
            this.createErrorAnnotationWithQuickFix(file, comment, holder, error);
        }
    }

    @NotNull
    private static GlobalSearchScope getAllScope(@NotNull JSFile file) {
        if (file == null) {
            TypeScriptReferencePathValidatorImpl.$$$reportNull$$$0(5);
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)file.getProject());
        if (globalSearchScope == null) {
            TypeScriptReferencePathValidatorImpl.$$$reportNull$$$0(6);
        }
        return globalSearchScope;
    }

    public void createErrorAnnotationWithQuickFix(@NotNull JSFile file, @NotNull PsiComment host, @NotNull AnnotationHolder holder, boolean error) {
        if (file == null) {
            TypeScriptReferencePathValidatorImpl.$$$reportNull$$$0(7);
        }
        if (host == null) {
            TypeScriptReferencePathValidatorImpl.$$$reportNull$$$0(8);
        }
        if (holder == null) {
            TypeScriptReferencePathValidatorImpl.$$$reportNull$$$0(9);
        }
        Collection<VirtualFile> files = this.getOutOfProjectReferences(file);
        assert (!files.isEmpty());
        ProblemHighlightType type2 = error ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.WEAK_WARNING;
        new JSAnnotatorProblemReporter(holder).registerProblem((PsiElement)host, null, JavaScriptBundle.message((String)"inspection.message.reference.includes.files.outside.project", (Object[])new Object[0]), type2, null, LocalQuickFix.EMPTY_ARRAY, new IntentionAction[]{new TypeScriptReferencesLibraryFix((PsiElement)host)});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/psi/TypeScriptReferencePathValidatorImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/psi/TypeScriptReferencePathValidatorImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutOfProjectReferences";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasOutOfProjectReferences";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOutOfProjectReferences";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkReferences";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllScope";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createErrorAnnotationWithQuickFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6 -> new IllegalStateException(string);
        };
    }
}

