/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.actions;

import com.intellij.compiler.actions.CompileActionBase;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.task.ProjectTaskManager;
import com.intellij.util.ArrayUtil;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class MakeModuleAction
extends CompileActionBase {
    private static final Logger LOG = Logger.getInstance(MakeModuleAction.class);

    @Override
    protected void doAction(@NotNull DataContext dataContext, Project project) {
        if (dataContext == null) {
            MakeModuleAction.$$$reportNull$$$0(0);
        }
        try {
            Module[] modules = (Module[])dataContext.getData(LangDataKeys.MODULE_CONTEXT_ARRAY);
            if (modules != null) {
                ProjectTaskManager.getInstance((Project)project).build(modules);
            } else {
                Module module = (Module)dataContext.getData(PlatformCoreDataKeys.MODULE);
                if (module != null) {
                    ProjectTaskManager.getInstance((Project)project).build(new Module[]{module});
                }
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        String presentationText;
        if (event == null) {
            MakeModuleAction.$$$reportNull$$$0(1);
        }
        super.update(event);
        Presentation presentation = event.getPresentation();
        if (!presentation.isEnabled()) {
            return;
        }
        boolean isEnabled = false;
        Object[] modules = (Module[])event.getData(LangDataKeys.MODULE_CONTEXT_ARRAY);
        if (modules != null) {
            String moduleNames;
            isEnabled = true;
            if (ArrayUtil.contains(null, (Object[])modules)) {
                DataContext dataContext = event.getDataContext();
                LOG.error("Unexpected null module slipped through validator; dataContext = " + String.valueOf(dataContext) + "; class = " + dataContext.getClass().getName());
            }
            presentationText = modules.length == 1 ? JavaCompilerBundle.message((String)"action.make.single.module.text", (Object[])new Object[]{modules[0].getName()}) : ((moduleNames = (String)Stream.of(modules).map(m -> "'" + m.getName() + "'").collect(NlsMessages.joiningNarrowAnd())).length() > 20 ? JavaCompilerBundle.message((String)"action.make.selected.modules.text", (Object[])new Object[0]) : JavaCompilerBundle.message((String)"action.make.few.modules.text", (Object[])new Object[]{moduleNames}));
        } else if (!event.isFromContextMenu()) {
            Module module = (Module)event.getData(PlatformCoreDataKeys.MODULE);
            if (module != null) {
                isEnabled = true;
                presentationText = JavaCompilerBundle.message((String)"action.make.single.module.text", (Object[])new Object[]{module.getName()});
            } else {
                presentationText = this.getTemplatePresentation().getTextWithMnemonic();
            }
        } else {
            presentationText = this.getTemplatePresentation().getTextWithMnemonic();
        }
        presentation.setText(presentationText);
        presentation.setEnabled(isEnabled);
        presentation.setVisible(isEnabled || !"ProjectViewPopup".equals(event.getPlace()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/compiler/actions/MakeModuleAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

