/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.backwardRefs.JavaCompilerElementRetriever;
import com.intellij.compiler.backwardRefs.LanguageCompilerRefAdapter;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.Processor;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.CompilerRef;
import org.jetbrains.jps.backwardRefs.NameEnumerator;

public class JavaCompilerRefAdapter
implements LanguageCompilerRefAdapter {
    @Override
    @NotNull
    public Set<FileType> getFileTypes() {
        Set<JavaClassFileType> set = Set.of(JavaFileType.INSTANCE, JavaClassFileType.INSTANCE);
        if (set == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    public CompilerRef asCompilerRef(@NotNull PsiElement element, @NotNull NameEnumerator names) throws IOException {
        if (element == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(1);
        }
        if (names == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(2);
        }
        if (JavaCompilerRefAdapter.mayBeVisibleOutsideOwnerFile(element)) {
            String jvmClassName;
            if (element instanceof PsiField) {
                PsiField field = (PsiField)element;
                PsiClass aClass = field.getContainingClass();
                if (aClass == null || aClass instanceof PsiAnonymousClass) {
                    return null;
                }
                String jvmOwnerName = ClassUtil.getJVMClassName((PsiClass)aClass);
                String name = field.getName();
                if (jvmOwnerName == null) {
                    return null;
                }
                int ownerId = names.tryEnumerate((Object)jvmOwnerName);
                int nameId = names.tryEnumerate((Object)name);
                return new CompilerRef.JavaCompilerFieldRef(ownerId, nameId);
            }
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                PsiClass aClass = method.getContainingClass();
                if (aClass == null || aClass instanceof PsiAnonymousClass) {
                    return null;
                }
                String jvmOwnerName = ClassUtil.getJVMClassName((PsiClass)aClass);
                if (jvmOwnerName == null) {
                    return null;
                }
                String name = method.isConstructor() ? "<init>" : method.getName();
                int parametersCount = method.getParameterList().getParametersCount();
                int ownerId = names.tryEnumerate((Object)jvmOwnerName);
                int nameId = names.tryEnumerate((Object)name);
                return new CompilerRef.JavaCompilerMethodRef(ownerId, nameId, parametersCount);
            }
            if (element instanceof PsiClass && (jvmClassName = ClassUtil.getJVMClassName((PsiClass)((PsiClass)element))) != null) {
                int nameId = names.tryEnumerate((Object)jvmClassName);
                return new CompilerRef.JavaCompilerClassRef(nameId);
            }
        }
        return null;
    }

    @Override
    public boolean isTooCommonLibraryElement(@NotNull PsiElement element) {
        if (element == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(3);
        }
        String qualifiedName = (String)ReadAction.compute(() -> {
            PsiClass value = element instanceof PsiClass ? (PsiClass)element : ((PsiMember)element).getContainingClass();
            PsiClass baseClass = Objects.requireNonNull(value);
            return baseClass.getQualifiedName();
        });
        return "java.lang.Object".equals(qualifiedName);
    }

    @Override
    @NotNull
    public List<CompilerRef> getHierarchyRestrictedToLibraryScope(@NotNull CompilerRef baseRef, @NotNull PsiElement basePsi, @NotNull NameEnumerator names, @NotNull GlobalSearchScope libraryScope) throws IOException {
        if (baseRef == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(4);
        }
        if (basePsi == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(5);
        }
        if (names == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(6);
        }
        if (libraryScope == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(7);
        }
        @Nullable PsiClass value = basePsi instanceof PsiClass ? (PsiClass)basePsi : ((PsiMember)ReadAction.compute(() -> (PsiMember)basePsi)).getContainingClass();
        PsiClass baseClass = Objects.requireNonNull(value);
        ArrayList<CompilerRef> overridden = new ArrayList<CompilerRef>();
        IOException[] exception = new IOException[]{null};
        Processor processor = c -> {
            if (c.hasModifierProperty("private")) {
                return true;
            }
            String qName = (String)ReadAction.compute(() -> c.getQualifiedName());
            if (qName == null) {
                return true;
            }
            try {
                int nameId = names.tryEnumerate((Object)qName);
                overridden.add(baseRef.override(nameId));
            }
            catch (IOException e) {
                exception[0] = e;
                return false;
            }
            return true;
        };
        ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)libraryScope, (boolean)true).forEach(processor);
        if (exception[0] != null) {
            throw exception[0];
        }
        ArrayList<CompilerRef> arrayList = overridden;
        if (arrayList == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Class<? extends CompilerRef.CompilerClassHierarchyElementDef> getHierarchyObjectClass() {
        return CompilerRef.CompilerClassHierarchyElementDef.class;
    }

    @Override
    @NotNull
    public Class<? extends CompilerRef> getFunExprClass() {
        return CompilerRef.JavaCompilerFunExprDef.class;
    }

    public PsiClass @NotNull [] findDirectInheritorCandidatesInFile(SearchId @NotNull [] internalNames, @NotNull PsiFileWithStubSupport file) {
        if (file == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(9);
        }
        if (internalNames == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(10);
        }
        PsiClass[] psiClassArray = JavaCompilerElementRetriever.retrieveClassesByInternalIds(internalNames, file);
        if (psiClassArray == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(11);
        }
        return psiClassArray;
    }

    public PsiFunctionalExpression @NotNull [] findFunExpressionsInFile(SearchId @NotNull [] funExpressions, @NotNull PsiFileWithStubSupport file) {
        if (file == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(12);
        }
        if (funExpressions == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(13);
        }
        IntOpenHashSet requiredIndices = new IntOpenHashSet(funExpressions.length);
        for (SearchId funExpr : funExpressions) {
            requiredIndices.add(funExpr.getId());
        }
        PsiFunctionalExpression[] psiFunctionalExpressionArray = JavaCompilerElementRetriever.retrieveFunExpressionsByIndices((IntSet)requiredIndices, file);
        if (psiFunctionalExpressionArray == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(14);
        }
        return psiFunctionalExpressionArray;
    }

    @Override
    public boolean isClass(@NotNull PsiElement element) {
        if (element == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(15);
        }
        return element instanceof PsiClass;
    }

    @Override
    public PsiElement @NotNull [] getInstantiableConstructors(@NotNull PsiElement aClass) {
        if (aClass == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(16);
        }
        if (!(aClass instanceof PsiClass)) {
            throw new IllegalArgumentException("parameter should be an instance of PsiClass: " + String.valueOf(aClass));
        }
        PsiClass theClass = (PsiClass)aClass;
        if (theClass.hasModifierProperty("abstract")) {
            if (PsiElement.EMPTY_ARRAY == null) {
                JavaCompilerRefAdapter.$$$reportNull$$$0(17);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = (PsiElement[])Stream.of(theClass.getConstructors()).filter(c -> !c.hasModifierProperty("private")).toArray(s -> (PsiElement[])PsiElement.ARRAY_FACTORY.create(s));
        if (psiElementArray == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(18);
        }
        return psiElementArray;
    }

    @Override
    public boolean isDirectInheritor(PsiElement candidate, PsiNamedElement baseClass) {
        return ((PsiClass)candidate).isInheritor((PsiClass)baseClass, false);
    }

    private static boolean mayBeVisibleOutsideOwnerFile(@NotNull PsiElement element) {
        if (element == null) {
            JavaCompilerRefAdapter.$$$reportNull$$$0(19);
        }
        if (!(element instanceof PsiModifierListOwner)) {
            return true;
        }
        return !((PsiModifierListOwner)element).hasModifierProperty("private");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 9, 10, 12, 13, 15, 16, 19 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/backwardRefs/JavaCompilerRefAdapter";
                break;
            }
            case 1: 
            case 3: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseRef";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePsi";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryScope";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalNames";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funExpressions";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypes";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/backwardRefs/JavaCompilerRefAdapter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchyRestrictedToLibraryScope";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findDirectInheritorCandidatesInFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findFunExpressionsInFile";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstantiableConstructors";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "asCompilerRef";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isTooCommonLibraryElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getHierarchyRestrictedToLibraryScope";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findDirectInheritorCandidatesInFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findFunExpressionsInFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isClass";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getInstantiableConstructors";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "mayBeVisibleOutsideOwnerFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 9, 10, 12, 13, 15, 16, 19 -> new IllegalArgumentException(string);
        };
    }
}

