/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.cache.ui;

import com.intellij.DynamicBundle;
import com.intellij.compiler.cache.CompilerCacheLoadingSettings;
import com.intellij.compiler.options.ComparingUtils;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class CompilerCacheConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private JPanel myPanel;
    private final Project myProject;
    private JBLabel myForceUpdateDescription;
    private JBCheckBox myCbForceUpdateCaches;
    private JBCheckBox myCbDisableCacheDownload;
    private JTextField myMaxDownloadDurationField;
    private JBLabel myMaxDownloadDurationDescription;
    private JBCheckBox myCbCleanupAsynchronously;
    private JBLabel myCleanupAsynchronouslyDescription;

    public CompilerCacheConfigurable(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myForceUpdateDescription.setText("<html>Turn off the heuristic that determines when it's faster to download cache or build locally and force downloads the nearest cache at each build</html>");
        this.myMaxDownloadDurationDescription.setText("<html>Set maximum applicable time of caches download. If the approximate time of work will be higher local build will be executed.</html>");
        this.myCleanupAsynchronouslyDescription.setText("<html>Removes old cache directories asynchronously. This option might produce garbage under 'system/plugins' and spawn long-living rsync processes.</html>");
    }

    public String getDisplayName() {
        return JavaCompilerBundle.message((String)"compiler.cache.description", (Object[])new Object[0]);
    }

    @NotNull
    public String getId() {
        return "reference.projectsettings.compiler.compilercache";
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        boolean isModified = ComparingUtils.isModified((JCheckBox)this.myCbForceUpdateCaches, CompilerCacheLoadingSettings.getForceUpdateValue());
        isModified |= ComparingUtils.isModified((JCheckBox)this.myCbDisableCacheDownload, CompilerCacheLoadingSettings.getDisableUpdateValue());
        isModified |= ComparingUtils.isModified((JCheckBox)this.myCbCleanupAsynchronously, CompilerCacheLoadingSettings.getCleanupAsynchronouslyValue());
        return isModified |= ComparingUtils.isModified(this.myMaxDownloadDurationField, String.valueOf(CompilerCacheLoadingSettings.getMaxDownloadDuration()));
    }

    public void apply() throws ConfigurationException {
        try {
            CompilerCacheLoadingSettings.saveForceUpdateValue(this.myCbForceUpdateCaches.isSelected());
            CompilerCacheLoadingSettings.saveDisableUpdateValue(this.myCbDisableCacheDownload.isSelected());
            CompilerCacheLoadingSettings.saveCleanupAsynchronouslyValue(this.myCbCleanupAsynchronously.isSelected());
            CompilerCacheLoadingSettings.saveMaxDownloadDuration(Integer.parseInt(this.myMaxDownloadDurationField.getText()));
        }
        finally {
            if (!this.myProject.isDefault()) {
                BuildManager.getInstance().clearState(this.myProject);
            }
        }
    }

    public void reset() {
        this.myCbForceUpdateCaches.setSelected(CompilerCacheLoadingSettings.getForceUpdateValue());
        this.myCbDisableCacheDownload.setSelected(CompilerCacheLoadingSettings.getDisableUpdateValue());
        this.myCbCleanupAsynchronously.setSelected(CompilerCacheLoadingSettings.getCleanupAsynchronouslyValue());
        this.myMaxDownloadDurationField.setText(String.valueOf(CompilerCacheLoadingSettings.getMaxDownloadDuration()));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBCheckBox jBCheckBox;
        JTextField jTextField;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCbForceUpdateCaches = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/JavaCompilerBundle", CompilerCacheConfigurable.class).getString("compiler.cache.option.force.update"));
        jPanel.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbDisableCacheDownload = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/JavaCompilerBundle", CompilerCacheConfigurable.class).getString("compiler.cache.option.disable.update"));
        jPanel.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel4.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel4.setText("Turn off the caches download for example when you have a limited internet connection.");
        jPanel.add((Component)jBLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 1, null, null, null, 2));
        this.myMaxDownloadDurationDescription = jBLabel3 = new JBLabel();
        jBLabel3.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel3.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel3.setText("");
        jPanel.add((Component)jBLabel3, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myForceUpdateDescription = jBLabel2 = new JBLabel();
        jBLabel2.setBackground(new Color(-1907998));
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel2.setHorizontalAlignment(10);
        jBLabel2.setHorizontalTextPosition(11);
        jBLabel2.setText("");
        jBLabel2.setVerticalAlignment(0);
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 3, null, null, null, 2));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(6, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(883, 34), null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/JavaCompilerBundle", CompilerCacheConfigurable.class).getString("compiler.cache.option.max.download.time"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myMaxDownloadDurationField = jTextField = new JTextField();
        jTextField.setColumns(5);
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, DynamicBundle.getBundle((String)"messages/JavaCompilerBundle", CompilerCacheConfigurable.class).getString("compiler.cache.option.max.download.time.units"));
        jPanel2.add((Component)jBLabel5, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCbCleanupAsynchronously = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/JavaCompilerBundle", CompilerCacheConfigurable.class).getString("compiler.cache.option.cleanup.asynchronously"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myCleanupAsynchronouslyDescription = jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel.setText("");
        jPanel.add((Component)jBLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 1, null, null, null, 2));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

