/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.NlsContexts;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u000b\u001a\u00060\fR\u00020\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/compiler/impl/CompileDriverNotifications;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "currentNotification", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/notification/Notification;", "dispose", "", "createCannotStartNotification", "Lcom/intellij/compiler/impl/CompileDriverNotifications$LightNotification;", "Companion", "LightNotification", "intellij.java.compiler.impl"})
public final class CompileDriverNotifications
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicReference<Notification> currentNotification;

    public CompileDriverNotifications(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.currentNotification = new AtomicReference<Object>(null);
    }

    public void dispose() {
        this.currentNotification.set(null);
    }

    @NotNull
    public final LightNotification createCannotStartNotification() {
        return new LightNotification();
    }

    @JvmStatic
    @NotNull
    public static final CompileDriverNotifications getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/compiler/impl/CompileDriverNotifications$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/compiler/impl/CompileDriverNotifications;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.java.compiler.impl"})
    @SourceDebugExtension(value={"SMAP\nCompileDriverNotifications.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompileDriverNotifications.kt\ncom/intellij/compiler/impl/CompileDriverNotifications$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,95:1\n30#2,2:96\n*S KotlinDebug\n*F\n+ 1 CompileDriverNotifications.kt\ncom/intellij/compiler/impl/CompileDriverNotifications$Companion\n*L\n28#1:96,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CompileDriverNotifications getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<CompileDriverNotifications> serviceClass$iv = CompileDriverNotifications.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (CompileDriverNotifications)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\f\u001a\u00060\u0000R\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J$\u0010\u0013\u001a\u00060\u0000R\u00020\r2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u000fH\u0007J\u0014\u0010\u0016\u001a\u00060\u0000R\u00020\r2\b\b\u0001\u0010\u0017\u001a\u00020\u000fJ\u0006\u0010\u0018\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/compiler/impl/CompileDriverNotifications$LightNotification;", "", "<init>", "(Lcom/intellij/compiler/impl/CompileDriverNotifications;)V", "isShown", "Ljava/util/concurrent/atomic/AtomicBoolean;", "notificationGroup", "Lcom/intellij/notification/NotificationGroup;", "kotlin.jvm.PlatformType", "baseNotification", "Lcom/intellij/notification/Notification;", "Lorg/jetbrains/annotations/NotNull;", "withExpiringAction", "Lcom/intellij/compiler/impl/CompileDriverNotifications;", "title", "", "handler", "Lkotlin/Function0;", "", "withOpenSettingsAction", "moduleNameToSelect", "tabNameToSelect", "withContent", "content", "showNotification", "intellij.java.compiler.impl"})
    @SourceDebugExtension(value={"SMAP\nCompileDriverNotifications.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompileDriverNotifications.kt\ncom/intellij/compiler/impl/CompileDriverNotifications$LightNotification\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,95:1\n23#2:96\n*S KotlinDebug\n*F\n+ 1 CompileDriverNotifications.kt\ncom/intellij/compiler/impl/CompileDriverNotifications$LightNotification\n*L\n76#1:96\n*E\n"})
    public final class LightNotification {
        @NotNull
        private final AtomicBoolean isShown = new AtomicBoolean();
        private final NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("jps configuration error");
        @NotNull
        private final Notification baseNotification;

        public LightNotification() {
            String string = JavaCompilerBundle.message((String)"notification.title.jps.cannot.start.compiler", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Notification notification = this.notificationGroup.createNotification(string, NotificationType.ERROR).setImportant(true);
            Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"setImportant(...)");
            this.baseNotification = notification;
        }

        @NotNull
        public final LightNotification withExpiringAction(@NlsContexts.NotificationContent @NotNull String title, @NotNull Function0<Unit> handler) {
            LightNotification lightNotification;
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            LightNotification $this$withExpiringAction_u24lambda_u240 = lightNotification = this;
            boolean bl = false;
            $this$withExpiringAction_u24lambda_u240.baseNotification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)title, () -> LightNotification.withExpiringAction$lambda$0$0(handler)));
            return lightNotification;
        }

        @JvmOverloads
        @NotNull
        public final LightNotification withOpenSettingsAction(@Nullable String moduleNameToSelect, @Nullable String tabNameToSelect) {
            String string = JavaCompilerBundle.message((String)"notification.action.jps.open.configuration.dialog", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return this.withExpiringAction(string, (Function0<Unit>)((Function0)() -> LightNotification.withOpenSettingsAction$lambda$0(CompileDriverNotifications.this, moduleNameToSelect, tabNameToSelect)));
        }

        public static /* synthetic */ LightNotification withOpenSettingsAction$default(LightNotification lightNotification, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            return lightNotification.withOpenSettingsAction(string, string2);
        }

        @NotNull
        public final LightNotification withContent(@NlsContexts.NotificationContent @NotNull String content) {
            LightNotification lightNotification;
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            LightNotification $this$withContent_u24lambda_u240 = lightNotification = this;
            boolean bl = false;
            $this$withContent_u24lambda_u240.baseNotification.setContent(content);
            return lightNotification;
        }

        public final void showNotification() {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LightNotification $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(LightNotification.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error(this.baseNotification.getContent());
                return;
            }
            if (!this.isShown.compareAndSet(false, true)) {
                return;
            }
            Runnable showNotification = () -> LightNotification.showNotification$lambda$0(this, CompileDriverNotifications.this);
            showNotification.run();
        }

        @JvmOverloads
        @NotNull
        public final LightNotification withOpenSettingsAction(@Nullable String moduleNameToSelect) {
            return LightNotification.withOpenSettingsAction$default(this, moduleNameToSelect, null, 2, null);
        }

        @JvmOverloads
        @NotNull
        public final LightNotification withOpenSettingsAction() {
            return LightNotification.withOpenSettingsAction$default(this, null, null, 3, null);
        }

        private static final void withExpiringAction$lambda$0$0(Function0 $tmp0) {
            $tmp0.invoke();
        }

        private static final Unit withOpenSettingsAction$lambda$0(CompileDriverNotifications this$0, String $moduleNameToSelect, String $tabNameToSelect) {
            ProjectSettingsService service = ProjectSettingsService.getInstance((Project)this$0.project);
            if ($moduleNameToSelect != null) {
                service.showModuleConfigurationDialog($moduleNameToSelect, $tabNameToSelect);
            } else {
                service.openProjectSettings();
            }
            return Unit.INSTANCE;
        }

        private static final void showNotification$lambda$0$0(CompileDriverNotifications this$0, LightNotification this$1) {
            this$0.currentNotification.compareAndExchange(this$1.baseNotification, null);
        }

        private static final void showNotification$lambda$0(LightNotification this$0, CompileDriverNotifications this$1) {
            this$0.baseNotification.whenExpired(() -> LightNotification.showNotification$lambda$0$0(this$1, this$0));
            Notification notification = this$1.currentNotification.getAndSet(this$0.baseNotification);
            if (notification != null) {
                notification.expire();
            }
            this$0.baseNotification.notify(this$1.project);
        }
    }
}

