/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.MalformedPatternException;
import com.intellij.compiler.options.CompilerOptionsFilter;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.options.ConfigurationException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import java.util.StringTokenizer;

public final class CompilerUIConfigurable {
    static final Set<CompilerOptionsFilter.Setting> EXTERNAL_BUILD_SETTINGS = EnumSet.of(CompilerOptionsFilter.Setting.EXTERNAL_BUILD, new CompilerOptionsFilter.Setting[]{CompilerOptionsFilter.Setting.AUTO_MAKE, CompilerOptionsFilter.Setting.PARALLEL_COMPILATION, CompilerOptionsFilter.Setting.REBUILD_MODULE_ON_DEPENDENCY_CHANGE, CompilerOptionsFilter.Setting.HEAP_SIZE, CompilerOptionsFilter.Setting.COMPILER_VM_OPTIONS});

    static String patternsToString(String[] patterns) {
        StringBuilder extensionsString = new StringBuilder();
        for (int idx = 0; idx < patterns.length; ++idx) {
            if (idx > 0) {
                extensionsString.append(";");
            }
            extensionsString.append(patterns[idx]);
        }
        return extensionsString.toString();
    }

    public static void applyResourcePatterns(String extensionString, CompilerConfigurationImpl configuration) throws ConfigurationException {
        StringTokenizer tokenizer = new StringTokenizer(extensionString, ";", false);
        ArrayList<String[]> errors = new ArrayList<String[]>();
        while (tokenizer.hasMoreTokens()) {
            String namePattern = tokenizer.nextToken();
            try {
                configuration.addResourceFilePattern(namePattern);
            }
            catch (MalformedPatternException e) {
                errors.add(new String[]{namePattern, e.getLocalizedMessage()});
            }
        }
        if (!errors.isEmpty()) {
            StringBuilder patternsWithError = new StringBuilder();
            for (Object e : errors) {
                String[] pair = (String[])e;
                patternsWithError.append("\n");
                patternsWithError.append(pair[0]);
                patternsWithError.append(": ");
                patternsWithError.append(pair[1]);
            }
            throw new ConfigurationException(JavaCompilerBundle.message((String)"error.compiler.configurable.malformed.patterns", (Object[])new Object[]{patternsWithError.toString()}), JavaCompilerBundle.message((String)"bad.resource.patterns.dialog.title", (Object[])new Object[0]));
        }
    }
}

