/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.compiler.options.ModuleOptionsTableModel;
import com.intellij.compiler.options.ModuleTableCellRenderer;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.ui.JBColor;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.ui.GridBag;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JpsJavaSdkType;

public class TargetOptionsComponent
extends JPanel {
    private static final String[] KNOWN_TARGETS;
    private final ComboBox<String> myCbProjectTargetLevel;
    private final JBTable myTable;
    private final Project myProject;

    public TargetOptionsComponent(@NotNull Project project) {
        if (project == null) {
            TargetOptionsComponent.$$$reportNull$$$0(0);
        }
        super(new GridBagLayout());
        this.myProject = project;
        this.myCbProjectTargetLevel = TargetOptionsComponent.createTargetOptionsCombo();
        this.myTable = new JBTable((TableModel)new ModuleOptionsTableModel());
        this.myTable.setShowGrid(false);
        this.myTable.setRowHeight(JBUIScale.scale((int)22));
        this.myTable.getEmptyText().setText(JavaCompilerBundle.message((String)"settings.all.modules.will.be.compiled.with.project.bytecode.version", (Object[])new Object[0]));
        TableColumn moduleColumn = this.myTable.getColumnModel().getColumn(0);
        moduleColumn.setHeaderValue(JavaCompilerBundle.message((String)"settings.module.column", (Object[])new Object[0]));
        moduleColumn.setCellRenderer(new ModuleTableCellRenderer());
        TableColumn targetLevelColumn = this.myTable.getColumnModel().getColumn(1);
        String columnTitle = JavaCompilerBundle.message((String)"settings.target.bytecode.version", (Object[])new Object[0]);
        targetLevelColumn.setHeaderValue(columnTitle);
        targetLevelColumn.setCellEditor(new TargetLevelCellEditor());
        targetLevelColumn.setCellRenderer(new TargetLevelCellRenderer());
        int width = this.myTable.getFontMetrics(this.myTable.getFont()).stringWidth(columnTitle) + 10;
        targetLevelColumn.setPreferredWidth(width);
        targetLevelColumn.setMinWidth(width);
        targetLevelColumn.setMaxWidth(width);
        TableSpeedSearch.installOn((JTable)this.myTable);
        GridBag constraints = new GridBag().setDefaultAnchor(17).setDefaultWeightX(1.0).setDefaultWeightY(1.0).setDefaultFill(0).setDefaultInsets(6, 0, 0, 0);
        JLabel label = new JLabel(JavaCompilerBundle.message((String)"settings.project.bytecode.version", (Object[])new Object[0]));
        label.setLabelFor((Component)this.myCbProjectTargetLevel);
        this.add((Component)label, constraints.nextLine().next().weightx(0.0));
        this.add((Component)this.myCbProjectTargetLevel, constraints.next());
        this.add((Component)new JLabel(JavaCompilerBundle.message((String)"settings.per.module.bytecode.version", (Object[])new Object[0])), constraints.nextLine().weightx(0.0));
        JPanel tableComp = ToolbarDecorator.createDecorator((JTable)this.myTable).disableUpAction().disableDownAction().setAddAction(b -> this.addModules()).setRemoveAction(b -> this.removeSelectedModules()).createPanel();
        tableComp.setPreferredSize(new Dimension(this.myTable.getWidth(), 150));
        this.add((Component)tableComp, constraints.nextLine().fillCell().coverLine());
    }

    private static ComboBox<String> createTargetOptionsCombo() {
        ComboBox combo = new ComboBox((Object[])KNOWN_TARGETS);
        combo.insertItemAt(null, 0);
        combo.setRenderer(BuilderKt.textListCellRenderer((String)JavaCompilerBundle.message((String)"settings.same.as.language.level", (Object[])new Object[0]), String::toString));
        return combo;
    }

    private void addModules() {
        int i = ((ModuleOptionsTableModel)this.myTable.getModel()).addModulesToModel(this.myProject, this);
        if (i != -1) {
            TableUtil.selectRows((JTable)this.myTable, (int[])new int[]{i});
            TableUtil.scrollSelectionToVisible((JTable)this.myTable);
        }
    }

    private void removeSelectedModules() {
        if (this.myTable.getSelectedRows().length > 0) {
            TableUtil.removeSelectedItems((JTable)this.myTable);
        }
    }

    public void setProjectBytecodeTargetLevel(@NlsSafe String level) {
        this.myCbProjectTargetLevel.setSelectedItem((Object)level);
    }

    @Nullable
    public String getProjectBytecodeTarget() {
        String item = (String)this.myCbProjectTargetLevel.getSelectedItem();
        if (item == null) {
            return item;
        }
        return item.trim();
    }

    public Map<String, String> getModulesBytecodeTargetMap() {
        return ((ModuleOptionsTableModel)this.myTable.getModel()).getModuleOptions();
    }

    public void setModuleTargetLevels(Map<String, String> moduleLevels) {
        ((ModuleOptionsTableModel)this.myTable.getModel()).setModuleOptions(this.myProject, moduleLevels);
    }

    static {
        ArrayList<String> targets = new ArrayList<String>();
        targets.add("1.1");
        targets.add("1.2");
        for (LanguageLevel level : LanguageLevel.getEntries()) {
            if (level == LanguageLevel.JDK_X || level.isPreview()) continue;
            targets.add(JpsJavaSdkType.complianceOption((JavaVersion)level.toJavaVersion()));
        }
        Collections.reverse(targets);
        KNOWN_TARGETS = ArrayUtilRt.toStringArray(targets);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/options/TargetOptionsComponent", "<init>"));
    }

    private static final class TargetLevelCellEditor
    extends DefaultCellEditor {
        private TargetLevelCellEditor() {
            super((JComboBox<?>)TargetOptionsComponent.createTargetOptionsCombo());
            this.setClickCountToStart(0);
        }
    }

    private static class TargetLevelCellRenderer
    extends DefaultTableCellRenderer {
        private TargetLevelCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (component instanceof JLabel) {
                JLabel comp = (JLabel)component;
                comp.setHorizontalAlignment(0);
                if ("".equals(value)) {
                    comp.setForeground((Color)JBColor.GRAY);
                    comp.setText(JavaCompilerBundle.message((String)"settings.same.as.language.level", (Object[])new Object[0]));
                } else {
                    comp.setForeground(table.getForeground());
                }
            }
            return component;
        }
    }
}

