/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.intellij.compiler.YourKitProfilerService;
import com.intellij.compiler.server.BuildCommandLineBuilder;
import com.intellij.compiler.server.EelBuildManagerScopeProvider;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.EelPlatformKt;
import com.intellij.platform.eel.EelTunnelsApi;
import com.intellij.platform.eel.LocalEelApi;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import com.intellij.platform.eel.provider.utils.IjentTunnelsUtil;
import com.intellij.util.io.PathKt;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\b\u0000\u0018\u0000 22\u00020\u0001:\u00012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J$\u0010\u0018\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u0014H\u0016J\b\u0010\u001d\u001a\u00020\u0005H\u0016J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\u0018\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\u0018\u0010 \u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\u0014\u0010!\u001a\u0004\u0018\u00010\u00142\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0012\u0010$\u001a\u00020\u00122\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\n\u0010'\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020*H\u0016J\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00140,J\u0016\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020*2\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u0014H\u0002J\b\u00101\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/compiler/server/EelBuildCommandLineBuilder;", "Lcom/intellij/compiler/server/BuildCommandLineBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "exePath", "Ljava/nio/file/Path;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/nio/file/Path;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "eel", "Lcom/intellij/platform/eel/EelApi;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "Lorg/jetbrains/annotations/NotNull;", "workingDirectory", "cacheDirectory", "addParameter", "", "parameter", "", "addPathParameter", "prefix", "path", "addClasspathParameter", "classpathInHost", "", "classpathInTarget", "getWorkingDirectory", "getHostWorkingDirectory", "copyProjectAgnosticPathToTargetIfRequired", "copyProjectSpecificPathToTargetIfRequired", "syncProjectSpecificPathWithTarget", "getYjpAgentPath", "yourKitProfilerService", "Lcom/intellij/compiler/YourKitProfilerService;", "setCharset", "charset", "Ljava/nio/charset/Charset;", "buildCommandLine", "setUnixProcessPriority", "priority", "", "pathPrefixes", "", "maybeRunReverseTunnel", "localPort", "getSystemSubfolder", "subfolder", "getSystemFolderRoot", "Companion", "intellij.java.compiler.impl"})
@SourceDebugExtension(value={"SMAP\nEelBuildCommandLineBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EelBuildCommandLineBuilder.kt\ncom/intellij/compiler/server/EelBuildCommandLineBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,158:1\n1642#2,10:159\n1915#2:169\n1916#2:172\n1652#2:173\n1586#2:174\n1661#2,3:175\n1#3:170\n1#3:171\n30#4,2:178\n13#5:180\n*S KotlinDebug\n*F\n+ 1 EelBuildCommandLineBuilder.kt\ncom/intellij/compiler/server/EelBuildCommandLineBuilder\n*L\n64#1:159,10\n64#1:169\n64#1:172\n64#1:173\n133#1:174\n133#1:175,3\n64#1:171\n143#1:178,2\n36#1:180\n*E\n"})
public final class EelBuildCommandLineBuilder
implements BuildCommandLineBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final EelApi eel;
    @NotNull
    private final GeneralCommandLine commandLine;
    @NotNull
    private final Path workingDirectory;
    @NotNull
    private final Path cacheDirectory;
    @NotNull
    private static final Logger logger;

    public EelBuildCommandLineBuilder(@NotNull Project project, @NotNull Path exePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
        this.project = project;
        this.eel = EelProviderUtil.toEelApiBlocking((EelDescriptor)EelProviderUtil.getEelDescriptor((Path)exePath));
        GeneralCommandLine generalCommandLine = new GeneralCommandLine().withExePath(((Object)exePath).toString());
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withExePath(...)");
        this.commandLine = generalCommandLine;
        this.workingDirectory = this.getSystemSubfolder("compile-server");
        Path path = this.getSystemSubfolder("jps-" + ApplicationInfo.getInstance().getBuild()).resolve(ProjectUtil.getProjectCacheFileName$default((Project)this.project, (boolean)false, null, null, (int)7, null));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.cacheDirectory = path;
        PathKt.createDirectories((Path)this.workingDirectory);
        PathKt.createDirectories((Path)this.cacheDirectory);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public void addParameter(@NotNull String parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        this.commandLine.addParameter(parameter);
    }

    @Override
    public void addPathParameter(@NotNull String prefix, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = Path.of(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        this.addPathParameter(prefix, path2);
    }

    @Override
    public void addPathParameter(@NotNull String prefix, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.commandLine.addParameter(prefix + EelNioBridgeServiceKt.asEelPath((Path)path));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addClasspathParameter(@NotNull List<String> classpathInHost, @NotNull List<String> classpathInTarget) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(classpathInHost, (String)"classpathInHost");
        Intrinsics.checkNotNullParameter(classpathInTarget, (String)"classpathInTarget");
        Iterable $this$mapNotNull$iv = classpathInHost;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            EelPath it$iv$iv;
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String hostLocation = (String)element$iv$iv;
            boolean bl2 = false;
            Object object2 = this;
            try {
                EelBuildCommandLineBuilder $this$addClasspathParameter_u24lambda_u240_u240 = object2;
                boolean bl3 = false;
                Project project = $this$addClasspathParameter_u24lambda_u240_u240.project;
                Path path = Path.of(hostLocation, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                object = Result.constructor-impl((Object)EelNioBridgeServiceKt.asEelPath((Path)$this$addClasspathParameter_u24lambda_u240_u240.copyProjectSpecificPathToTargetIfRequired(project, path)));
            }
            catch (Throwable bl3) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object error = object = throwable;
                boolean bl4 = false;
                logger.warn("Can't map classpath parameter: " + hostLocation, (Throwable)error);
            }
            if ((EelPath)(Result.isFailure-impl((Object)object2) ? null : object2) == null) continue;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        String mappedClasspath = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)EelPlatformKt.getPathSeparator((EelOsFamily)this.eel.getPlatform().getOsFamily()), null, null, (int)0, null, null, (int)62, null);
        if (!classpathInTarget.isEmpty()) {
            boolean bl = false;
            String string = "Target classpath is not supported";
            throw new IllegalArgumentException(string.toString());
        }
        this.commandLine.addParameter(mappedClasspath);
    }

    @Override
    @NotNull
    public String getWorkingDirectory() {
        EelPath path = EelNioBridgeServiceKt.asEelPath((Path)this.workingDirectory);
        return path.toString();
    }

    @Override
    @NotNull
    public Path getHostWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    @NotNull
    public Path copyProjectAgnosticPathToTargetIfRequired(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!Intrinsics.areEqual((Object)EelProviderUtil.getEelDescriptor((Path)path), (Object)LocalEelDescriptor.INSTANCE)) {
            return path;
        }
        Path remotePath = this.workingDirectory.resolve(PathsKt.getName((Path)path));
        Intrinsics.checkNotNull((Object)remotePath);
        return EelPathUtils.transferLocalContentToRemote$default((Path)path, (EelPathUtils.TransferTarget)((EelPathUtils.TransferTarget)new EelPathUtils.TransferTarget.Explicit(remotePath)), null, null, (int)12, null);
    }

    @Override
    @NotNull
    public Path copyProjectSpecificPathToTargetIfRequired(@NotNull Project project, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = this.cacheDirectory.resolve(PathsKt.getName((Path)path));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return EelPathUtils.transferLocalContentToRemote$default((Path)path, (EelPathUtils.TransferTarget)((EelPathUtils.TransferTarget)new EelPathUtils.TransferTarget.Explicit(path2)), null, null, (int)12, null);
    }

    @Override
    @NotNull
    public Path syncProjectSpecificPathWithTarget(@NotNull Project project, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path target = this.cacheDirectory.resolve(PathsKt.getName((Path)path));
        Intrinsics.checkNotNull((Object)target);
        if (Intrinsics.areEqual((Object)EelProviderUtil.getEelDescriptor((Path)target), (Object)LocalEelDescriptor.INSTANCE)) {
            return path;
        }
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(target, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            PathsKt.deleteRecursively((Path)target);
        }
        return EelPathUtils.transferLocalContentToRemote$default((Path)path, (EelPathUtils.TransferTarget)((EelPathUtils.TransferTarget)new EelPathUtils.TransferTarget.Explicit(target)), null, null, (int)12, null);
    }

    @Override
    @Nullable
    public String getYjpAgentPath(@Nullable YourKitProfilerService yourKitProfilerService) {
        return null;
    }

    @Override
    public void setCharset(@Nullable Charset charset) {
        if (charset != null) {
            this.commandLine.setCharset(charset);
        }
    }

    @Override
    @Nullable
    public GeneralCommandLine buildCommandLine() {
        return this.commandLine.withWorkingDirectory(this.workingDirectory);
    }

    @Override
    public void setUnixProcessPriority(int priority) {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> pathPrefixes() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = EelNioBridgeServiceKt.routingPrefixes((EelDescriptor)this.eel.getDescriptor());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toString();
            String string2 = FileSystems.getDefault().getSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSeparator(...)");
            collection.add(StringsKt.removeSuffix((String)string, (CharSequence)string2));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public final int maybeRunReverseTunnel(int localPort, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (this.eel instanceof LocalEelApi) {
            return localPort;
        }
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<EelBuildManagerScopeProvider> serviceClass$iv = EelBuildManagerScopeProvider.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Deferred remoteServer = IjentTunnelsUtil.forwardLocalServer((CoroutineScope)((EelBuildManagerScopeProvider)object).getScope(), (EelTunnelsApi)this.eel.getTunnels(), (int)localPort, (EelTunnelsApi.HostAddress)EelTunnelsApi.HostAddress.Companion.Builder().build());
        return ((EelTunnelsApi.ResolvedSocketAddress)FutureKt.asCompletableFuture((Deferred)remoteServer).get()).getPort-Mh2AYeg() & 0xFFFF;
    }

    private final Path getSystemSubfolder(String subfolder) {
        Path path = this.getSystemFolderRoot().resolve(subfolder);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private final Path getSystemFolderRoot() {
        return EelPathUtils.getSystemFolder((EelApi)this.eel);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EelBuildCommandLineBuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        EelBuildCommandLineBuilder.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/compiler/server/EelBuildCommandLineBuilder$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.java.compiler.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

