/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.util.SystemProperties;
import it.unimi.dsi.fastutil.HashCommon;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract sealed class InternedPath {
    private static final String PATH_SEPARATORS = '/' == File.separatorChar ? File.separator : "/" + File.separator;
    private static final boolean USE_CAFFEINE_INTERNER = SystemProperties.getBooleanProperty((String)"compiler.InternedPath.USE_CAFFEINE_INTERNER", (boolean)false);
    private static final PathSegmentsInterner ourNameCache = USE_CAFFEINE_INTERNER ? new CaffeineBasedInterner() : new SimplestMRUInterner();
    protected final String[] myPath;

    InternedPath(String path) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(path, PATH_SEPARATORS, false);
        while (tokenizer.hasMoreTokens()) {
            list.add(ourNameCache.intern(tokenizer.nextToken()));
        }
        this.myPath = (String[])list.toArray(String[]::new);
    }

    @NotNull
    public abstract String getValue();

    @NotNull
    public String getName() {
        return this.myPath.length > 0 ? this.myPath[this.myPath.length - 1] : "";
    }

    public boolean contains(Predicate<String> pathElementMatcher) {
        return this.find(pathElementMatcher) != null;
    }

    @Nullable
    public String find(Predicate<String> pathElementMatcher) {
        for (String elem : this.myPath) {
            if (!pathElementMatcher.test(elem)) continue;
            return elem;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternedPath other = (InternedPath)o;
        int length = this.myPath.length;
        if (length != other.myPath.length) {
            return false;
        }
        for (int i = length - 1; i >= 0; --i) {
            if (Objects.equals(this.myPath[i], other.myPath[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.myPath);
    }

    public static void clearCache() {
        ourNameCache.invalidateAll();
    }

    public static InternedPath create(String path) {
        return path.startsWith("//") || path.startsWith("\\\\") ? new UNCWinInternedPath(path.substring(2)) : (path.startsWith("/") ? new XInternedPath(path) : new WinInternedPath(path));
    }

    private static interface PathSegmentsInterner {
        public String intern(@NotNull String var1);

        public void invalidateAll();
    }

    static final class UNCWinInternedPath
    extends InternedPath {
        private UNCWinInternedPath(String path) {
            super(path);
        }

        @Override
        @NotNull
        public String getValue() {
            if (this.myPath.length == 0) {
                return "//";
            }
            StringBuilder buf = new StringBuilder();
            buf.append('/');
            for (String element : this.myPath) {
                buf.append('/').append((CharSequence)element);
            }
            String string = buf.toString();
            if (string == null) {
                UNCWinInternedPath.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/server/InternedPath$UNCWinInternedPath", "getValue"));
        }
    }

    static final class XInternedPath
    extends InternedPath {
        private XInternedPath(String path) {
            super(path);
        }

        @Override
        @NotNull
        public String getValue() {
            if (this.myPath.length > 0) {
                StringBuilder buf = new StringBuilder();
                for (String element : this.myPath) {
                    buf.append('/').append((CharSequence)element);
                }
                String string = buf.toString();
                if (string == null) {
                    XInternedPath.$$$reportNull$$$0(0);
                }
                return string;
            }
            return "/";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/server/InternedPath$XInternedPath", "getValue"));
        }
    }

    static final class WinInternedPath
    extends InternedPath {
        private WinInternedPath(String path) {
            super(path);
        }

        @Override
        @NotNull
        public String getValue() {
            if (this.myPath.length == 0) {
                return "";
            }
            if (this.myPath.length == 1) {
                String name = this.myPath[0];
                Object object = name.length() == 2 && name.endsWith(":") ? name + "/" : name;
                if (object == null) {
                    WinInternedPath.$$$reportNull$$$0(0);
                }
                return object;
            }
            StringBuilder buf = new StringBuilder();
            for (String element : this.myPath) {
                if (!buf.isEmpty()) {
                    buf.append('/');
                }
                buf.append((CharSequence)element);
            }
            String string = buf.toString();
            if (string == null) {
                WinInternedPath.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/server/InternedPath$WinInternedPath", "getValue"));
        }
    }

    private static class CaffeineBasedInterner
    implements PathSegmentsInterner {
        private static final LoadingCache<@NotNull String, String> cache = Caffeine.newBuilder().maximumSize(2048L).build(key -> key);

        private CaffeineBasedInterner() {
        }

        @Override
        public String intern(@NotNull String segment) {
            if (segment == null) {
                CaffeineBasedInterner.$$$reportNull$$$0(0);
            }
            return (String)cache.get((Object)segment);
        }

        @Override
        public void invalidateAll() {
            cache.invalidateAll();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segment", "com/intellij/compiler/server/InternedPath$CaffeineBasedInterner", "intern"));
        }
    }

    private static class SimplestMRUInterner
    implements PathSegmentsInterner {
        private static final int CACHE_SIZE = 4096;
        private final String[] cache = new String[4096];

        private SimplestMRUInterner() {
        }

        @Override
        public String intern(@NotNull String segment) {
            int index;
            String candidate;
            if (segment == null) {
                SimplestMRUInterner.$$$reportNull$$$0(0);
            }
            if (segment.equals(candidate = this.cache[index = HashCommon.mix((int)segment.hashCode()) & 0xFFF])) {
                return candidate;
            }
            this.cache[index] = segment;
            return segment;
        }

        @Override
        public void invalidateAll() {
            Arrays.fill(this.cache, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segment", "com/intellij/compiler/server/InternedPath$SimplestMRUInterner", "intern"));
        }
    }
}

