/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server.impl;

import com.intellij.compiler.server.BuildManager;
import com.intellij.java.workspace.entities.JavaModuleSettingsEntity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Predicates;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.jps.entities.ExcludeUrlEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.RootsKt;
import com.intellij.platform.workspace.jps.entities.SourceRootEntity;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.impl.VersionedStorageChangeInternal;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public final class BuildProcessPreloadedStateClearer
implements WorkspaceModelChangeListener,
ModuleRootListener {
    private final Project myProject;

    public BuildProcessPreloadedStateClearer(Project project) {
        this.myProject = project;
    }

    public void changed(@NotNull VersionedStorageChange event) {
        boolean needFSRescan;
        if (event == null) {
            BuildProcessPreloadedStateClearer.$$$reportNull$$$0(0);
        }
        boolean bl = needFSRescan = BuildProcessPreloadedStateClearer.processEntityChanges(event, SourceRootEntity.class, ChangeProcessor.anyChange(true, false)) != false || BuildProcessPreloadedStateClearer.processEntityChanges(event, ModuleEntity.class, Predicates.alwaysTrue(), (before, after) -> before.getDependencies().equals(after.getDependencies()), ChangeProcessor.anyChange(true, false)) != false || BuildProcessPreloadedStateClearer.processEntityChanges(event, ContentRootEntity.class, Predicates.alwaysTrue(), (before, after) -> before.getExcludedPatterns().equals(after.getExcludedPatterns()), ChangeProcessor.anyChange(true, false)) != false || BuildProcessPreloadedStateClearer.processEntityChanges(event, ExcludeUrlEntity.class, entity -> RootsKt.getContentRoot((ExcludeUrlEntity)entity) != null, (before, after) -> before.getUrl().equals((Object)after.getUrl()), ChangeProcessor.anyChange(true, false)) != false || BuildProcessPreloadedStateClearer.processEntityChanges(event, JavaModuleSettingsEntity.class, ChangeProcessor.anyChange(true, false)) != false;
        if (needFSRescan) {
            BuildManager.getInstance().clearState(this.myProject);
        } else if (((VersionedStorageChangeInternal)event).getAllChanges().iterator().hasNext()) {
            BuildManager.getInstance().cancelPreloadedBuilds(this.myProject);
        }
    }

    private static <T extends WorkspaceEntity, R> R processEntityChanges(@NotNull VersionedStorageChange event, Class<T> entityClass, ChangeProcessor<T, R> proc) {
        if (event == null) {
            BuildProcessPreloadedStateClearer.$$$reportNull$$$0(1);
        }
        return BuildProcessPreloadedStateClearer.processEntityChanges(event, entityClass, Predicates.alwaysTrue(), Object::equals, proc);
    }

    private static <T extends WorkspaceEntity, R> R processEntityChanges(@NotNull VersionedStorageChange event, Class<T> entityClass, Predicate<T> filter, BiFunction<T, T, Boolean> equalsBy, ChangeProcessor<T, R> proc) {
        if (event == null) {
            BuildProcessPreloadedStateClearer.$$$reportNull$$$0(2);
        }
        for (EntityChange change : event.getChanges(entityClass)) {
            WorkspaceEntity before = change.getOldEntity();
            WorkspaceEntity after = change.getNewEntity();
            boolean shouldContinue = true;
            if (after != null) {
                if (before != null) {
                    if ((filter.test(before) || filter.test(after)) && !equalsBy.apply(before, after).booleanValue()) {
                        shouldContinue = proc.changed(before, after);
                    }
                } else if (filter.test(after)) {
                    shouldContinue = proc.added(after);
                }
            } else if (before != null && filter.test(before)) {
                shouldContinue = proc.removed(before);
            }
            if (shouldContinue) continue;
            return proc.getResult();
        }
        return proc.getResult();
    }

    public void rootsChanged(@NotNull ModuleRootEvent event) {
        Object source;
        if (event == null) {
            BuildProcessPreloadedStateClearer.$$$reportNull$$$0(3);
        }
        if (!event.isCausedByWorkspaceModelChangesOnly() && (source = event.getSource()) instanceof Project) {
            BuildManager.getInstance().clearState((Project)source);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "com/intellij/compiler/server/impl/BuildProcessPreloadedStateClearer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "changed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processEntityChanges";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "rootsChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static interface ChangeProcessor<T, R> {
        default public boolean added(T newData) {
            return true;
        }

        default public boolean changed(T oldData, T newData) {
            return true;
        }

        default public boolean removed(T oldData) {
            return true;
        }

        default public R getResult() {
            return null;
        }

        public static <T, R> ChangeProcessor<T, R> anyChange(final R onChangesDetected, final R noChanges) {
            return new ChangeProcessor<T, R>(){
                private R myResult;
                {
                    this.myResult = noChanges;
                }

                @Override
                public boolean added(Object newEntity) {
                    this.myResult = onChangesDetected;
                    return false;
                }

                @Override
                public boolean changed(Object oldEntity, Object newEntity) {
                    this.myResult = onChangesDetected;
                    return false;
                }

                @Override
                public boolean removed(Object oldEntity) {
                    this.myResult = onChangesDetected;
                    return false;
                }

                @Override
                public R getResult() {
                    return this.myResult;
                }
            };
        }
    }
}

