/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTargetType;

public final class ArtifactCompilerUtil {
    private ArtifactCompilerUtil() {
    }

    public static boolean containsArtifacts(List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes) {
        for (CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope scope : scopes) {
            if (!ArtifactBuildTargetType.INSTANCE.getTypeId().equals(scope.getTypeId())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Map<String, List<Artifact>> createOutputToArtifactMap(@NotNull Project project) {
        if (project == null) {
            ArtifactCompilerUtil.$$$reportNull$$$0(0);
        }
        Map result = CollectionFactory.createFilePathMap();
        ReadAction.run(() -> {
            for (Artifact artifact : ArtifactManager.getInstance((Project)project).getArtifacts()) {
                String outputPath = artifact.getOutputFilePath();
                if (StringUtil.isEmpty((String)outputPath)) continue;
                result.computeIfAbsent(outputPath, __ -> new SmartList()).add(artifact);
            }
        });
        Map map = result;
        if (map == null) {
            ArtifactCompilerUtil.$$$reportNull$$$0(1);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/compiler/ArtifactCompilerUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/compiler/ArtifactCompilerUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createOutputToArtifactMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createOutputToArtifactMap";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

