/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.impl.elements.ExtractedDirectoryPackagingElement;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NotNull;

public class ExtractedDirectoryPresentation
extends PackagingElementPresentation {
    private final String myJarPath;
    private final String myPathInJar;
    private final VirtualFile myFile;

    public ExtractedDirectoryPresentation(ExtractedDirectoryPackagingElement element) {
        this.myFile = element.findFile();
        this.myJarPath = element.getFilePath();
        this.myPathInJar = element.getPathInJar();
    }

    public String getPresentableName() {
        return PathUtil.getFileName((String)this.myJarPath) + this.myPathInJar;
    }

    public void render(@NotNull PresentationData presentationData, SimpleTextAttributes mainAttributes, SimpleTextAttributes commentAttributes) {
        if (presentationData == null) {
            ExtractedDirectoryPresentation.$$$reportNull$$$0(0);
        }
        presentationData.setIcon(AllIcons.Nodes.ExtractedFolder);
        String parentPath = PathUtil.getParentPath((String)this.myJarPath);
        if (this.myFile == null || !this.myFile.isDirectory()) {
            mainAttributes = SimpleTextAttributes.ERROR_ATTRIBUTES;
            VirtualFile parentFile = LocalFileSystem.getInstance().findFileByPath(parentPath);
            if (parentFile == null) {
                commentAttributes = SimpleTextAttributes.ERROR_ATTRIBUTES;
            }
        }
        presentationData.addText(JavaCompilerBundle.message((String)"label.extracted.dir.presentation", (Object[])new Object[]{this.getPresentableName()}), mainAttributes);
        presentationData.addText(" (" + parentPath + ")", commentAttributes);
    }

    public int getWeight() {
        return 39;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentationData", "com/intellij/packaging/impl/ui/ExtractedDirectoryPresentation", "render"));
    }
}

