/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.FileResolver;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.PathQuery;
import org.jetbrains.builtInWebServer.PrefixlessWebServerRootsProvider;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/builtInWebServer/ArtifactWebServerRootsProvider;", "Lorg/jetbrains/builtInWebServer/PrefixlessWebServerRootsProvider;", "<init>", "()V", "resolve", "Lorg/jetbrains/builtInWebServer/PathInfo;", "path", "", "project", "Lcom/intellij/openapi/project/Project;", "resolver", "Lorg/jetbrains/builtInWebServer/FileResolver;", "pathQuery", "Lorg/jetbrains/builtInWebServer/PathQuery;", "getPathInfo", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.java.compiler.impl"})
public final class ArtifactWebServerRootsProvider
extends PrefixlessWebServerRootsProvider {
    @Nullable
    public PathInfo resolve(@NotNull String path, @NotNull Project project, @NotNull FileResolver resolver, @NotNull PathQuery pathQuery) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter((Object)pathQuery, (String)"pathQuery");
        if (!pathQuery.getSearchInArtifacts()) {
            return null;
        }
        return (PathInfo)ActionsKt.runReadAction(() -> ArtifactWebServerRootsProvider.resolve$lambda$0(project, resolver, path, pathQuery));
    }

    @Nullable
    public PathInfo getPathInfo(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Artifact[] artifactArray = ArtifactManager.getInstance((Project)project).getArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)artifactArray, (String)"getArtifacts(...)");
        for (Artifact artifact : artifactArray) {
            VirtualFile root;
            if (artifact.getOutputFile() == null || !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)true)) continue;
            return new PathInfo(null, file, root, null, false, false, 56, null);
        }
        return null;
    }

    private static final PathInfo resolve$lambda$0(Project $project, FileResolver $resolver, String $path, PathQuery $pathQuery) {
        Artifact[] artifactArray = ArtifactManager.getInstance((Project)$project).getArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)artifactArray, (String)"getArtifacts(...)");
        for (Artifact artifact : artifactArray) {
            VirtualFile root;
            if (artifact.getOutputFile() == null) continue;
            PathInfo pathInfo = FileResolver.resolve$default((FileResolver)$resolver, (String)$path, (VirtualFile)root, null, (boolean)false, (PathQuery)$pathQuery, (int)12, null);
            if (pathInfo == null) continue;
            return pathInfo;
        }
        return null;
    }
}

