/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.jlanguage;

import ai.grazie.nlp.langs.LanguageISO;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.GrazieDynamic;
import com.intellij.grazie.ide.msg.GrazieStateLifecycle;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.jlanguage.broker.GrazieDynamicDataBroker;
import com.intellij.grazie.jlanguage.filters.UppercaseMatchFilter;
import com.intellij.grazie.jlanguage.hunspell.LuceneHunspellDictionary;
import com.intellij.grazie.utils.TextStyleDomain;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.CollectionFactory;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.ResultCache;
import org.languagetool.Tag;
import org.languagetool.broker.ResourceDataBroker;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.ExampleSentence;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatchFilter;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.RepeatedPatternRuleTransformer;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.hunspell.Hunspell;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\r\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0011J\u0015\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0011J\u0015\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0011J\u0016\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0007J%\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u001aJ\f\u0010\u001b\u001a\u00020\u001c*\u00020\u001dH\u0002J8\u0010\u001e\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u001f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u0014\u0010)\u001a\u00020\u001c*\u00020*2\u0006\u0010+\u001a\u00020*H\u0002J%\u0010,\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b.J\u0018\u0010/\u001a\u00020!2\u0006\u00100\u001a\u00020\u00192\u0006\u00101\u001a\u00020\u0019H\u0016R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\t\u001a \u0012\u0004\u0012\u00020\u0006\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/grazie/jlanguage/LangTool;", "Lcom/intellij/grazie/ide/msg/GrazieStateLifecycle;", "<init>", "()V", "langs", "", "Lcom/intellij/grazie/jlanguage/Lang;", "Lcom/intellij/grazie/utils/TextStyleDomain;", "Lorg/languagetool/JLanguageTool;", "rulesEnabledByDefault", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "inappropriateExamples", "", "globalIdPrefix", "lang", "globalIdPrefix$intellij_grazie_core", "Lai/grazie/nlp/langs/Language;", "iso", "Lai/grazie/nlp/langs/LanguageISO;", "getTool", "domain", "createTool", "state", "Lcom/intellij/grazie/GrazieConfig$State;", "createTool$intellij_grazie_core", "isPicky", "", "Lorg/languagetool/rules/Rule;", "getRules", "Lkotlin/Pair;", "prepareForNoChunkTags", "", "rule", "removeVerySimilarExamples", "", "Lorg/languagetool/rules/IncorrectExample;", "removeInappropriateExamples", "MINIMUM_EXAMPLE_SIMILARITY", "", "isSimilarTo", "", "sequence", "isRuleEnabledByDefault", "ruleId", "isRuleEnabledByDefault$intellij_grazie_core", "update", "prevState", "newState", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nLangTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LangTool.kt\ncom/intellij/grazie/jlanguage/LangTool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,240:1\n1#2:241\n1#2:262\n1#2:276\n1#2:290\n1#2:304\n1915#3,2:242\n1915#3,2:244\n1915#3,2:246\n1786#3,3:248\n1642#3,10:251\n1915#3:261\n1916#3:263\n1652#3:264\n1642#3,10:265\n1915#3:275\n1916#3:277\n1652#3:278\n1642#3,10:279\n1915#3:289\n1916#3:291\n1652#3:292\n1642#3,10:293\n1915#3:303\n1916#3:305\n1652#3:306\n1915#3,2:307\n1915#3,2:309\n2792#3,3:311\n777#3:314\n873#3,2:315\n832#3:317\n862#3:318\n1807#3,3:319\n863#3:322\n1915#3,2:323\n1915#3,2:325\n1915#3,2:327\n1586#3:329\n1661#3,3:330\n*S KotlinDebug\n*F\n+ 1 LangTool.kt\ncom/intellij/grazie/jlanguage/LangTool\n*L\n153#1:262\n154#1:276\n158#1:290\n159#1:304\n82#1:242,2\n83#1:244,2\n118#1:246,2\n143#1:248,3\n153#1:251,10\n153#1:261\n153#1:263\n153#1:264\n154#1:265,10\n154#1:275\n154#1:277\n154#1:278\n158#1:279,10\n158#1:289\n158#1:291\n158#1:292\n159#1:293,10\n159#1:303\n159#1:305\n159#1:306\n177#1:307,2\n180#1:309,2\n188#1:311,3\n189#1:314\n189#1:315,2\n202#1:317\n202#1:318\n202#1:319,3\n202#1:322\n171#1:323,2\n172#1:325,2\n173#1:327,2\n222#1:329\n222#1:330,3\n*E\n"})
public final class LangTool
implements GrazieStateLifecycle {
    @NotNull
    public static final LangTool INSTANCE = new LangTool();
    @NotNull
    private static final Map<Lang, Map<TextStyleDomain, JLanguageTool>> langs = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<Lang, Map<TextStyleDomain, Set<String>>> rulesEnabledByDefault = new ConcurrentHashMap();
    @NotNull
    private static final Map<String, Set<String>> inappropriateExamples;
    private static final double MINIMUM_EXAMPLE_SIMILARITY = 0.2;

    private LangTool() {
    }

    @NotNull
    public final String globalIdPrefix$intellij_grazie_core(@NotNull Lang lang) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        return this.globalIdPrefix$intellij_grazie_core(lang.getIso());
    }

    @NotNull
    public final String globalIdPrefix$intellij_grazie_core(@NotNull ai.grazie.nlp.langs.Language lang) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        return this.globalIdPrefix$intellij_grazie_core(lang.getIso());
    }

    @NotNull
    public final String globalIdPrefix$intellij_grazie_core(@NotNull LanguageISO iso) {
        Intrinsics.checkNotNullParameter((Object)iso, (String)"iso");
        return "LanguageTool." + iso.name() + ".";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final JLanguageTool getTool(@NotNull Lang lang, @NotNull TextStyleDomain domain) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        Intrinsics.checkNotNullParameter((Object)((Object)domain), (String)"domain");
        while (true) {
            Map tools;
            Intrinsics.checkNotNullExpressionValue((Object)langs.computeIfAbsent(lang, arg_0 -> LangTool.getTool$lambda$1(LangTool::getTool$lambda$0, arg_0)), (String)"computeIfAbsent(...)");
            JLanguageTool tool2 = null;
            tool2 = (JLanguageTool)tools.get((Object)domain);
            if (tool2 != null) {
                return tool2;
            }
            GrazieConfig.State state = GrazieConfig.Companion.get();
            tool2 = this.createTool$intellij_grazie_core(lang, state, domain);
            Map<Lang, Map<TextStyleDomain, JLanguageTool>> map = langs;
            synchronized (map) {
                boolean bl = false;
                if (state == GrazieConfig.Companion.get()) {
                    JLanguageTool alreadyComputed = (JLanguageTool)tools.get((Object)domain);
                    if (alreadyComputed != null) {
                        return alreadyComputed;
                    }
                    tools.put(domain, tool2);
                    return tool2;
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @NotNull
    public final JLanguageTool createTool$intellij_grazie_core(@NotNull Lang lang, @NotNull GrazieConfig.State state, @NotNull TextStyleDomain domain) {
        String id;
        JLanguageTool jLanguageTool;
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)((Object)domain), (String)"domain");
        Language jLanguage = lang.getJLanguage();
        if (!(jLanguage != null)) {
            boolean $i$a$-require-LangTool$createTool$22 = false;
            String $i$a$-require-LangTool$createTool$22 = "Trying to get LangTool for not available language";
            throw new IllegalArgumentException($i$a$-require-LangTool$createTool$22.toString());
        }
        JLanguageTool $this$createTool_u24lambda_u241 = jLanguageTool = new JLanguageTool(jLanguage, null, new ResultCache(10000L));
        boolean bl = false;
        $this$createTool_u24lambda_u241.setCheckCancelledCallback(LangTool::createTool$lambda$1$0);
        $this$createTool_u24lambda_u241.addMatchFilter((RuleMatchFilter)new UppercaseMatchFilter());
        Pair<Set<String>, Set<String>> pair = INSTANCE.getRules(lang, state, domain);
        Set enabledRules = (Set)pair.component1();
        Set disabledRules = (Set)pair.component2();
        Iterable $this$forEach$iv = enabledRules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            id = (String)element$iv;
            boolean bl2 = false;
            $this$createTool_u24lambda_u241.enableRule(id);
        }
        $this$forEach$iv = disabledRules;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            id = (String)element$iv;
            boolean bl3 = false;
            $this$createTool_u24lambda_u241.disableRule(id);
        }
        LangTool.createTool$lambda$1$loadConfigFile("en/enabled_rules.txt", (Function2<? super String, ? super String, Unit>)((Function2)(arg_0, arg_1) -> LangTool.createTool$lambda$1$4(lang, disabledRules, $this$createTool_u24lambda_u241, arg_0, arg_1)));
        LangTool.createTool$lambda$1$loadConfigFile("en/disabled_rules.txt", (Function2<? super String, ? super String, Unit>)((Function2)(arg_0, arg_1) -> LangTool.createTool$lambda$1$5(lang, enabledRules, $this$createTool_u24lambda_u241, arg_0, arg_1)));
        LangTool.createTool$lambda$1$loadConfigFile("en/enabled_categories.txt", (Function2<? super String, ? super String, Unit>)((Function2)(arg_0, arg_1) -> LangTool.createTool$lambda$1$6(lang, $this$createTool_u24lambda_u241, arg_0, arg_1)));
        LangTool.createTool$lambda$1$loadConfigFile("en/disabled_categories.txt", (Function2<? super String, ? super String, Unit>)((Function2)(arg_0, arg_1) -> LangTool.createTool$lambda$1$7(lang, $this$createTool_u24lambda_u241, arg_0, arg_1)));
        List list = $this$createTool_u24lambda_u241.getAllSpellingCheckRules();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllSpellingCheckRules(...)");
        $this$forEach$iv = list;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SpellingCheckRule rule = (SpellingCheckRule)element$iv;
            boolean bl4 = false;
            $this$createTool_u24lambda_u241.disableRule(rule.getId());
        }
        for (Rule rule : $this$createTool_u24lambda_u241.getAllActiveRules()) {
            Intrinsics.checkNotNull((Object)rule);
            if (!INSTANCE.isPicky(rule) || enabledRules.contains(rule.getId())) continue;
            $this$createTool_u24lambda_u241.disableRule(rule.getId());
        }
        for (Rule rule : $this$createTool_u24lambda_u241.getAllRules()) {
            ProgressManager.checkCanceled();
            rule.setCorrectExamples(CollectionsKt.emptyList());
            rule.setErrorTriggeringExamples(CollectionsKt.emptyList());
            Intrinsics.checkNotNull((Object)rule);
            rule.setIncorrectExamples(INSTANCE.removeVerySimilarExamples(rule));
            if (!Lang.Companion.shouldDisableChunker$intellij_grazie_core(jLanguage)) continue;
            INSTANCE.prepareForNoChunkTags(rule);
        }
        return jLanguageTool;
    }

    private final boolean isPicky(Rule $this$isPicky) {
        if ($this$isPicky.hasTag(Tag.picky)) {
            return true;
        }
        if ($this$isPicky instanceof RepeatedPatternRuleTransformer.RepeatedPatternRule) {
            boolean bl;
            block5: {
                List list = ((RepeatedPatternRuleTransformer.RepeatedPatternRule)$this$isPicky).getWrappedRules();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getWrappedRules(...)");
                Iterable $this$all$iv = list;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        AbstractPatternRule it = (AbstractPatternRule)element$iv;
                        boolean bl2 = false;
                        if (it.hasTag(Tag.picky)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        return false;
    }

    private final Pair<Set<String>, Set<String>> getRules(Lang lang, GrazieConfig.State state, TextStyleDomain domain) {
        String prefix = this.globalIdPrefix$intellij_grazie_core(lang);
        HashSet enabledRules = new HashSet();
        HashSet disabledRules = new HashSet();
        if (domain == TextStyleDomain.Other) {
            boolean bl;
            String it$iv$iv;
            String it;
            boolean bl2;
            Object element$iv$iv;
            Object element$iv$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Iterable iterable = state.getUserEnabledRules();
            HashSet hashSet = enabledRules;
            boolean $i$f$mapNotNull = false;
            void var9_13 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                element$iv$iv = element$iv$iv$iv = iterator.next();
                bl2 = false;
                it = (String)element$iv$iv;
                boolean bl3 = false;
                if (StringsKt.startsWith$default((String)it, (String)prefix, (boolean)false, (int)2, null)) {
                    String string2 = it.substring(prefix.length());
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                } else {
                    string = null;
                }
                if (string == null) continue;
                it$iv$iv = string;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            hashSet.addAll((List)destination$iv$iv);
            $this$mapNotNull$iv = state.getUserDisabledRules();
            hashSet = disabledRules;
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                element$iv$iv = element$iv$iv$iv = iterator.next();
                bl2 = false;
                it = (String)element$iv$iv;
                boolean bl4 = false;
                if (StringsKt.startsWith$default((String)it, (String)prefix, (boolean)false, (int)2, null)) {
                    String string3 = it.substring(prefix.length());
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                } else {
                    string = null;
                }
                if (string == null) continue;
                it$iv$iv = string;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            v4 = hashSet.addAll((List)destination$iv$iv);
        } else {
            boolean bl;
            String it$iv$iv;
            String it;
            boolean bl5;
            Object element$iv$iv;
            Object element$iv$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Set set;
            Set domainEnabledRules;
            Set set2 = state.getDomainEnabledRules().get((Object)domain);
            if (set2 == null) {
                set2 = domainEnabledRules = SetsKt.emptySet();
            }
            if ((set = state.getDomainDisabledRules().get((Object)domain)) == null) {
                set = SetsKt.emptySet();
            }
            Set domainDisabledRules = set;
            Iterable $this$mapNotNullTo$iv$iv2 = domainEnabledRules;
            HashSet hashSet = enabledRules;
            boolean $i$f$mapNotNull = false;
            void $i$f$mapNotNullTo = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                element$iv$iv = element$iv$iv$iv = iterator.next();
                bl5 = false;
                it = (String)element$iv$iv;
                boolean bl6 = false;
                if (StringsKt.startsWith$default((String)it, (String)prefix, (boolean)false, (int)2, null)) {
                    String string4 = it.substring(prefix.length());
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                } else {
                    string = null;
                }
                if (string == null) continue;
                it$iv$iv = string;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            hashSet.addAll((List)destination$iv$iv);
            $this$mapNotNull$iv = domainDisabledRules;
            hashSet = disabledRules;
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo2 = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                element$iv$iv = element$iv$iv$iv = iterator.next();
                bl5 = false;
                it = (String)element$iv$iv;
                boolean bl7 = false;
                if (StringsKt.startsWith$default((String)it, (String)prefix, (boolean)false, (int)2, null)) {
                    String string5 = it.substring(prefix.length());
                    string = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                } else {
                    string = null;
                }
                if (string == null) continue;
                it$iv$iv = string;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            v4 = hashSet.addAll((List)destination$iv$iv);
        }
        return TuplesKt.to(enabledRules, disabledRules);
    }

    private final void prepareForNoChunkTags(Rule rule) {
        if (rule instanceof AbstractPatternRule) {
            List list = ((AbstractPatternRule)rule).getPatternTokens();
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PatternToken it = (PatternToken)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    LangTool.prepareForNoChunkTags$relaxChunkConditions(it, true);
                }
            }
        }
        List list = rule.getAntiPatterns();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAntiPatterns(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DisambiguationPatternRule it = (DisambiguationPatternRule)element$iv;
            boolean bl = false;
            List list2 = it.getPatternTokens();
            if (list2 == null) continue;
            Iterable $this$forEach$iv2 = list2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                PatternToken token = (PatternToken)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)token);
                LangTool.prepareForNoChunkTags$relaxChunkConditions(token, false);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<IncorrectExample> removeVerySimilarExamples(Rule rule) {
        ArrayList<String> cleanAccepted = new ArrayList<String>();
        ArrayList<IncorrectExample> accepted = new ArrayList<IncorrectExample>();
        for (IncorrectExample example : this.removeInappropriateExamples(rule)) {
            void $this$filterTo$iv$iv;
            Object element$iv2;
            boolean bl;
            String cleanExample;
            block5: {
                cleanExample = ExampleSentence.cleanMarkersInExample((String)example.getExample());
                Iterable $this$none$iv = cleanAccepted;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv2 : $this$none$iv) {
                        String it = (String)element$iv2;
                        boolean bl2 = false;
                        CharSequence charSequence = it;
                        Intrinsics.checkNotNull((Object)cleanExample);
                        if (!INSTANCE.isSimilarTo(charSequence, cleanExample)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            List list = example.getCorrections();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCorrections(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            element$iv2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it);
                boolean bl4 = !StringsKt.isBlank((CharSequence)it);
                if (!bl4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List corrections = CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)3);
            accepted.add(new IncorrectExample(example.getExample(), corrections));
            cleanAccepted.add(cleanExample);
            if (accepted.size() <= 5) continue;
            break;
        }
        return accepted;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IncorrectExample> removeInappropriateExamples(Rule rule) {
        Set<String> inappropriateExamples = LangTool.inappropriateExamples.get(rule.getId());
        if (inappropriateExamples != null) {
            void $this$filterNotTo$iv$iv;
            List list = rule.getIncorrectExamples();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getIncorrectExamples(...)");
            Iterable $this$filterNot$iv = list;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                boolean bl;
                block5: {
                    IncorrectExample example = (IncorrectExample)element$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$any$iv = inappropriateExamples;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            String string = example.getExample();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExample(...)");
                            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        List list = rule.getIncorrectExamples();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getIncorrectExamples(...)");
        return list;
    }

    private final boolean isSimilarTo(CharSequence $this$isSimilarTo, CharSequence sequence2) {
        int maxLength = Math.max($this$isSimilarTo.length(), sequence2.length());
        int distance = (int)Math.ceil((double)maxLength * 0.2);
        if (Math.abs($this$isSimilarTo.length() - sequence2.length()) > distance) {
            return false;
        }
        int prefixLength = StringUtil.commonPrefixLength((CharSequence)$this$isSimilarTo, (CharSequence)sequence2);
        int suffixLength = StringUtil.commonSuffixLength((CharSequence)$this$isSimilarTo, (CharSequence)sequence2);
        return suffixLength + prefixLength >= distance;
    }

    public final boolean isRuleEnabledByDefault$intellij_grazie_core(@NotNull Lang lang, @NotNull String ruleId, @NotNull TextStyleDomain domain) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        Intrinsics.checkNotNullParameter((Object)ruleId, (String)"ruleId");
        Intrinsics.checkNotNullParameter((Object)((Object)domain), (String)"domain");
        Map map = rulesEnabledByDefault.computeIfAbsent(lang, arg_0 -> LangTool.isRuleEnabledByDefault$lambda$1(LangTool::isRuleEnabledByDefault$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"computeIfAbsent(...)");
        Map rules = map;
        Set set = rules.computeIfAbsent(domain, arg_0 -> LangTool.isRuleEnabledByDefault$lambda$3(arg_0 -> LangTool.isRuleEnabledByDefault$lambda$2(lang, domain, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"computeIfAbsent(...)");
        Set activeIds = set;
        return activeIds.contains(ruleId);
    }

    @Override
    public void update(@NotNull GrazieConfig.State prevState, @NotNull GrazieConfig.State newState) {
        Intrinsics.checkNotNullParameter((Object)prevState, (String)"prevState");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (Intrinsics.areEqual(prevState.getAvailableLanguages(), newState.getAvailableLanguages()) && Intrinsics.areEqual(prevState.getUserDisabledRules(), newState.getUserDisabledRules()) && Intrinsics.areEqual(prevState.getUserEnabledRules(), newState.getUserEnabledRules()) && Intrinsics.areEqual(prevState.getDomainEnabledRules(), newState.getDomainEnabledRules()) && Intrinsics.areEqual(prevState.getDomainDisabledRules(), newState.getDomainDisabledRules())) {
            return;
        }
        langs.clear();
        rulesEnabledByDefault.clear();
    }

    private static final Class _init_$lambda$0(String qualifiedName) {
        Intrinsics.checkNotNull((Object)qualifiedName);
        Class<?> clazz = GrazieDynamic.INSTANCE.loadClass(qualifiedName);
        if (clazz == null) {
            throw new ClassNotFoundException(qualifiedName);
        }
        return clazz;
    }

    private static final Map getTool$lambda$0(Lang it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return CollectionFactory.createConcurrentSoftValueMap();
    }

    private static final Map getTool$lambda$1(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    private static final Unit createTool$lambda$1$loadConfigFile$3$0(Function2 $block, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        char[] cArray = new char[]{':'};
        List list = StringsKt.split$default((CharSequence)it, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        String iso = (String)list.get(0);
        String id = (String)list.get(1);
        $block.invoke((Object)iso, (Object)id);
        return Unit.INSTANCE;
    }

    private static final boolean createTool$lambda$1$0() {
        ProgressManager.checkCanceled();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void createTool$lambda$1$loadConfigFile(String path, Function2<? super String, ? super String, Unit> block) {
        Closeable closeable = GrazieDynamicDataBroker.INSTANCE.getFromResourceDirAsStream(path);
        Throwable throwable = null;
        try {
            InputStream stream = (InputStream)closeable;
            boolean bl = false;
            InputStream inputStream = stream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream, charset);
            int n = 8192;
            TextStreamsKt.forEachLine((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)), arg_0 -> LangTool.createTool$lambda$1$loadConfigFile$3$0(block, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final Unit createTool$lambda$1$4(Lang $lang, Set $disabledRules, JLanguageTool $this_apply, String iso, String ruleId) {
        Intrinsics.checkNotNullParameter((Object)iso, (String)"iso");
        Intrinsics.checkNotNullParameter((Object)ruleId, (String)"ruleId");
        if (Intrinsics.areEqual((Object)iso, (Object)$lang.getIso().name()) && !$disabledRules.contains(ruleId)) {
            $this_apply.enableRule(ruleId);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createTool$lambda$1$5(Lang $lang, Set $enabledRules, JLanguageTool $this_apply, String iso, String ruleId) {
        Intrinsics.checkNotNullParameter((Object)iso, (String)"iso");
        Intrinsics.checkNotNullParameter((Object)ruleId, (String)"ruleId");
        if (Intrinsics.areEqual((Object)iso, (Object)$lang.getIso().name()) && !$enabledRules.contains(ruleId)) {
            $this_apply.disableRule(ruleId);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createTool$lambda$1$6(Lang $lang, JLanguageTool $this_apply, String iso, String categoryId) {
        Intrinsics.checkNotNullParameter((Object)iso, (String)"iso");
        Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
        if (Intrinsics.areEqual((Object)iso, (Object)$lang.getIso().name())) {
            $this_apply.enableRuleCategory(new CategoryId(categoryId));
        }
        return Unit.INSTANCE;
    }

    private static final Unit createTool$lambda$1$7(Lang $lang, JLanguageTool $this_apply, String iso, String categoryId) {
        Intrinsics.checkNotNullParameter((Object)iso, (String)"iso");
        Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
        if (Intrinsics.areEqual((Object)iso, (Object)$lang.getIso().name())) {
            $this_apply.disableCategory(new CategoryId(categoryId));
        }
        return Unit.INSTANCE;
    }

    private static final void prepareForNoChunkTags$relaxChunkConditions(PatternToken token, boolean positive) {
        PatternToken it;
        if (token.getNegation() == positive && token.getChunkTag() != null) {
            token.setChunkTag(null);
        }
        List list = token.getAndGroup();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAndGroup(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PatternToken)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            LangTool.prepareForNoChunkTags$relaxChunkConditions(it, positive);
        }
        List list2 = token.getOrGroup();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getOrGroup(...)");
        $this$forEach$iv = list2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PatternToken)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            LangTool.prepareForNoChunkTags$relaxChunkConditions(it, positive);
        }
        List list3 = token.getExceptionList();
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        $this$forEach$iv = list3;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PatternToken)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            LangTool.prepareForNoChunkTags$relaxChunkConditions(it, !positive);
        }
    }

    private static final Map isRuleEnabledByDefault$lambda$0(Lang it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return new ConcurrentHashMap();
    }

    private static final Map isRuleEnabledByDefault$lambda$1(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final Set isRuleEnabledByDefault$lambda$2(Lang $lang, TextStyleDomain $domain, TextStyleDomain it) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        List list = INSTANCE.createTool$intellij_grazie_core($lang, new GrazieConfig.State(null, null, null, false, null, null, null, null, null, null, null, null, null, null, null, false, false, null, 262143, null), $domain).getAllActiveRules();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllActiveRules(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Rule rule = (Rule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getId());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final Set isRuleEnabledByDefault$lambda$3(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    static {
        Object[] objectArray = new String[]{"small children and their mothers", "eternal rest"};
        inappropriateExamples = MapsKt.mapOf((Pair)TuplesKt.to((Object)"DT_NNS_AGREEMENT", (Object)SetsKt.setOf((Object[])objectArray)));
        JLanguageTool.useCustomPasswordAuthenticator((boolean)false);
        JLanguageTool.setDataBroker((ResourceDataBroker)GrazieDynamicDataBroker.INSTANCE);
        JLanguageTool.setClassBrokerBroker(LangTool::_init_$lambda$0);
        Hunspell.setHunspellDictionaryFactory(LuceneHunspellDictionary::new);
    }
}

