/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.spellcheck.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.statistics.SpellcheckerActionStatistics;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.spellchecker.util.Strings;
import com.intellij.ui.AddDeleteListPanel;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public final class SpellCheckerSettingsPane {

    static final class WordsPanel
    extends AddDeleteListPanel<String> {
        private final SpellCheckerManager manager;

        WordsPanel(SpellCheckerManager manager, @NotNull Disposable parentDisposable) {
            if (parentDisposable == null) {
                WordsPanel.$$$reportNull$$$0(0);
            }
            super(null, ContainerUtil.sorted((Collection)manager.getUserDictionaryWords()));
            this.manager = manager;
            this.getEmptyText().setText(SpellCheckerBundle.message((String)"no.words", (Object[])new Object[0]));
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    myListModel.removeAllElements();
                }
            });
        }

        protected void customizeDecorator(ToolbarDecorator decorator) {
            decorator.setRemoveAction(button -> {
                SpellcheckerActionStatistics.removeWordFromAcceptedWords((Project)this.manager.getProject());
                ListUtil.removeSelectedItems((JList)this.myList);
            });
        }

        protected String findItemToAdd() {
            SpellcheckerActionStatistics.addWordToAcceptedWords((Project)this.manager.getProject());
            String word = Messages.showInputDialog((String)SpellCheckerBundle.message((String)"enter.simple.word", (Object[])new Object[0]), (String)SpellCheckerBundle.message((String)"add.new.word", (Object[])new Object[0]), null);
            if (word == null) {
                return null;
            }
            boolean mixedCase = Strings.isMixedCase((String)(word = word.trim()));
            if (mixedCase && this.getWords().contains(word) || !mixedCase && !this.manager.hasProblem(word)) {
                Messages.showWarningDialog((String)SpellCheckerBundle.message((String)"entered.word.0.is.correct.you.no.need.to.add.this.in.list", (Object[])new Object[]{word}), (String)SpellCheckerBundle.message((String)"add.new.word", (Object[])new Object[0]));
                return null;
            }
            return word;
        }

        @NotNull
        public List<String> getWords() {
            Object[] pairs = this.getListItems();
            if (pairs == null) {
                return new ArrayList<String>();
            }
            ArrayList<String> words = new ArrayList<String>();
            for (Object pair : pairs) {
                words.add(pair.toString());
            }
            ArrayList<String> arrayList = words;
            if (arrayList == null) {
                WordsPanel.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        public boolean isModified() {
            List<String> newWords = this.getWords();
            Set words = this.manager.getUserDictionaryWords();
            if (newWords.size() != words.size()) {
                return true;
            }
            HashSet<String> newHashWords = new HashSet<String>(newWords);
            return !newHashWords.equals(words);
        }

        public void reset() {
            this.myListModel.removeAllElements();
            ContainerUtil.sorted((Collection)this.manager.getUserDictionaryWords()).forEach(this.myListModel::addElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/grazie/spellcheck/settings/SpellCheckerSettingsPane$WordsPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/grazie/spellcheck/settings/SpellCheckerSettingsPane$WordsPanel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWords";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

