/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import ai.grazie.nlp.tokenizer.sentence.StandardSentenceTokenizer;
import com.intellij.grazie.text.ProblemFilter;
import com.intellij.grazie.text.RuleGroup;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import com.intellij.grazie.utils.ProblemFilterUtil;
import com.intellij.grazie.utils.Text;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.search.TodoPattern;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/grazie/text/CommentProblemFilter;", "Lcom/intellij/grazie/text/ProblemFilter;", "<init>", "()V", "tokenizer", "Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer;", "getTokenizer", "()Lai/grazie/nlp/tokenizer/sentence/StandardSentenceTokenizer;", "shouldIgnore", "", "problem", "Lcom/intellij/grazie/text/TextProblem;", "isInFirstSentence", "isAboutIdentifierParts", "text", "Lcom/intellij/grazie/text/TextContent;", "isTodoComment", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nCommentProblemFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommentProblemFilter.kt\ncom/intellij/grazie/text/CommentProblemFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1807#2,3:67\n1807#2,3:84\n12033#3,10:70\n14060#3:80\n14061#3:82\n12043#3:83\n13225#3,2:87\n1#4:81\n*S KotlinDebug\n*F\n+ 1 CommentProblemFilter.kt\ncom/intellij/grazie/text/CommentProblemFilter\n*L\n49#1:67,3\n58#1:84,3\n57#1:70,10\n57#1:80\n57#1:82\n57#1:83\n63#1:87,2\n57#1:81\n*E\n"})
public final class CommentProblemFilter
extends ProblemFilter {
    private final StandardSentenceTokenizer getTokenizer() {
        return StandardSentenceTokenizer.Companion.getDefault();
    }

    @Override
    public boolean shouldIgnore(@NotNull TextProblem problem) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        TextContent textContent = problem.getText();
        Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"getText(...)");
        TextContent text = textContent;
        TextContent.TextDomain domain = text.getDomain();
        if (domain == TextContent.TextDomain.COMMENTS || domain == TextContent.TextDomain.DOCUMENTATION) {
            if (this.isTodoComment(text)) {
                return true;
            }
            String string = problem.getRule().getGlobalId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGlobalId(...)");
            if (StringsKt.startsWith$default((String)string, (String)"LanguageTool.", (boolean)false, (int)2, null) && this.isAboutIdentifierParts(problem, text)) {
                return true;
            }
            if (this.isInFirstSentence(problem) && problem.fitsGroup(new RuleGroup(stringArray = new String[]{"INCOMPLETE_SENTENCE"}))) {
                return true;
            }
        }
        if (domain == TextContent.TextDomain.COMMENTS) {
            stringArray = new String[]{"UNDECORATED_SENTENCE_SEPARATION"};
            if (problem.fitsGroup(new RuleGroup(stringArray))) {
                return true;
            }
            if (Text.isSingleSentence(text) && (problem.fitsGroup(RuleGroup.UNDECORATED_SINGLE_SENTENCE) || ProblemFilterUtil.isMissingArticleIssue(problem))) {
                return true;
            }
        }
        return false;
    }

    private final boolean isInFirstSentence(TextProblem problem) {
        StandardSentenceTokenizer standardSentenceTokenizer = this.getTokenizer();
        TextContent textContent = problem.getText();
        Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"getText(...)");
        CharSequence charSequence = textContent;
        int n = 0;
        int n2 = problem.getHighlightRanges().get(0).getStartOffset();
        return standardSentenceTokenizer.tokenize(((Object)charSequence.subSequence(n, n2)).toString()).size() <= 1;
    }

    private final boolean isAboutIdentifierParts(TextProblem problem, TextContent text) {
        boolean bl;
        block3: {
            List<TextRange> list = problem.getHighlightRanges();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getHighlightRanges(...)");
            List<TextRange> ranges = list;
            Iterable $this$any$iv = ranges;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TextRange it = (TextRange)element$iv;
                    boolean bl2 = false;
                    if (!(StringsKt.endsWith$default((CharSequence)text.subSequence(0, it.getStartOffset()), (char)'_', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)text.subSequence(it.getEndOffset(), text.length()), (char)'_', (boolean)false, (int)2, null))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isTodoComment(TextContent text) {
        boolean bl;
        block7: {
            TodoItem[] todos;
            PsiFile psiFile = text.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            PsiFile file = psiFile;
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            if (DumbService.Companion.isDumb(project)) {
                boolean bl2;
                block6: {
                    Iterator $this$mapNotNullTo$iv$iv;
                    TodoPattern[] todoPatternArray = TodoConfiguration.getInstance().getTodoPatterns();
                    Intrinsics.checkNotNullExpressionValue((Object)todoPatternArray, (String)"getTodoPatterns(...)");
                    Object[] $this$mapNotNull$iv = todoPatternArray;
                    boolean $i$f$mapNotNull = false;
                    Object[] objectArray = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    int n = ((void)$this$forEach$iv$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        Pattern it$iv$iv;
                        void element$iv$iv$iv;
                        void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                        boolean bl3 = false;
                        TodoPattern it = (TodoPattern)element$iv$iv;
                        boolean bl4 = false;
                        if (it.getPattern() == null) continue;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    Iterable $this$any$iv = (List)destination$iv$iv;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Pattern it = (Pattern)element$iv;
                            boolean bl6 = false;
                            boolean bl7 = !((Collection)Text.allOccurrences(it, text)).isEmpty();
                            if (!bl7) continue;
                            bl2 = true;
                            break block6;
                        }
                        bl2 = false;
                    }
                }
                return bl2;
            }
            TodoItem[] $this$any$iv = todos = (TodoItem[])CachedValuesManager.getProjectPsiDependentCache((PsiElement)((PsiElement)file), arg_0 -> CommentProblemFilter.isTodoComment$lambda$3(CommentProblemFilter::isTodoComment$lambda$2, arg_0));
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                TodoItem element$iv;
                TodoItem it = element$iv = $this$any$iv[i];
                boolean bl8 = false;
                if (!text.intersectsRange(it.getTextRange())) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        return bl;
    }

    private static final TodoItem[] isTodoComment$lambda$2(PsiFile it) {
        return PsiTodoSearchHelper.getInstance((Project)it.getProject()).findTodoItems(it);
    }

    private static final TodoItem[] isTodoComment$lambda$3(Function1 $tmp0, Object p0) {
        return (TodoItem[])$tmp0.invoke(p0);
    }
}

