/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import java.util.Collections;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001d\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0007\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\bJ\u0011\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000H\u0086\u0002J\u0014\u0010\r\u001a\u00020\u000e2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u000f\u001a\u00020\u0010H\u0096\u0080\u0004J\n\u0010\u0011\u001a\u00020\u0004H\u0096\u0080\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/grazie/text/RuleGroup;", "", "rules", "", "", "<init>", "(Ljava/util/Set;)V", "", "([Ljava/lang/String;)V", "getRules", "()Ljava/util/Set;", "plus", "other", "equals", "", "hashCode", "", "toString", "Companion", "intellij.grazie.core"})
@ApiStatus.NonExtendable
public class RuleGroup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> rules;
    @NotNull
    public static final String SENTENCE_START_CASE = "UPPERCASE_SENTENCE_START";
    @NotNull
    public static final String SENTENCE_END_PUNCTUATION = "PUNCTUATION_PARAGRAPH_END";
    @NotNull
    public static final String UNLIKELY_OPENING_PUNCTUATION = "UNLIKELY_OPENING_PUNCTUATION";
    @NotNull
    public static final String INCOMPLETE_SENTENCE = "INCOMPLETE_SENTENCE";
    @NotNull
    public static final String UNDECORATED_SENTENCE_SEPARATION = "UNDECORATED_SENTENCE_SEPARATION";
    @NotNull
    private static final RuleGroup EMPTY = new RuleGroup(new String[0]);
    @JvmField
    @NotNull
    public static final RuleGroup CASING;
    @JvmField
    @NotNull
    public static final RuleGroup SENTENCE_BOUNDARY_PUNCTUATION;
    @JvmField
    @NotNull
    public static final RuleGroup LITERALS;
    @JvmField
    @NotNull
    public static final RuleGroup UNDECORATED_SINGLE_SENTENCE;

    public RuleGroup(@NotNull Set<String> rules) {
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        Set<String> set = Collections.unmodifiableSet(rules);
        Intrinsics.checkNotNullExpressionValue(set, (String)"unmodifiableSet(...)");
        this.rules = set;
    }

    public RuleGroup(String ... rules) {
        Intrinsics.checkNotNullParameter((Object)rules, (String)"rules");
        this(ArraysKt.toSet((Object[])rules));
    }

    @NotNull
    public final Set<String> getRules() {
        return this.rules;
    }

    @NotNull
    public final RuleGroup plus(@NotNull RuleGroup other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new RuleGroup(SetsKt.plus(this.rules, (Iterable)other.rules));
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof RuleGroup && Intrinsics.areEqual(this.rules, ((RuleGroup)other).rules);
    }

    public int hashCode() {
        return ((Object)this.rules).hashCode();
    }

    @NotNull
    public String toString() {
        return this.rules.toString();
    }

    static {
        String[] stringArray = new String[]{SENTENCE_START_CASE};
        CASING = new RuleGroup(stringArray);
        stringArray = new String[]{SENTENCE_END_PUNCTUATION, UNLIKELY_OPENING_PUNCTUATION};
        SENTENCE_BOUNDARY_PUNCTUATION = new RuleGroup(stringArray);
        LITERALS = CASING.plus(SENTENCE_BOUNDARY_PUNCTUATION);
        UNDECORATED_SINGLE_SENTENCE = CASING.plus(SENTENCE_BOUNDARY_PUNCTUATION);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/grazie/text/RuleGroup$Companion;", "", "<init>", "()V", "SENTENCE_START_CASE", "", "SENTENCE_END_PUNCTUATION", "UNLIKELY_OPENING_PUNCTUATION", "INCOMPLETE_SENTENCE", "UNDECORATED_SENTENCE_SEPARATION", "EMPTY", "Lcom/intellij/grazie/text/RuleGroup;", "getEMPTY", "()Lcom/intellij/grazie/text/RuleGroup;", "CASING", "SENTENCE_BOUNDARY_PUNCTUATION", "LITERALS", "UNDECORATED_SINGLE_SENTENCE", "intellij.grazie.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RuleGroup getEMPTY() {
            return EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

