/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.NopProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.debugger.CommandLineDebugConfigurator;
import com.intellij.javascript.debugger.locationResolving.JSLocationResolver;
import com.intellij.javascript.karma.execution.KarmaConsoleProperties;
import com.intellij.javascript.karma.execution.KarmaExecutionSession;
import com.intellij.javascript.karma.execution.KarmaExecutionType;
import com.intellij.javascript.karma.execution.KarmaRunConfiguration;
import com.intellij.javascript.karma.execution.KarmaRunSettings;
import com.intellij.javascript.karma.execution.KarmaServerSettings;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.server.KarmaServerRegistry;
import com.intellij.javascript.nodejs.debug.NodeDebuggableRunProfileState;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class KarmaRunProfileState
implements NodeDebuggableRunProfileState {
    private final Project myProject;
    private final KarmaRunConfiguration myRunConfiguration;
    private final ExecutionEnvironment myEnvironment;
    private final NodePackage myKarmaPackage;
    private final KarmaRunSettings myRunSettings;
    private final KarmaExecutionType myExecutionType;
    private List<List<String>> myFailedTestNames;

    public KarmaRunProfileState(@NotNull Project project, @NotNull KarmaRunConfiguration runConfiguration, @NotNull ExecutionEnvironment environment, @NotNull NodePackage karmaPackage) {
        if (project == null) {
            KarmaRunProfileState.$$$reportNull$$$0(0);
        }
        if (runConfiguration == null) {
            KarmaRunProfileState.$$$reportNull$$$0(1);
        }
        if (environment == null) {
            KarmaRunProfileState.$$$reportNull$$$0(2);
        }
        if (karmaPackage == null) {
            KarmaRunProfileState.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myRunConfiguration = runConfiguration;
        this.myEnvironment = environment;
        this.myKarmaPackage = karmaPackage;
        this.myRunSettings = runConfiguration.getRunSettings();
        this.myExecutionType = KarmaRunProfileState.findExecutionType(this.myEnvironment.getExecutor());
    }

    @NotNull
    public Promise<ExecutionResult> execute(@Nullable CommandLineDebugConfigurator configurator) {
        Promise promise;
        try {
            promise = this.getServerOrStart().thenAsync(server -> {
                try {
                    return this.executeWithServer((KarmaServer)server);
                }
                catch (ExecutionException e) {
                    return Promises.rejectedPromise((Throwable)e);
                }
            });
        }
        catch (ExecutionException e) {
            Promise promise2 = Promises.rejectedPromise((Throwable)e);
            if (promise2 == null) {
                KarmaRunProfileState.$$$reportNull$$$0(5);
            }
            return promise2;
        }
        if (promise == null) {
            KarmaRunProfileState.$$$reportNull$$$0(4);
        }
        return promise;
    }

    @NotNull
    public Promise<KarmaServer> getServerOrStart() throws ExecutionException {
        NodeJsInterpreter interpreter = this.myRunSettings.getInterpreterRef().resolveNotNull(this.myProject);
        KarmaServerSettings serverSettings = new KarmaServerSettings(this.myEnvironment.getExecutor(), interpreter, this.myKarmaPackage, this.myRunSettings, this.myRunConfiguration);
        KarmaServerRegistry registry = KarmaServerRegistry.getInstance(this.myProject);
        KarmaServer server = registry.getServer(serverSettings);
        if (server != null && server.getRestarter().isRestartRequired()) {
            server.shutdownAsync();
            server = null;
        }
        if (server != null) {
            Promise promise = Promises.resolvedPromise((Object)server);
            if (promise == null) {
                KarmaRunProfileState.$$$reportNull$$$0(6);
            }
            return promise;
        }
        JSLocationResolver locationResolver = (JSLocationResolver)ApplicationManager.getApplication().getService(JSLocationResolver.class);
        if (locationResolver != null) {
            locationResolver.dropCache((RunProfile)this.myRunConfiguration);
        }
        Promise<KarmaServer> promise = registry.startServer(serverSettings);
        if (promise == null) {
            KarmaRunProfileState.$$$reportNull$$$0(7);
        }
        return promise;
    }

    @NotNull
    private Promise<ExecutionResult> executeWithServer(@NotNull KarmaServer server) throws ExecutionException {
        if (server == null) {
            KarmaRunProfileState.$$$reportNull$$$0(8);
        }
        return this.executeUnderProgress(new KarmaExecutionSession(this.myProject, this.myRunConfiguration, this.myEnvironment.getExecutor(), server, this.myRunSettings, this.myExecutionType, this.myFailedTestNames));
    }

    @NotNull
    private Promise<ExecutionResult> executeUnderProgress(final @NotNull KarmaExecutionSession session) {
        if (session == null) {
            KarmaRunProfileState.$$$reportNull$$$0(9);
        }
        final AsyncPromise promise = new AsyncPromise();
        String title = JavaScriptBundle.message((String)"node.execution.starting.process.progress.title", (Object[])new Object[]{this.myRunConfiguration.getName()});
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, this.myProject, title, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                KarmaRunProfileState.runInBackground((AsyncPromise<ExecutionResult>)promise, session);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/javascript/karma/execution/KarmaRunProfileState$1", "run"));
            }
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            KarmaRunProfileState.$$$reportNull$$$0(10);
        }
        return asyncPromise;
    }

    private static void runInBackground(@NotNull AsyncPromise<ExecutionResult> promise, @NotNull KarmaExecutionSession session) {
        if (promise == null) {
            KarmaRunProfileState.$$$reportNull$$$0(11);
        }
        if (session == null) {
            KarmaRunProfileState.$$$reportNull$$$0(12);
        }
        try {
            ProcessHandler processHandler = session.createProcessHandler();
            ApplicationManager.getApplication().invokeLater(() -> promise.setResult((Object)KarmaRunProfileState.createExecutionResult(session, processHandler)));
        }
        catch (Exception e) {
            promise.setError((Throwable)e);
        }
    }

    @NotNull
    private static ExecutionResult createExecutionResult(@NotNull KarmaExecutionSession session, @NotNull ProcessHandler processHandler) {
        if (session == null) {
            KarmaRunProfileState.$$$reportNull$$$0(13);
        }
        if (processHandler == null) {
            KarmaRunProfileState.$$$reportNull$$$0(14);
        }
        SMTRunnerConsoleView consoleView = session.createSMTRunnerConsoleView(processHandler);
        DefaultExecutionResult executionResult = new DefaultExecutionResult((ExecutionConsole)consoleView, processHandler);
        executionResult.setRestartActions(new AnAction[]{((KarmaConsoleProperties)consoleView.getProperties()).createRerunFailedTestsAction((ConsoleView)consoleView), new ToggleAutoTestAction()});
        if (!(processHandler instanceof NopProcessHandler)) {
            consoleView.attachToProcess(processHandler);
            session.getFolder().foldCommandLine((ConsoleView)consoleView, processHandler);
        }
        DefaultExecutionResult defaultExecutionResult = executionResult;
        if (defaultExecutionResult == null) {
            KarmaRunProfileState.$$$reportNull$$$0(15);
        }
        return defaultExecutionResult;
    }

    public void setFailedTestNames(@NotNull List<List<String>> failedTestNames) {
        if (failedTestNames == null) {
            KarmaRunProfileState.$$$reportNull$$$0(16);
        }
        this.myFailedTestNames = failedTestNames;
    }

    @NotNull
    private static KarmaExecutionType findExecutionType(@NotNull Executor executor) {
        if (executor == null) {
            KarmaRunProfileState.$$$reportNull$$$0(17);
        }
        if (executor.equals(DefaultDebugExecutor.getDebugExecutorInstance())) {
            KarmaExecutionType karmaExecutionType = KarmaExecutionType.DEBUG;
            if (karmaExecutionType == null) {
                KarmaRunProfileState.$$$reportNull$$$0(18);
            }
            return karmaExecutionType;
        }
        if (executor.equals(ExecutorRegistry.getInstance().getExecutorById("Coverage"))) {
            KarmaExecutionType karmaExecutionType = KarmaExecutionType.COVERAGE;
            if (karmaExecutionType == null) {
                KarmaRunProfileState.$$$reportNull$$$0(19);
            }
            return karmaExecutionType;
        }
        KarmaExecutionType karmaExecutionType = KarmaExecutionType.RUN;
        if (karmaExecutionType == null) {
            KarmaRunProfileState.$$$reportNull$$$0(20);
        }
        return karmaExecutionType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 10, 15, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "karmaPackage";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 15: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/execution/KarmaRunProfileState";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failedTestNames";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/execution/KarmaRunProfileState";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerOrStart";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "executeUnderProgress";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutionResult";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findExecutionType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 15: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeWithServer";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "executeUnderProgress";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runInBackground";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createExecutionResult";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setFailedTestNames";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findExecutionType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 10, 15, 18, 19, 20 -> new IllegalStateException(string);
        };
    }
}

