/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.pro.utils.filtering;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.py.environment.frame.JupyterVarsFrameAccessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.scientific.tables.api.filters.FilterValuePanelCustomizer;
import com.intellij.util.TextFieldCompletionProvider;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.containerview.PyDataViewerCompletionProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/py/pro/utils/filtering/PythonFilterValuePanelCustomizer;", "Lcom/intellij/scientific/tables/api/filters/FilterValuePanelCustomizer;", "<init>", "()V", "getFileType", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "getFrameAccessor", "Lcom/intellij/jupyter/py/environment/frame/JupyterVarsFrameAccessor;", "project", "Lcom/intellij/openapi/project/Project;", "getCompletionProvider", "Lcom/intellij/util/TextFieldCompletionProvider;", "intellij.jupyter.py.pro"})
public final class PythonFilterValuePanelCustomizer
implements FilterValuePanelCustomizer {
    @NotNull
    public LanguageFileType getFileType() {
        PythonFileType pythonFileType = PythonFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)pythonFileType, (String)"INSTANCE");
        return (LanguageFileType)pythonFileType;
    }

    private final JupyterVarsFrameAccessor getFrameAccessor(Project project) {
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor == null) {
            return null;
        }
        Editor selectedTextEditor = editor;
        VirtualFile virtualFile = selectedTextEditor.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        BackedNotebookVirtualFile notebookFile = BackedNotebookVirtualFile.Companion.takeBackend(virtualFile2);
        return new JupyterVarsFrameAccessor(project, notebookFile);
    }

    @Nullable
    public TextFieldCompletionProvider getCompletionProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JupyterVarsFrameAccessor jupyterVarsFrameAccessor = this.getFrameAccessor(project);
        if (jupyterVarsFrameAccessor == null) {
            return null;
        }
        JupyterVarsFrameAccessor frameAccessor = jupyterVarsFrameAccessor;
        return (TextFieldCompletionProvider)new PyDataViewerCompletionProvider((PyFrameAccessor)frameAccessor);
    }
}

