/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.freezeAnalyzer;

import com.intellij.platform.diagnostic.freezeAnalyzer.FreezeAnalysisResult;
import com.intellij.threadDumpParser.ThreadDumpParser;
import com.intellij.threadDumpParser.ThreadState;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007J\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002J*\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000bH\u0002J \u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\f\u0010\u001a\u001a\u00020\n*\u00020\u0007H\u0002J\f\u0010\u001b\u001a\u00020\n*\u00020\u0007H\u0002J\f\u0010\u001c\u001a\u00020\n*\u00020\u0007H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001f2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0007H\u0002J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007H\u0002\u00a8\u0006$"}, d2={"Lcom/intellij/platform/diagnostic/freezeAnalyzer/FreezeAnalyzer;", "", "<init>", "()V", "analyzeFreeze", "Lcom/intellij/platform/diagnostic/freezeAnalyzer/FreezeAnalysisResult;", "threadDump", "", "testName", "isEdtWaiting", "", "Lcom/intellij/threadDumpParser/ThreadState;", "analyzeEDThread", "edt", "threadDumpParsed", "", "isWaitingOnSuvorod", "isEDTFreezed", "analyzeLock", "getPotentialMethodsWithLock", "stackTrace", "isWriteLockWait", "threadState", "findThreadThatTookReadWriteLock", "isWaitingOnReadWriteLock", "isReadWriteLockTaken", "isLockMethod", "isJDKMethod", "isRelevantMethod", "findFirstRelevantMethod", "getMethodList", "Lkotlin/sequences/Sequence;", "extractMethodName", "line", "extractClassFromMethod", "method", "intellij.platform.diagnostic.freezeAnalyzer"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nFreezeAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FreezeAnalyzer.kt\ncom/intellij/platform/diagnostic/freezeAnalyzer/FreezeAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,218:1\n296#2,2:219\n296#2,2:232\n1807#2,3:238\n2792#2,3:241\n1924#2,2:244\n1807#2,3:246\n1926#2:249\n296#2,2:250\n1#3:221\n1276#4,2:222\n1276#4,2:224\n184#4,2:226\n1276#4,2:228\n184#4,2:230\n1276#4,2:234\n184#4,2:236\n*S KotlinDebug\n*F\n+ 1 FreezeAnalyzer.kt\ncom/intellij/platform/diagnostic/freezeAnalyzer/FreezeAnalyzer\n*L\n21#1:219,2\n92#1:232,2\n142#1:238,3\n167#1:241,3\n185#1:244,2\n186#1:246,3\n185#1:249\n199#1:250,2\n38#1:222,2\n48#1:224,2\n55#1:226,2\n78#1:228,2\n90#1:230,2\n108#1:234,2\n120#1:236,2\n*E\n"})
public final class FreezeAnalyzer {
    @NotNull
    public static final FreezeAnalyzer INSTANCE = new FreezeAnalyzer();

    private FreezeAnalyzer() {
    }

    @Nullable
    public final FreezeAnalysisResult analyzeFreeze(@NotNull String threadDump, @Nullable String testName) {
        FreezeAnalysisResult freezeAnalysisResult;
        ThreadState edtThread;
        Object v1;
        List threadDumpParsed;
        block3: {
            Intrinsics.checkNotNullParameter((Object)threadDump, (String)"threadDump");
            String threadDumpWithoutCoroutine = StringsKt.substringBefore$default((String)StringsKt.substringBefore$default((String)threadDump, (String)"---------- Coroutine dump ----------", null, (int)2, null), (String)"---------- Coroutine dump (stripped) ----------", null, (int)2, null);
            List list = ThreadDumpParser.parse((String)threadDumpWithoutCoroutine);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parse(...)");
            threadDumpParsed = list;
            Iterable $this$firstOrNull$iv = threadDumpParsed;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ThreadState it = (ThreadState)element$iv;
                boolean bl = false;
                if (!it.isEDT()) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        ThreadState threadState = edtThread = (ThreadState)v1;
        if (threadState != null) {
            ThreadState it = threadState;
            boolean bl = false;
            freezeAnalysisResult = INSTANCE.analyzeEDThread(it, threadDumpParsed, testName);
        } else {
            freezeAnalysisResult = null;
        }
        return freezeAnalysisResult;
    }

    public static /* synthetic */ FreezeAnalysisResult analyzeFreeze$default(FreezeAnalyzer freezeAnalyzer, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return freezeAnalyzer.analyzeFreeze(string, string2);
    }

    private final boolean isEdtWaiting(ThreadState $this$isEdtWaiting) {
        return $this$isEdtWaiting.isWaiting() || this.isWaitingOnSuvorod($this$isEdtWaiting);
    }

    private final FreezeAnalysisResult analyzeEDThread(ThreadState edt, List<? extends ThreadState> threadDumpParsed, String testName) {
        FreezeAnalysisResult freezeAnalysisResult;
        if (!this.isEdtWaiting(edt) && !edt.isSleeping()) {
            String string = edt.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(...)");
            String string2 = this.findFirstRelevantMethod(string);
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                freezeAnalysisResult = new FreezeAnalysisResult("EDT is busy with " + it, CollectionsKt.listOf((Object)edt), null, 4, null);
            } else {
                freezeAnalysisResult = null;
            }
        } else if (this.isEdtWaiting(edt) && this.isWriteLockWait(edt)) {
            FreezeAnalysisResult freezeAnalysisResult2 = this.findThreadThatTookReadWriteLock(threadDumpParsed);
            if (freezeAnalysisResult2 != null) {
                FreezeAnalysisResult it = freezeAnalysisResult2;
                boolean bl = false;
                freezeAnalysisResult = new FreezeAnalysisResult(it.getMessage(), CollectionsKt.plus((Collection)it.getThreads(), (Iterable)CollectionsKt.listOf((Object)edt)), it.getAdditionalMessage());
            } else {
                freezeAnalysisResult = null;
            }
        } else {
            freezeAnalysisResult = this.isEdtWaiting(edt) && !this.isEDTFreezed(edt) && testName == null ? null : (this.isEdtWaiting(edt) && !this.isEDTFreezed(edt) && testName != null ? new FreezeAnalysisResult(testName + ": EDT is not blocked/busy (freeze can be the result of extensive GC)", CollectionsKt.listOf((Object)edt), null, 4, null) : (this.isEdtWaiting(edt) ? this.analyzeLock(edt, threadDumpParsed) : null));
        }
        return freezeAnalysisResult;
    }

    private final boolean isWaitingOnSuvorod(ThreadState edt) {
        boolean bl;
        block1: {
            String string = edt.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(...)");
            Sequence<String> $this$any$iv = this.getMethodList(string);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"SuvorovProgress", (boolean)false, (int)2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isEDTFreezed(ThreadState edt) {
        String string = edt.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(...)");
        return !Intrinsics.areEqual((Object)this.findFirstRelevantMethod(string), (Object)"com.intellij.ide.IdeEventQueue.getNextEvent");
    }

    /*
     * WARNING - void declaration
     */
    private final FreezeAnalysisResult analyzeLock(ThreadState edt, List<? extends ThreadState> threadDumpParsed) {
        Object it;
        String string = edt.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(...)");
        String relevantMethodFromEdt = this.findFirstRelevantMethod(string);
        if (relevantMethodFromEdt == null) {
            return null;
        }
        if (edt.getStackTrace() != null) {
            String string2 = edt.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStackTrace(...)");
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"on kotlinx.coroutines.BlockingCoroutine", (boolean)false, (int)2, null)) {
                boolean bl;
                block9: {
                    String string3 = edt.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getStackTrace(...)");
                    Sequence<String> $this$any$iv = this.getMethodList(string3);
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.contains$default((CharSequence)((CharSequence)it), (CharSequence)"BlockingCoroutine.joinBlocking", (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
                if (bl) {
                    return new FreezeAnalysisResult("EDT is blocked on " + relevantMethodFromEdt + " which called runBlocking", CollectionsKt.listOf((Object)edt), null, 4, null);
                }
            }
        }
        ThreadState possibleThreadWithLock = null;
        String string4 = edt.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getStackTrace(...)");
        for (String it2 : this.getPotentialMethodsWithLock(string4)) {
            Object v6;
            block10: {
                void $this$firstOrNull$iv;
                String clazz = this.extractClassFromMethod(it2);
                it = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)threadDumpParsed), FreezeAnalyzer::analyzeLock$lambda$1), FreezeAnalyzer::analyzeLock$lambda$2);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ThreadState it3 = (ThreadState)element$iv;
                    boolean bl = false;
                    String string5 = it3.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getStackTrace(...)");
                    if (!StringsKt.contains$default((CharSequence)string5, (CharSequence)clazz, (boolean)false, (int)2, null)) continue;
                    v6 = element$iv;
                    break block10;
                }
                v6 = null;
            }
            if ((possibleThreadWithLock = (ThreadState)v6) == null) continue;
        }
        if (possibleThreadWithLock == null) {
            return null;
        }
        String string6 = possibleThreadWithLock.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getStackTrace(...)");
        String methodFromThreadWithLock = this.findFirstRelevantMethod(string6);
        if (methodFromThreadWithLock != null) {
            Object[] objectArray = new ThreadState[]{edt, possibleThreadWithLock};
            return new FreezeAnalysisResult("EDT is blocked on " + relevantMethodFromEdt, CollectionsKt.listOf((Object[])objectArray), "Possibly locked by " + methodFromThreadWithLock + " in " + possibleThreadWithLock.getName());
        }
        return null;
    }

    private final List<String> getPotentialMethodsWithLock(String stackTrace) {
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter(this.getMethodList(stackTrace), FreezeAnalyzer::getPotentialMethodsWithLock$lambda$0), FreezeAnalyzer::getPotentialMethodsWithLock$lambda$1), FreezeAnalyzer::getPotentialMethodsWithLock$lambda$2));
    }

    private final boolean isWriteLockWait(ThreadState threadState) {
        boolean bl;
        block1: {
            String string = threadState.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(...)");
            Sequence $this$any$iv = SequencesKt.map((Sequence)StringsKt.lineSequence((CharSequence)string), FreezeAnalyzer::isWriteLockWait$lambda$0);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                if (!(StringsKt.startsWith$default((String)it, (String)"at com.intellij.openapi.application.impl.ReadMostlyRWLock.writeLock", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"at com.intellij.openapi.application.impl.AnyThreadWriteThreadingSupport.getWritePermit", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"at com.intellij.openapi.application.impl.ComputationState.upgradeWritePermit", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)it, (CharSequence)"SuvorovProgress", (boolean)false, (int)2, null))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final FreezeAnalysisResult findThreadThatTookReadWriteLock(List<? extends ThreadState> threadDumpParsed) {
        FreezeAnalysisResult freezeAnalysisResult;
        Object v1;
        block8: {
            Sequence $this$firstOrNull$iv = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)threadDumpParsed), FreezeAnalyzer::findThreadThatTookReadWriteLock$lambda$0), FreezeAnalyzer::findThreadThatTookReadWriteLock$lambda$1), FreezeAnalyzer::findThreadThatTookReadWriteLock$lambda$2);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ThreadState it = (ThreadState)element$iv;
                boolean bl = false;
                String string = it.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(...)");
                if (!INSTANCE.isReadWriteLockTaken(string)) continue;
                v1 = element$iv;
                break block8;
            }
            v1 = null;
        }
        ThreadState threadState = v1;
        if (threadState != null) {
            Object v2;
            ThreadState threadState2;
            block9: {
                threadState2 = threadState;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = threadDumpParsed;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ThreadState it = (ThreadState)element$iv;
                    boolean bl2 = false;
                    if (!it.isAwaitedBy(threadState2)) continue;
                    v2 = element$iv;
                    break block9;
                }
                v2 = null;
            }
            ThreadState threadState3 = v2;
            if (threadState3 != null) {
                ThreadState it = threadState3;
                boolean bl = false;
                if (INSTANCE.isWaitingOnReadWriteLock(it)) {
                    String string = threadState2.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(...)");
                    String string2 = INSTANCE.findFirstRelevantMethod(string);
                    String string3 = it.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getStackTrace(...)");
                    var10_15 = new ThreadState[]{threadState2, it};
                    FreezeAnalysisResult freezeAnalysisResult2 = new FreezeAnalysisResult("Possible deadlock. Read lock is taken by " + string2 + ", but the thread is blocked by " + INSTANCE.findFirstRelevantMethod(string3) + " which is waiting on RWLock", CollectionsKt.listOf((Object[])var10_15), threadState2.getName() + " took RWLock but it's blocked by " + it.getName() + " which waits on RWLock");
                    freezeAnalysisResult = freezeAnalysisResult2;
                } else {
                    String string = threadState2.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(...)");
                    String string4 = INSTANCE.findFirstRelevantMethod(string);
                    String string5 = it.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getStackTrace(...)");
                    var10_15 = new ThreadState[]{threadState2, it};
                    FreezeAnalysisResult freezeAnalysisResult3 = new FreezeAnalysisResult("Read lock is taken by " + string4 + ", but this thread is blocked by " + INSTANCE.findFirstRelevantMethod(string5), CollectionsKt.listOf((Object[])var10_15), threadState2.getName() + " took RWLock but it's blocked by " + it.getName());
                    freezeAnalysisResult = freezeAnalysisResult3;
                }
            } else {
                String string = threadState2.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(...)");
                freezeAnalysisResult = new FreezeAnalysisResult("Long read action in " + INSTANCE.findFirstRelevantMethod(string), CollectionsKt.listOf((Object)threadState2), null, 4, null);
            }
        } else {
            freezeAnalysisResult = null;
        }
        return freezeAnalysisResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isWaitingOnReadWriteLock(ThreadState threadState) {
        boolean bl;
        if (!threadState.isWaiting()) return false;
        String string = threadState.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(...)");
        Sequence $this$any$iv = SequencesKt.map((Sequence)SequencesKt.drop((Sequence)StringsKt.lineSequence((CharSequence)string), (int)2), FreezeAnalyzer::isWaitingOnReadWriteLock$lambda$0);
        boolean $i$f$any = false;
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            String it = (String)element$iv;
            boolean bl2 = false;
            if (StringsKt.startsWith$default((String)it, (String)"at com.intellij.openapi.application.impl.ReadMostlyRWLock.waitABit", (boolean)false, (int)2, null)) return true;
            if (StringsKt.startsWith$default((String)it, (String)"at com.intellij.openapi.application.impl.AnyThreadWriteThreadingSupport.getReadPermit", (boolean)false, (int)2, null)) return true;
            if (StringsKt.startsWith$default((String)it, (String)"at com.intellij.openapi.application.impl.AnyThreadWriteThreadingSupport.getWritePermit", (boolean)false, (int)2, null)) return true;
            if (StringsKt.startsWith$default((String)it, (String)"at com.intellij.openapi.application.impl.ComputationState.acquireReadPermit", (boolean)false, (int)2, null)) return true;
            if (StringsKt.startsWith$default((String)it, (String)"at com.intellij.openapi.application.impl.ComputationState.upgradeWritePermit", (boolean)false, (int)2, null)) return true;
            if (StringsKt.startsWith$default((String)it, (String)"at com.intellij.platform.locking.impl.RunSuspend.await", (boolean)false, (int)2, null)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final boolean isReadWriteLockTaken(String stackTrace) {
        Object v0;
        block1: {
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)StringsKt.lineSequence((CharSequence)stackTrace), FreezeAnalyzer::isReadWriteLockTaken$lambda$0);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!INSTANCE.isLockMethod(it)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    private final boolean isLockMethod(String $this$isLockMethod) {
        return StringsKt.startsWith$default((String)$this$isLockMethod, (String)"at com.intellij.openapi.application.impl.RwLockHolder.tryRunReadAction", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$isLockMethod, (String)"at com.intellij.openapi.application.ReadAction.compute", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$isLockMethod, (String)"at com.intellij.openapi.application.impl.AnyThreadWriteThreadingSupport.runWriteAction", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$isLockMethod, (String)"at com.intellij.openapi.application.impl.AnyThreadWriteThreadingSupport.runReadAction", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$isLockMethod, (String)"at com.intellij.openapi.application.impl.AnyThreadWriteThreadingSupport.runWriteIntentReadAction", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$isLockMethod, (String)"at com.intellij.openapi.application.impl.AnyThreadWriteThreadingSupport.tryRunReadAction", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)$this$isLockMethod, (CharSequence)"NestedLocksThreadingSupport.runWriteAction", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)$this$isLockMethod, (CharSequence)"NestedLocksThreadingSupport.runReadAction", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)$this$isLockMethod, (CharSequence)"NestedLocksThreadingSupport.runWriteIntentReadAction", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)$this$isLockMethod, (CharSequence)"NestedLocksThreadingSupport.tryRunReadAction", (boolean)false, (int)2, null);
    }

    private final boolean isJDKMethod(String $this$isJDKMethod) {
        boolean bl;
        block3: {
            Object[] objectArray = new String[]{"at java.", "at jdk.", "at kotlin.", "at kotlinx."};
            List jdkList = CollectionsKt.listOf((Object[])objectArray);
            Iterable $this$any$iv = jdkList;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)$this$isJDKMethod, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRelevantMethod(String $this$isRelevantMethod) {
        String it;
        Object[] objectArray = new String[]{"at com.intellij.openapi.diagnostic.", "at com.intellij.idea.IdeaLogger.warn", "at com.intellij.util.", "at com.intellij.ide.", "at com.intellij.serialization.", "at com.intellij.openapi.progress.util.", "at com.intellij.openapi.vfs.", "at com.intellij.openapi.util.", "at it.unimi.dsi.fastutil.", "at com.google.common.collect.", "at com.intellij.psi.", "at com.intellij.indexing.composite.", "at com.intellij.openapi.progress.", "at com.intellij.openapi.application.", "at platform/jdk.zipfs", "at net.jpountz.lz4.", "at com.intellij.concurrency.", "at com.intellij.platform.locking."};
        List irrelevantStarts = CollectionsKt.listOf((Object[])objectArray);
        if (StringsKt.contains$default((CharSequence)$this$isRelevantMethod, (CharSequence)"$$Lambda", (boolean)false, (int)2, null)) {
            return false;
        }
        if (this.isJDKMethod($this$isRelevantMethod)) return false;
        Iterable $this$none$iv = irrelevantStarts;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!StringsKt.startsWith$default((String)$this$isRelevantMethod, (String)it, (boolean)false, (int)2, null));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final String findFirstRelevantMethod(String stackTrace) {
        String string;
        String string2;
        Object v2;
        String it;
        boolean $i$f$firstOrNull;
        Iterable $this$firstOrNull$iv;
        List methodList;
        block14: {
            methodList = SequencesKt.toList(this.getMethodList(stackTrace));
            if (methodList.isEmpty()) {
                return null;
            }
            Object[] objectArray = new String[]{"at com.intellij.openapi.application.impl.ApplicationImpl.runReadAction", "at com.intellij.openapi.application.ActionsKt.runReadAction", "at com.intellij.openapi.application.ReadAction.compute", "at com.intellij.openapi.application.ReadAction.run", "at com.intellij.openapi.application.rw.InternalReadAction.insideReadAction"};
            List readActions = CollectionsKt.listOf((Object[])objectArray);
            String blockingMethod = null;
            Iterable $this$forEachIndexed$iv = methodList;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                boolean bl;
                block13: {
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String string3 = (String)item$iv;
                    int i = n;
                    boolean bl2 = false;
                    Iterable $this$any$iv = readActions;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            void line;
                            String it2 = (String)element$iv;
                            boolean bl3 = false;
                            if (!StringsKt.startsWith$default((String)line, (String)it2, (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block13;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                for (int j = i - 1; -1 < j; --j) {
                    String candidate = (String)methodList.get(j);
                    if (!INSTANCE.isRelevantMethod(candidate)) continue;
                    blockingMethod = candidate;
                    break;
                }
                if (blockingMethod != null) continue;
            }
            String string4 = blockingMethod;
            if (string4 != null) {
                return this.extractMethodName(string4);
            }
            $this$firstOrNull$iv = methodList;
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (String)element$iv;
                boolean bl = false;
                if (!INSTANCE.isRelevantMethod(it)) continue;
                v2 = element$iv;
                break block14;
            }
            v2 = null;
        }
        if ((string2 = (String)v2) == null) {
            Object v4;
            block15: {
                $this$firstOrNull$iv = methodList;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (String)element$iv;
                    boolean bl = false;
                    if (!(!INSTANCE.isJDKMethod(it))) continue;
                    v4 = element$iv;
                    break block15;
                }
                v4 = null;
            }
            string2 = v4;
        }
        if (string2 != null) {
            String it3 = string2;
            boolean bl = false;
            string = INSTANCE.extractMethodName(it3);
        } else {
            string = null;
        }
        return string;
    }

    private final Sequence<String> getMethodList(String stackTrace) {
        return SequencesKt.filter((Sequence)SequencesKt.map((Sequence)StringsKt.lineSequence((CharSequence)stackTrace), FreezeAnalyzer::getMethodList$lambda$0), FreezeAnalyzer::getMethodList$lambda$1);
    }

    private final String extractMethodName(String line) {
        String string;
        int startIndex = StringsKt.indexOf$default((CharSequence)line, (String)"at ", (int)0, (boolean)false, (int)6, null) + 3;
        int endIndex = StringsKt.indexOf$default((CharSequence)line, (char)'(', (int)0, (boolean)false, (int)6, null);
        boolean bl = 0 <= startIndex ? startIndex < endIndex : false;
        if (bl) {
            String string2 = line.substring(startIndex, endIndex);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = "";
        }
        return string;
    }

    private final String extractClassFromMethod(String method) {
        char[] cArray = new char[]{'('};
        CharSequence charSequence = (CharSequence)CollectionsKt.first((List)StringsKt.split$default((CharSequence)method, (char[])cArray, (boolean)false, (int)0, (int)6, null));
        cArray = new char[]{'.'};
        return (String)CollectionsKt.last((List)CollectionsKt.dropLast((List)StringsKt.split$default((CharSequence)charSequence, (char[])cArray, (boolean)false, (int)0, (int)6, null), (int)1));
    }

    private static final boolean analyzeLock$lambda$1(ThreadState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it.getName(), (Object)"Coroutine dump");
    }

    private static final boolean analyzeLock$lambda$2(ThreadState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isWaiting();
    }

    private static final boolean getPotentialMethodsWithLock$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !INSTANCE.isJDKMethod(it);
    }

    private static final boolean getPotentialMethodsWithLock$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !StringsKt.startsWith$default((String)it, (String)"at com.intellij.util.concurrency", (boolean)false, (int)2, null);
    }

    private static final boolean getPotentialMethodsWithLock$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !StringsKt.startsWith$default((String)it, (String)"at com.intellij.openapi.progress.util.ProgressIndicatorUtils", (boolean)false, (int)2, null);
    }

    private static final String isWriteLockWait$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trimStart((CharSequence)it)).toString();
    }

    private static final boolean findThreadThatTookReadWriteLock$lambda$0(ThreadState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it.getName(), (Object)"Coroutine dump");
    }

    private static final boolean findThreadThatTookReadWriteLock$lambda$1(ThreadState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !INSTANCE.isWaitingOnReadWriteLock(it) && !it.isKnownJDKThread();
    }

    private static final boolean findThreadThatTookReadWriteLock$lambda$2(ThreadState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isEDT();
    }

    private static final String isWaitingOnReadWriteLock$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trimStart((CharSequence)it)).toString();
    }

    private static final String isReadWriteLockTaken$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trim((CharSequence)it)).toString();
    }

    private static final String getMethodList$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trim((CharSequence)it)).toString();
    }

    private static final boolean getMethodList$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.startsWith$default((String)it, (String)"at", (boolean)false, (int)2, null);
    }
}

