/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.application.metadata.additional.SpringBootAdditionalConfigUtils;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SpringBootConfigFileUsageTypeProvider
implements UsageTypeProvider {
    private static final UsageType CONFIGURATION_FILE_USAGE_TYPE = new UsageType(SpringBootApiBundle.messagePointer((String)"application.config.usage.type", (Object[])new Object[0]));
    private static final UsageType ADDITIONAL_METADATA_USAGE_TYPE = new UsageType(SpringBootApiBundle.messagePointer((String)"additional.config.usage.type", (Object[])new Object[0]));

    SpringBootConfigFileUsageTypeProvider() {
    }

    @Nullable
    public UsageType getUsageType(@NotNull PsiElement element) {
        Project project;
        if (element == null) {
            SpringBootConfigFileUsageTypeProvider.$$$reportNull$$$0(0);
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary((Project)(project = element.getProject()))) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return null;
        }
        VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (SpringBootAdditionalConfigUtils.isJsonFile((PsiFile)element.getContainingFile())) {
            if (virtualFile.getName().equals("additional-spring-configuration-metadata.json")) {
                return ADDITIONAL_METADATA_USAGE_TYPE;
            }
            return null;
        }
        List configFiles = SpringBootConfigurationFileService.getInstance().findConfigFilesWithImports(module, true);
        if (configFiles.contains(virtualFile)) {
            return CONFIGURATION_FILE_USAGE_TYPE;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/config/SpringBootConfigFileUsageTypeProvider", "getUsageType"));
    }
}

