/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.microservices.jvm.config.hints.HintReferenceBase;
import com.intellij.microservices.jvm.config.hints.HintReferenceProviderBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ProcessingContext;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RegExReferenceProvider
extends HintReferenceProviderBase {
    private final Pattern myPattern;

    RegExReferenceProvider(String regExPattern) {
        this.myPattern = Pattern.compile(regExPattern);
    }

    @NotNull
    protected PsiReference createReference(PsiElement element, TextRange textRange, ProcessingContext context) {
        return new HintReferenceBase(element, textRange){

            @Nullable
            protected PsiElement doResolve() {
                if (RegExReferenceProvider.this.myPattern.matcher(this.getValue()).matches()) {
                    return this.getElement();
                }
                return null;
            }

            @NotNull
            public String getUnresolvedMessagePattern() {
                String string = "Value ''{0}'' does not match pattern ''" + String.valueOf(RegExReferenceProvider.this.myPattern) + "''";
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/RegExReferenceProvider$1", "getUnresolvedMessagePattern"));
            }
        };
    }
}

