/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.structure;

import com.intellij.ide.structureView.logical.model.LogicalModelPresentationProvider;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.boot.application.structure.SpringBootAppConfigurationLogicalModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.stereotype.SpringController;
import com.intellij.spring.model.jam.stereotype.SpringRepository;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/spring/boot/application/structure/SpringBootAppConfigurationLogicalModelPresentationProvider;", "Lcom/intellij/ide/structureView/logical/model/LogicalModelPresentationProvider;", "Lcom/intellij/spring/boot/application/structure/SpringBootAppConfigurationLogicalModel;", "<init>", "()V", "getColoredText", "", "Lcom/intellij/ide/util/treeView/PresentableNodeDescriptor$ColoredFragment;", "t", "getName", "", "getIcon", "Ljavax/swing/Icon;", "getTypeName", "intellij.spring.boot.core"})
@SourceDebugExtension(value={"SMAP\nSpringBootAppConfigurationLogicalModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBootAppConfigurationLogicalModel.kt\ncom/intellij/spring/boot/application/structure/SpringBootAppConfigurationLogicalModelPresentationProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public final class SpringBootAppConfigurationLogicalModelPresentationProvider
extends LogicalModelPresentationProvider<SpringBootAppConfigurationLogicalModel> {
    @NotNull
    public List<PresentableNodeDescriptor.ColoredFragment> getColoredText(@NotNull SpringBootAppConfigurationLogicalModel t) {
        Intrinsics.checkNotNullParameter((Object)((Object)t), (String)"t");
        SimpleTextAttributes textAttributes = t.getConfiguredProperties().isEmpty() ? SimpleTextAttributes.GRAY_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        return CollectionsKt.listOf((Object)new PresentableNodeDescriptor.ColoredFragment(this.getTypeName(t), textAttributes));
    }

    @NotNull
    public String getName(@NotNull SpringBootAppConfigurationLogicalModel t) {
        Intrinsics.checkNotNullParameter((Object)((Object)t), (String)"t");
        if (!t.isValid()) {
            return "";
        }
        Object object = t.getSpringBean().getBeanType();
        if ((object == null || (object = object.getPresentableText()) == null) && (object = t.getSpringBean().getBeanName()) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public Icon getIcon(@NotNull SpringBootAppConfigurationLogicalModel t) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)((Object)t), (String)"t");
        CommonSpringBean commonSpringBean = t.getSpringBean();
        if (commonSpringBean instanceof SpringRepository) {
            Icon icon2 = SpringApiIcons.SpringData;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"SpringData");
        } else if (commonSpringBean instanceof SpringController) {
            Icon icon3 = SpringApiIcons.SpringWeb;
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"SpringWeb");
        } else if (commonSpringBean instanceof SpringConfiguration) {
            Icon icon4 = SpringApiIcons.SpringJavaConfig;
            icon = icon4;
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"SpringJavaConfig");
        } else {
            Icon icon5 = SpringApiIcons.Spring;
            icon = icon5;
            Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"Spring");
        }
        return icon;
    }

    @Nullable
    public String getTypeName(@NotNull SpringBootAppConfigurationLogicalModel t) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)((Object)t), (String)"t");
        if (!t.isValid()) {
            return "";
        }
        Collection it = collection = t.getSpringBean().getSpringQualifiers();
        boolean bl = false;
        Collection collection2 = it.size() == 1 ? collection : null;
        String qualifier = collection2 != null && (collection2 = (SpringQualifier)CollectionsKt.first((Iterable)collection2)) != null ? collection2.getQualifierValue() : null;
        String string = qualifier;
        if (string == null) {
            string = t.getSpringBean().getBeanName();
        }
        return string;
    }
}

