/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.boot.facet.SpringBootFileSetEditorCustomization;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigClassConditionEvaluator;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigLocalAnnotationModel;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContextBase;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalAnnotationModelDependentModelsProvider;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.util.PairProcessor;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAutoConfigDependentModelsProvider
extends LocalAnnotationModelDependentModelsProvider {
    private final Key<CachedValue<Set<Pair<LocalModel<?>, LocalModelDependency>>>> AUTO_CONFIG_MODELS_KEY = Key.create((String)("AUTO_CONFIG_MODELS_KEY_" + ((Object)((Object)this)).getClass().getSimpleName()));

    public boolean processCustomDependentLocalModels(LocalAnnotationModel localAnnotationModel, PairProcessor<? super LocalModel<?>, ? super LocalModelDependency> processor) {
        if (!this.acceptModel(localAnnotationModel)) {
            return true;
        }
        for (Pair<LocalModel<?>, LocalModelDependency> pair : this.getAutoConfigModels(localAnnotationModel)) {
            if (processor.process(pair.getFirst(), pair.getSecond())) continue;
            return false;
        }
        return true;
    }

    protected boolean acceptModel(@NotNull LocalAnnotationModel model) {
        if (model == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(0);
        }
        return SpringBootLibraryUtil.hasSpringBootLibrary((Module)model.getModule());
    }

    @NotNull
    private Set<Pair<LocalModel<?>, LocalModelDependency>> getAutoConfigModels(@NotNull LocalAnnotationModel localAnnotationModel) {
        if (localAnnotationModel == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(1);
        }
        Project project = localAnnotationModel.getConfig().getProject();
        Set set = (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)localAnnotationModel, this.AUTO_CONFIG_MODELS_KEY, () -> {
            Set<Pair<LocalModel<?>, LocalModelDependency>> autoConfigModels = this.findAutoConfigModels(localAnnotationModel);
            return CachedValueProvider.Result.create(autoConfigModels, (Object[])SpringModificationTrackersManager.getInstance((Project)project).getOuterModelsDependencies());
        }, false);
        if (set == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    private Set<Pair<LocalModel<?>, LocalModelDependency>> findAutoConfigModels(@NotNull LocalAnnotationModel localAnnotationModel) {
        if (localAnnotationModel == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(3);
        }
        Module module = localAnnotationModel.getModule();
        boolean nonStrictEvaluation = AbstractAutoConfigDependentModelsProvider.isNonStrictEvaluation(module);
        NotNullLazyValue<List<VirtualFile>> configFilesCache = AbstractAutoConfigDependentModelsProvider.createConfigFilesCache(module, localAnnotationModel.getActiveProfiles());
        LinkedHashSet autoConfigModels = new LinkedHashSet();
        ConditionalOnEvaluationContext sharedContext = AbstractAutoConfigDependentModelsProvider.createContext(localAnnotationModel.getConfig(), module, localAnnotationModel.getActiveProfiles(), configFilesCache, null);
        List<PsiClass> autoConfigClasses = this.getAutoConfigClasses(localAnnotationModel, sharedContext);
        for (PsiClass autoConfigClass : autoConfigClasses) {
            sharedContext = this.processConfigurationClass(autoConfigModels, autoConfigClass, nonStrictEvaluation, sharedContext, module, localAnnotationModel.getActiveProfiles(), configFilesCache);
        }
        LinkedHashSet linkedHashSet = autoConfigModels;
        if (linkedHashSet == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(4);
        }
        return linkedHashSet;
    }

    protected abstract List<PsiClass> getAutoConfigClasses(@NotNull LocalAnnotationModel var1, @NotNull ConditionalOnEvaluationContext var2);

    private static ConditionalOnEvaluationContext createContext(@NotNull PsiClass psiClass, @NotNull Module module, @NotNull Set<String> activeProfiles, @NotNull NotNullLazyValue<List<VirtualFile>> configFilesCache, @Nullable ConditionalOnEvaluationContext sharedContext) {
        if (psiClass == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(5);
        }
        if (module == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(6);
        }
        if (activeProfiles == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(7);
        }
        if (configFilesCache == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(8);
        }
        ConditionalOnEvaluationContextBase useSharedContext = sharedContext instanceof ConditionalOnEvaluationContextBase ? (ConditionalOnEvaluationContextBase)sharedContext : null;
        return new ConditionalOnEvaluationContextBase(psiClass, module, activeProfiles, configFilesCache, useSharedContext);
    }

    static NotNullLazyValue<List<VirtualFile>> createConfigFilesCache(Module module, Set<String> activeProfiles) {
        boolean includeTestScope = activeProfiles != null && activeProfiles.contains("_DEFAULT_TEST_PROFILE_NAME_");
        return NotNullLazyValue.lazy(() -> SpringBootConfigurationFileService.getInstance().findConfigFiles(module, includeTestScope));
    }

    private static boolean isNonStrictEvaluation(@NotNull Module module) {
        SpringFacet springFacet;
        if (module == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(9);
        }
        CustomSetting.BOOLEAN setting = (springFacet = SpringFacet.getInstance((Module)module)) != null ? (CustomSetting.BOOLEAN)springFacet.findSetting(SpringBootFileSetEditorCustomization.NON_STRICT_SETTING) : null;
        return setting == null || setting.getBooleanValue();
    }

    @NotNull
    private ConditionalOnEvaluationContext processConfigurationClass(@NotNull Set<Pair<LocalModel<?>, LocalModelDependency>> autoConfigModels, @NotNull PsiClass autoConfigClass, boolean nonStrictEvaluation, @Nullable ConditionalOnEvaluationContext sharedContext, @NotNull Module module, @NotNull Set<String> activeProfiles, @NotNull NotNullLazyValue<List<VirtualFile>> configFilesCache) {
        if (autoConfigModels == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(10);
        }
        if (autoConfigClass == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(11);
        }
        if (module == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(12);
        }
        if (activeProfiles == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(13);
        }
        if (configFilesCache == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(14);
        }
        ProgressManager.checkCanceled();
        ConditionalOnEvaluationContext context = AbstractAutoConfigDependentModelsProvider.createContext(autoConfigClass, module, activeProfiles, configFilesCache, sharedContext);
        AutoConfigClassConditionEvaluator evaluator = new AutoConfigClassConditionEvaluator(autoConfigClass, nonStrictEvaluation, context);
        if (!evaluator.isActive()) {
            ConditionalOnEvaluationContext conditionalOnEvaluationContext = context;
            if (conditionalOnEvaluationContext == null) {
                AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(15);
            }
            return conditionalOnEvaluationContext;
        }
        AutoConfigLocalAnnotationModel autoConfigModel = new AutoConfigLocalAnnotationModel(autoConfigClass, module, activeProfiles, nonStrictEvaluation, sharedContext);
        LocalModelDependency dependency = LocalModelDependency.create((String)("Auto-configuration @" + autoConfigClass.getQualifiedName()), (LocalModelDependencyType)this.getModelDependencyType(), (PsiElement)autoConfigClass.getNavigationElement());
        autoConfigModels.add(Pair.create((Object)((Object)autoConfigModel), (Object)dependency));
        for (PsiClass innerConfig : autoConfigClass.getInnerClasses()) {
            if (!innerConfig.hasModifierProperty("static") || JamService.getJamService((Project)module.getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)innerConfig) == null) continue;
            this.processConfigurationClass(autoConfigModels, innerConfig, nonStrictEvaluation, context, module, activeProfiles, configFilesCache);
        }
        ConditionalOnEvaluationContext conditionalOnEvaluationContext = context;
        if (conditionalOnEvaluationContext == null) {
            AbstractAutoConfigDependentModelsProvider.$$$reportNull$$$0(16);
        }
        return conditionalOnEvaluationContext;
    }

    protected abstract LocalModelDependencyType getModelDependencyType();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localAnnotationModel";
                break;
            }
            case 2: 
            case 4: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/model/autoconfigure/AbstractAutoConfigDependentModelsProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFilesCache";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autoConfigModels";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autoConfigClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/model/autoconfigure/AbstractAutoConfigDependentModelsProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoConfigModels";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findAutoConfigModels";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "processConfigurationClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptModel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAutoConfigModels";
                break;
            }
            case 2: 
            case 4: 
            case 15: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findAutoConfigModels";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isNonStrictEvaluation";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processConfigurationClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 15, 16 -> new IllegalStateException(string);
        };
    }
}

