/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure.conditions.jam;

import com.intellij.jam.JamBaseElement;
import com.intellij.jam.JamClassAttributeElement;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamEnumAttributeElement;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamAnnotationArchetype;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassAttributeMeta;
import com.intellij.jam.reflect.JamEnumAttributeMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnBeanUtils;
import com.intellij.spring.boot.model.jam.StringLiteralPsiClassConverter;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.converters.SpringBeanReferenceJamConverter;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public abstract class ConditionalOnBeanBase
extends JamBaseElement<PsiModifierListOwner> {
    private static final JamClassAttributeMeta.Collection VALUE_ATTRIBUTE = JamAttributeMeta.classCollection((String)"value");
    private static final JamStringAttributeMeta.Collection<PsiClass> TYPE_ATTRIBUTE = JamAttributeMeta.collectionString((String)"type", (JamConverter)new StringLiteralPsiClassConverter());
    private static final JamClassAttributeMeta.Collection ANNOTATION_ATTRIBUTE = JamAttributeMeta.classCollection((String)"annotation");
    private static final JamStringAttributeMeta.Collection<SpringBeanPointer<?>> NAME_ATTRIBUTE = JamAttributeMeta.collectionString((String)"name", (JamConverter)new SpringBeanReferenceJamConverter(new String[0]));
    private static final JamClassAttributeMeta.Collection PARAMETRIZED_CONTAINER_ATTRIBUTE = JamAttributeMeta.classCollection((String)"parameterizedContainer");
    private static final JamEnumAttributeMeta.Single<SearchStrategy> SEARCH_STRATEGY_ATTRIBUTE = JamAttributeMeta.singleEnum((String)"search", SearchStrategy.class);
    protected static final JamAnnotationArchetype ARCHETYPE = new JamAnnotationArchetype().addAttribute((JamAttributeMeta)VALUE_ATTRIBUTE).addAttribute(TYPE_ATTRIBUTE).addAttribute((JamAttributeMeta)ANNOTATION_ATTRIBUTE).addAttribute(NAME_ATTRIBUTE).addAttribute((JamAttributeMeta)PARAMETRIZED_CONTAINER_ATTRIBUTE).addAttribute(SEARCH_STRATEGY_ATTRIBUTE);

    protected ConditionalOnBeanBase(PsiElementRef<?> ref) {
        super(ref);
    }

    protected abstract JamAnnotationMeta getAnnotationMeta();

    public Collection<PsiClass> getValue() {
        List<JamClassAttributeElement> attribute = this.getValueElements();
        return ContainerUtil.map(attribute, JamClassAttributeElement::getValue);
    }

    public Collection<PsiClass> getType() {
        List<JamStringAttributeElement<PsiClass>> attribute = this.getTypeElements();
        return ContainerUtil.map(attribute, JamStringAttributeElement::getValue);
    }

    public Collection<PsiClass> getAnnotation() {
        List<JamClassAttributeElement> attribute = this.getAnnotationElements();
        return ContainerUtil.map(attribute, JamClassAttributeElement::getValue);
    }

    public Collection<String> getName() {
        List attribute = (List)this.getAnnotationMeta().getAttribute((PsiModifierListOwner)this.getPsiElement(), NAME_ATTRIBUTE);
        return ContainerUtil.map((Collection)attribute, JamStringAttributeElement::getStringValue);
    }

    public Collection<PsiClass> getParametrizedContainer() {
        List attribute = (List)this.getAnnotationMeta().getAttribute((PsiModifierListOwner)this.getPsiElement(), (JamAttributeMeta)PARAMETRIZED_CONTAINER_ATTRIBUTE);
        return ContainerUtil.map((Collection)attribute, JamClassAttributeElement::getValue);
    }

    public SearchStrategy getSearch() {
        SearchStrategy searchStrategy = (SearchStrategy)((JamEnumAttributeElement)this.getAnnotationMeta().getAttribute((PsiModifierListOwner)this.getPsiElement(), SEARCH_STRATEGY_ATTRIBUTE)).getValue();
        return searchStrategy != null ? searchStrategy : SearchStrategy.ALL;
    }

    protected List<JamClassAttributeElement> getValueElements() {
        return (List)this.getAnnotationMeta().getAttribute((PsiModifierListOwner)this.getPsiElement(), (JamAttributeMeta)VALUE_ATTRIBUTE);
    }

    protected List<JamStringAttributeElement<PsiClass>> getTypeElements() {
        return (List)this.getAnnotationMeta().getAttribute((PsiModifierListOwner)this.getPsiElement(), TYPE_ATTRIBUTE);
    }

    protected List<JamClassAttributeElement> getAnnotationElements() {
        return (List)this.getAnnotationMeta().getAttribute((PsiModifierListOwner)this.getPsiElement(), (JamAttributeMeta)ANNOTATION_ATTRIBUTE);
    }

    protected Collection<PsiClass> getValidParametrizedContainers() {
        return ContainerUtil.filter(this.getParametrizedContainer(), container -> container != null && container.getTypeParameters().length == 1);
    }

    protected void matchBeansByType(CommonSpringModel springModel, Collection<PsiType> types, Collection<PsiClass> containers, List<? extends CommonSpringBean> ignoredBeans, Processor<? super Boolean> matchingProcessor) {
        for (PsiType psiType : types) {
            if (psiType != null) {
                List beansByType = ContainerUtil.map(ConditionalOnBeanUtils.findBeansByType(springModel, psiType), (com.intellij.util.Function)SpringBeanPointer.TO_BEAN);
                if (!ignoredBeans.containsAll(beansByType)) {
                    if (matchingProcessor.process((Object)Boolean.TRUE)) continue;
                    return;
                }
                boolean matched = false;
                for (PsiClass container : containers) {
                    PsiClassType containerType = ConditionalOnBeanUtils.getContainerType(container, psiType);
                    beansByType = ContainerUtil.map(ConditionalOnBeanUtils.findBeansByType(springModel, (PsiType)containerType), (com.intellij.util.Function)SpringBeanPointer.TO_BEAN);
                    if (ignoredBeans.containsAll(beansByType)) continue;
                    if (!matchingProcessor.process((Object)Boolean.TRUE)) {
                        return;
                    }
                    matched = true;
                    break;
                }
                if (matched) continue;
            }
            if (matchingProcessor.process((Object)Boolean.FALSE)) continue;
            return;
        }
    }

    protected Collection<PsiType> getTypesToMatch() {
        Collection<PsiClass> valueClasses = this.getValue();
        Collection<PsiClass> typeClasses = this.getType();
        if (valueClasses.isEmpty() && typeClasses.isEmpty() && this.getName().isEmpty()) {
            PsiModifierListOwner element = (PsiModifierListOwner)this.getPsiElement();
            PsiType beanType = element instanceof PsiMethod ? ConditionalOnBeanUtils.getBeanType((PsiMethod)element) : null;
            return beanType == null ? Collections.emptyList() : new SmartList((Object)beanType);
        }
        return ContainerUtil.map((Iterable)ContainerUtil.concat(this.getValue(), this.getType()), psiClass -> psiClass == null ? null : PsiTypesUtil.getClassType((PsiClass)psiClass));
    }

    protected void matchBeansByAnnotation(CommonSpringModel springModel, List<? extends CommonSpringBean> ignoredBeans, Processor<? super Boolean> matchingProcessor) {
        Collection<PsiClass> annotations = this.getAnnotation();
        if (annotations.isEmpty()) {
            return;
        }
        Module module = springModel.getModule();
        if (module == null) {
            matchingProcessor.process((Object)false);
            return;
        }
        GlobalSearchScope scope = SpringGlobalSearchScopes.moduleWithDependencies((Module)module);
        JamService jamService = JamService.getJamService((Project)module.getProject());
        for (PsiClass annotationClass : annotations) {
            if (annotationClass != null && annotationClass.isAnnotationType()) {
                Query psiMethods = AnnotatedElementsSearch.searchPsiMethods((PsiClass)annotationClass, (SearchScope)scope);
                boolean matched = ConditionalOnBeanBase.matchAnnotatedBean(springModel, ignoredBeans, (Query<? extends PsiElement>)psiMethods, psiElement -> {
                    PsiMethod psiMethod = (PsiMethod)psiElement;
                    if (psiMethod.isConstructor() || psiMethod.hasModifier(JvmModifier.STATIC) || psiMethod.hasModifier(JvmModifier.PRIVATE)) {
                        return null;
                    }
                    return (CommonSpringBean)jamService.getJamElement(ContextJavaBean.BEAN_JAM_KEY, psiElement);
                });
                if (matched) {
                    if (matchingProcessor.process((Object)Boolean.TRUE)) continue;
                    return;
                }
                Query psiClasses = AnnotatedElementsSearch.searchPsiClasses((PsiClass)annotationClass, (SearchScope)scope);
                matched = ConditionalOnBeanBase.matchAnnotatedBean(springModel, ignoredBeans, (Query<? extends PsiElement>)psiClasses, psiElement -> {
                    if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)((PsiClass)psiElement))) {
                        return null;
                    }
                    return (CommonSpringBean)jamService.getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, psiElement);
                });
                if (matched) {
                    if (matchingProcessor.process((Object)Boolean.TRUE)) continue;
                    return;
                }
            }
            if (matchingProcessor.process((Object)Boolean.FALSE)) continue;
            return;
        }
    }

    private static boolean matchAnnotatedBean(CommonSpringModel springModel, List<? extends CommonSpringBean> ignoredBeans, Query<? extends PsiElement> query, Function<PsiElement, CommonSpringBean> mapper) {
        return query.anyMatch(psiElement -> {
            CommonSpringBean bean = (CommonSpringBean)mapper.apply((PsiElement)psiElement);
            if (bean == null || ignoredBeans.contains(bean)) {
                return false;
            }
            PsiType psiType = bean.getBeanType();
            if (psiType == null) {
                return false;
            }
            List pointers = SpringModelSearchers.findBeans((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byType((PsiType)psiType));
            for (SpringBeanPointer pointer : pointers) {
                if (!pointer.isValid() || !bean.equals((Object)pointer.getSpringBean())) continue;
                return true;
            }
            return false;
        });
    }

    protected void matchBeansByName(CommonSpringModel springModel, List<CommonSpringBean> ignoredBeans, Processor<? super Boolean> matchingProcessor) {
        Collection<String> names = this.getName();
        if (names.isEmpty()) {
            return;
        }
        List ignoredNames = ContainerUtil.mapNotNull(ignoredBeans, CommonSpringBean::getBeanName);
        for (String name : names) {
            boolean matched = name != null && !ignoredNames.contains(name) && !SpringModelSearchers.findBeans((CommonSpringModel)springModel, (String)name).isEmpty();
            if (matchingProcessor.process((Object)matched)) continue;
            return;
        }
    }

    @ApiStatus.Internal
    public static enum SearchStrategy {
        CURRENT,
        ANCESTORS,
        ALL;

    }
}

