/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressionAnnotationInspection;
import com.intellij.codeInspection.SuppressionAnnotationInspectionKt;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UComment;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r*\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/codeInspection/AllowSuppressionsFix;", "Lcom/intellij/modcommand/ModCommandQuickFix;", "inspection", "Lcom/intellij/codeInspection/SuppressionAnnotationInspection;", "<init>", "(Lcom/intellij/codeInspection/SuppressionAnnotationInspection;)V", "perform", "Lcom/intellij/modcommand/ModCommand;", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "suppressIdsFromAnchor", "", "", "Lcom/intellij/psi/PsiElement;", "getName", "getFamilyName", "intellij.jvm.analysis.impl"})
final class AllowSuppressionsFix
extends ModCommandQuickFix {
    @NotNull
    private final SuppressionAnnotationInspection inspection;

    public AllowSuppressionsFix(@NotNull SuppressionAnnotationInspection inspection) {
        Intrinsics.checkNotNullParameter((Object)((Object)inspection), (String)"inspection");
        this.inspection = inspection;
    }

    @NotNull
    public ModCommand perform(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement anchor = descriptor.getPsiElement();
        Intrinsics.checkNotNull((Object)anchor);
        List<String> list = this.suppressIdsFromAnchor(anchor);
        if (list == null) {
            ModCommand modCommand = ModCommand.nop();
            Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"nop(...)");
            return modCommand;
        }
        List<String> suppressIds = list;
        if (suppressIds.isEmpty()) {
            ModCommand modCommand = ModCommand.nop();
            Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"nop(...)");
            return modCommand;
        }
        ModCommand modCommand = ModCommand.updateInspectionOption((PsiElement)anchor, (InspectionProfileEntry)((InspectionProfileEntry)this.inspection), arg_0 -> AllowSuppressionsFix.perform$lambda$0(suppressIds, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"updateInspectionOption(...)");
        return modCommand;
    }

    private final List<String> suppressIdsFromAnchor(PsiElement $this$suppressIdsFromAnchor) {
        Class[] classArray = new Class[]{UComment.class, UAnnotation.class};
        UElement suppressIdContainer = UastContextKt.getUastParentOfTypes((PsiElement)$this$suppressIdsFromAnchor, (Class[])classArray, (boolean)false);
        return suppressIdContainer instanceof UComment ? SuppressionAnnotationInspectionKt.access$suppressIds((UComment)suppressIdContainer) : (suppressIdContainer instanceof UAnnotation ? SuppressionAnnotationInspectionKt.access$suppressIds((UAnnotation)suppressIdContainer) : CollectionsKt.emptyList());
    }

    @NotNull
    public String getName() {
        String string = JvmAnalysisBundle.message("allow.suppressions.fix.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JvmAnalysisBundle.message("allow.suppressions.fix.family.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private static final void perform$lambda$0(List $suppressIds, SuppressionAnnotationInspection inspection) {
        Intrinsics.checkNotNullParameter((Object)((Object)inspection), (String)"inspection");
        for (String suppressId : $suppressIds) {
            if (inspection.getMyAllowedSuppressions().contains(suppressId)) continue;
            inspection.getMyAllowedSuppressions().add(suppressId);
        }
    }
}

