/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compose.ide.plugin.resources;

import com.intellij.compose.ide.plugin.resources.ComposeResources;
import com.intellij.compose.ide.plugin.resources.ComposeResourcesDir;
import com.intellij.compose.ide.plugin.resources.ComposeResourcesItemKt;
import com.intellij.compose.ide.plugin.resources.ComposeResourcesManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001a\u0010\n\u001a\u00020\b*\u00020\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006H\u0000\u001a\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0001*\u00020\u0010H\u0000\u001a\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0001H\u0000\u001a\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0012*\u00020\u0010H\u0000\u001a\u0012\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\u00020\u0018H\u0000\u001a\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u0017*\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0007\u001a\u00020\b*\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\"\u0018\u0010\f\u001a\u00020\u0001*\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"$\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00170\u001d*\u00020\u00108@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\"\u001b\u0010 \u001a\u00020!8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b\"\u0010#\u00a8\u0006&"}, d2={"COMPOSE_RESOURCES_DIR", "", "STRINGS_XML_FILENAME", "VALUES_DIRNAME", "ANDROID_RESOURCE_REFERENCE", "VALID_INNER_COMPOSE_RESOURCES_DIR_NAMES", "", "isValidInnerComposeResourcesDirName", "", "(Ljava/lang/String;)Z", "isValidInnerComposeResourcesDirNameFor", "dirNames", "withoutExtension", "getWithoutExtension", "(Ljava/lang/String;)Ljava/lang/String;", "getModuleNameForComposeResourcesTask", "Lcom/intellij/openapi/module/Module;", "getComposeResourcesDirFor", "Lcom/intellij/openapi/vfs/VirtualFile;", "sourceSetName", "getComposeResourcesDir", "getAllComposeResourcesDirs", "", "Lcom/intellij/compose/ide/plugin/resources/ComposeResourcesDir;", "Lcom/intellij/openapi/project/Project;", "findComposeResourcesDirFor", "path", "Ljava/nio/file/Path;", "composeResourcesDirsByName", "", "getComposeResourcesDirsByName", "(Lcom/intellij/openapi/module/Module;)Ljava/util/Map;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/Lazy;", "intellij.compose.ide.plugin.resources"})
@SourceDebugExtension(value={"SMAP\nComposeResourcesUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeResourcesUtils.kt\ncom/intellij/compose/ide/plugin/resources/ComposeResourcesUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,83:1\n1807#2,3:84\n1807#2,3:87\n1#3:90\n30#4,2:91\n30#4,2:99\n30#4,2:101\n78#5:93\n99#5,5:94\n57#6:103\n35#6,2:104\n*S KotlinDebug\n*F\n+ 1 ComposeResourcesUtils.kt\ncom/intellij/compose/ide/plugin/resources/ComposeResourcesUtilsKt\n*L\n23#1:84,3\n26#1:87,3\n61#1:91,2\n64#1:99,2\n70#1:101,2\n61#1:93\n61#1:94,5\n82#1:103\n82#1:104,2\n*E\n"})
public final class ComposeResourcesUtilsKt {
    @NotNull
    public static final String COMPOSE_RESOURCES_DIR = "composeResources";
    @NotNull
    public static final String STRINGS_XML_FILENAME = "strings.xml";
    @NotNull
    public static final String VALUES_DIRNAME = "values";
    @NotNull
    public static final String ANDROID_RESOURCE_REFERENCE = "org.jetbrains.android.dom.converters.AndroidResourceReference";
    @NotNull
    private static final Set<String> VALID_INNER_COMPOSE_RESOURCES_DIR_NAMES;
    @NotNull
    private static final Lazy log$delegate;

    public static final boolean isValidInnerComposeResourcesDirName(@NotNull String $this$isValidInnerComposeResourcesDirName) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isValidInnerComposeResourcesDirName, (String)"<this>");
            Iterable $this$any$iv = VALID_INNER_COMPOSE_RESOURCES_DIR_NAMES;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith((String)$this$isValidInnerComposeResourcesDirName, (String)it, (boolean)true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isValidInnerComposeResourcesDirNameFor(@NotNull String $this$isValidInnerComposeResourcesDirNameFor, @NotNull Set<String> dirNames) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isValidInnerComposeResourcesDirNameFor, (String)"<this>");
            Intrinsics.checkNotNullParameter(dirNames, (String)"dirNames");
            Iterable $this$any$iv = CollectionsKt.intersect((Iterable)dirNames, (Iterable)VALID_INNER_COMPOSE_RESOURCES_DIR_NAMES);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith((String)$this$isValidInnerComposeResourcesDirNameFor, (String)it, (boolean)true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final String getWithoutExtension(@NotNull String $this$withoutExtension) {
        Intrinsics.checkNotNullParameter((Object)$this$withoutExtension, (String)"<this>");
        return StringsKt.substringBeforeLast$default((String)$this$withoutExtension, (String)".", null, (int)2, null);
    }

    @Nullable
    public static final String getModuleNameForComposeResourcesTask(@NotNull Module $this$getModuleNameForComposeResourcesTask) {
        Intrinsics.checkNotNullParameter((Object)$this$getModuleNameForComposeResourcesTask, (String)"<this>");
        String string = ExternalSystemApiUtil.getExternalProjectId((Module)$this$getModuleNameForComposeResourcesTask);
        return string != null ? ComposeResourcesItemKt.getModuleName(string) : null;
    }

    @Nullable
    public static final VirtualFile getComposeResourcesDirFor(@NotNull Module $this$getComposeResourcesDirFor, @NotNull String sourceSetName) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)$this$getComposeResourcesDirFor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sourceSetName, (String)"sourceSetName");
        ComposeResourcesDir composeResourcesDir = ComposeResourcesUtilsKt.getComposeResourcesDirsByName($this$getComposeResourcesDirFor).get(sourceSetName);
        if (composeResourcesDir != null) {
            ComposeResourcesDir it = composeResourcesDir;
            boolean bl = false;
            virtualFile = VirtualFileManager.getInstance().findFileByNioPath(it.getDirectoryPath());
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    @Nullable
    public static final VirtualFile getComposeResourcesDir(@NotNull Module $this$getComposeResourcesDir) {
        Intrinsics.checkNotNullParameter((Object)$this$getComposeResourcesDir, (String)"<this>");
        String sourceSetName = ComposeResourcesItemKt.getSourceSetNameFromComposeResourcesDir($this$getComposeResourcesDir);
        VirtualFile virtualFile = ComposeResourcesUtilsKt.getComposeResourcesDirFor($this$getComposeResourcesDir, sourceSetName);
        if (virtualFile == null && (virtualFile = ComposeResourcesUtilsKt.getComposeResourcesDirFor($this$getComposeResourcesDir, "commonMain")) == null) {
            Module $this$getComposeResourcesDir_u24lambda_u240 = $this$getComposeResourcesDir;
            boolean bl = false;
            ComposeResourcesUtilsKt.getLog().warn("No Compose resources directory found for module " + $this$getComposeResourcesDir_u24lambda_u240.getName() + " and source set " + sourceSetName + ".");
            virtualFile = null;
        }
        return virtualFile;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ComposeResourcesDir> getAllComposeResourcesDirs(@NotNull Project $this$getAllComposeResourcesDirs) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getAllComposeResourcesDirs, (String)"<this>");
        ComponentManager $this$service$iv = (ComponentManager)$this$getAllComposeResourcesDirs;
        boolean $i$f$service = false;
        Object serviceClass$iv = ComposeResourcesManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Map<String, ComposeResources> $this$flatMap$iv = ((ComposeResourcesManager)object).getComposeResourcesByModulePath();
        boolean $i$f$flatMap = false;
        serviceClass$iv = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            Iterable list$iv$iv = ((ComposeResources)it.getValue()).getDirectoriesBySourceSetName().values();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final ComposeResourcesDir findComposeResourcesDirFor(@NotNull Project $this$findComposeResourcesDirFor, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$findComposeResourcesDirFor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ComponentManager $this$service$iv = (ComponentManager)$this$findComposeResourcesDirFor;
        boolean $i$f$service = false;
        Class<ComposeResourcesManager> serviceClass$iv = ComposeResourcesManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((ComposeResourcesManager)object).findComposeResourcesDirFor(path);
    }

    @NotNull
    public static final Map<String, ComposeResourcesDir> getComposeResourcesDirsByName(@NotNull Module $this$composeResourcesDirsByName) {
        Object object;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)$this$composeResourcesDirsByName, (String)"<this>");
                object = ComposeResourcesUtilsKt.getModuleNameForComposeResourcesTask($this$composeResourcesDirsByName);
                if (object == null) break block5;
                String moduleName = object;
                boolean bl = false;
                Project project = $this$composeResourcesDirsByName.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<ComposeResourcesManager> serviceClass$iv = ComposeResourcesManager.class;
                Object object2 = $this$service$iv.getService(serviceClass$iv);
                if (object2 == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                ComposeResources composeResources = ((ComposeResourcesManager)object2).getComposeResourcesByModulePath().get(moduleName);
                Map map = composeResources != null ? composeResources.getDirectoriesBySourceSetName() : null;
                if (map == null) {
                    map = MapsKt.emptyMap();
                }
                object = map;
                if (map != null) break block6;
            }
            object = MapsKt.emptyMap();
        }
        return object;
    }

    private static final Logger getLog() {
        Lazy lazy = log$delegate;
        return (Logger)lazy.getValue();
    }

    private static final Logger log_delegate$lambda$0() {
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    static {
        Object[] objectArray = new String[]{"drawable", "font", VALUES_DIRNAME};
        VALID_INNER_COMPOSE_RESOURCES_DIR_NAMES = SetsKt.setOf((Object[])objectArray);
        log$delegate = LazyKt.lazy(ComposeResourcesUtilsKt::log_delegate$lambda$0);
    }
}

