/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.initScript.listener;

import com.intellij.gradle.toolingExtension.impl.initScript.listener.RunAppTaskActionListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.JavaExec;

public class ArgFileTaskActionListener
extends RunAppTaskActionListener {
    public ArgFileTaskActionListener(String taskName) {
        super(taskName);
    }

    @Override
    public File patchTaskClasspath(JavaExec task) throws IOException {
        File file = File.createTempFile("generated-", "-argFile");
        try (OutputStream os = Files.newOutputStream(file.toPath(), new OpenOption[0]);
             OutputStreamWriter osw = new OutputStreamWriter(os, StandardCharsets.UTF_8);
             PrintWriter writer = new PrintWriter(osw);){
            String lineSep = System.getProperty("line.separator");
            writer.print("-classpath" + lineSep);
            writer.print(ArgFileTaskActionListener.quoteArg(task.getClasspath().getAsPath()));
            writer.print(lineSep);
        }
        task.jvmArgs(new Object[]{"@" + file.getAbsolutePath()});
        task.setClasspath((FileCollection)task.getProject().files(new Object[]{new ArrayList()}));
        return file;
    }

    private static String quoteArg(String arg) {
        String specials = " #'\"\n\r\t\f";
        boolean hasSpecialCharacters = specials.chars().anyMatch(characterCode -> arg.indexOf(characterCode) != -1);
        if (!hasSpecialCharacters) {
            return arg;
        }
        StringBuilder sb = new StringBuilder(arg.length() * 2);
        for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            if (c == ' ' || c == '#' || c == '\'') {
                sb.append('\"').append(c).append('\"');
                continue;
            }
            if (c == '\"') {
                sb.append("\"\\\"\"");
                continue;
            }
            if (c == '\n') {
                sb.append("\"\\n\"");
                continue;
            }
            if (c == '\r') {
                sb.append("\"\\r\"");
                continue;
            }
            if (c == '\t') {
                sb.append("\"\\t\"");
                continue;
            }
            if (c == '\f') {
                sb.append("\"\\f\"");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

