/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.telemetry;

import com.intellij.platform.diagnostic.telemetry.rt.context.TelemetryContext;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapPropagator;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class GradleOpenTelemetry {
    @NotNull
    private static final String INSTRUMENTATION_NAME = "GradleDaemon";
    @NotNull
    private final Tracer myTracer;
    @NotNull
    private final Scope myScope;

    public GradleOpenTelemetry() {
        OpenTelemetry telemetry = GlobalOpenTelemetry.get();
        this.myTracer = telemetry.getTracer(INSTRUMENTATION_NAME);
        this.myScope = GradleOpenTelemetry.extractScope(telemetry);
    }

    public static <T> T callWithSpan(@NotNull String spanName, @NotNull Function<Span, T> fn) {
        if (spanName == null) {
            GradleOpenTelemetry.$$$reportNull$$$0(0);
        }
        if (fn == null) {
            GradleOpenTelemetry.$$$reportNull$$$0(1);
        }
        return (T)GradleOpenTelemetry.withOpenTelemetry(telemetry -> telemetry.callWithSpan(spanName, ignore -> {}, fn));
    }

    public static void runWithSpan(@NotNull String spanName, @NotNull Consumer<Span> consumer) {
        if (spanName == null) {
            GradleOpenTelemetry.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            GradleOpenTelemetry.$$$reportNull$$$0(3);
        }
        GradleOpenTelemetry.callWithSpan(spanName, span -> {
            consumer.accept((Span)span);
            return null;
        });
    }

    public void shutdown() {
        this.myScope.close();
    }

    private <T> T callWithSpan(@NotNull String spanName, @NotNull Consumer<SpanBuilder> configurator, @NotNull Function<Span, T> fn) {
        if (spanName == null) {
            GradleOpenTelemetry.$$$reportNull$$$0(4);
        }
        if (configurator == null) {
            GradleOpenTelemetry.$$$reportNull$$$0(5);
        }
        if (fn == null) {
            GradleOpenTelemetry.$$$reportNull$$$0(6);
        }
        SpanBuilder spanBuilder = this.myTracer.spanBuilder(spanName);
        configurator.accept(spanBuilder);
        Span span = spanBuilder.startSpan();
        try {
            T t;
            block14: {
                Scope ignore = span.makeCurrent();
                try {
                    t = fn.apply(span);
                    if (ignore == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignore != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        span.recordException((Throwable)e);
                        span.setStatus(StatusCode.ERROR);
                        throw e;
                    }
                }
                ignore.close();
            }
            return t;
        }
        finally {
            span.end();
        }
    }

    @NotNull
    private static Scope extractScope(@NotNull OpenTelemetry telemetry) {
        if (telemetry == null) {
            GradleOpenTelemetry.$$$reportNull$$$0(7);
        }
        TextMapPropagator propagator = telemetry.getPropagators().getTextMapPropagator();
        Scope scope = TelemetryContext.fromJvmProperties().extract(propagator).makeCurrent();
        if (scope == null) {
            GradleOpenTelemetry.$$$reportNull$$$0(8);
        }
        return scope;
    }

    private static <T> T withOpenTelemetry(@NotNull Function<GradleOpenTelemetry, T> action) {
        if (action == null) {
            GradleOpenTelemetry.$$$reportNull$$$0(9);
        }
        GradleOpenTelemetry telemetry = new GradleOpenTelemetry();
        try {
            return action.apply(telemetry);
        }
        catch (Throwable exception) {
            telemetry.shutdown();
            throw exception;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spanName";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fn";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "telemetry";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/telemetry/GradleOpenTelemetry";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/telemetry/GradleOpenTelemetry";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "extractScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "callWithSpan";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runWithSpan";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extractScope";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "withOpenTelemetry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

