/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.events.listeners.inline.completion;

import com.intellij.code.provenance.DocumentChangesKind;
import com.intellij.code.provenance.core.ProvenanceRegistry;
import com.intellij.code.provenance.core.events.listeners.ProvenanceListenersKt;
import com.intellij.codeInsight.inline.completion.InlineCompletion;
import com.intellij.codeInsight.inline.completion.InlineCompletionEventAdapter;
import com.intellij.codeInsight.inline.completion.InlineCompletionEventListener;
import com.intellij.codeInsight.inline.completion.InlineCompletionEventType;
import com.intellij.codeInsight.inline.completion.InlineCompletionHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/code/provenance/core/events/listeners/inline/completion/InlineCompletionListener;", "", "<init>", "()V", "register", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "disposable", "Lcom/intellij/openapi/Disposable;", "intellij.code.provenance.core"})
public final class InlineCompletionListener {
    @NotNull
    public static final InlineCompletionListener INSTANCE = new InlineCompletionListener();

    private InlineCompletionListener() {
    }

    public final void register(@NotNull Editor editor, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        InlineCompletionHandler inlineCompletionHandler = InlineCompletion.INSTANCE.getHandlerOrNull(editor);
        if (inlineCompletionHandler == null) {
            return;
        }
        InlineCompletionHandler handler = inlineCompletionHandler;
        handler.addEventListener((InlineCompletionEventListener)new InlineCompletionEventAdapter(editor){
            final /* synthetic */ Editor $editor;
            {
                this.$editor = $editor;
            }

            public void onInsert(InlineCompletionEventType.Insert event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (ProvenanceRegistry.INSTANCE.isProvenanceEnabled()) {
                    this.$editor.putUserData(ProvenanceListenersKt.getEDITOR_CHANGE_KIND_KEY(), (Object)DocumentChangesKind.AI_INLINE_COMPLETION);
                }
                super.onInsert(event);
            }

            public void onAfterInsert(InlineCompletionEventType.AfterInsert event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                super.onAfterInsert(event);
                RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)this.$editor), ProvenanceListenersKt.getEDITOR_CHANGE_KIND_KEY());
            }
        }, disposable);
    }
}

