/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.events.storage.dto;

import com.intellij.code.provenance.DocumentChangesKind;
import com.intellij.code.provenance.core.ProvenanceEntry;
import com.intellij.code.provenance.core.events.storage.ProvenanceEventExtensionsKt;
import com.intellij.code.provenance.core.events.storage.dto.ProvenanceEntryDTOKt;
import java.nio.ByteBuffer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 72\u00020\u0001:\u00017BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\f\u0010\rJ)\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00050$\u00a2\u0006\u0004\b%\u0010&J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0005H\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0005H\u00c6\u0003J\t\u0010+\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010,\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0010\u0010-\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010.\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0017Jd\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u00100J\u0014\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u00104\u001a\u000205H\u00d6\u0081\u0004J\n\u00106\u001a\u00020\u0005H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0015\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u0015\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0019\u0010\u0017R\u001b\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00068"}, d2={"Lcom/intellij/code/provenance/core/events/storage/dto/ProvenanceEntryDTO;", "", "timestamp", "", "type", "", "fileId", "payloadBase64", "extra", "kind", "oldContentHash", "newContentHash", "<init>", "(JLjava/lang/String;JLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Long;)V", "getTimestamp", "()J", "getType", "()Ljava/lang/String;", "getFileId", "getPayloadBase64", "getExtra", "getKind", "getOldContentHash", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getNewContentHash", "parsedKind", "Lcom/intellij/code/provenance/DocumentChangesKind;", "getParsedKind", "()Lcom/intellij/code/provenance/DocumentChangesKind;", "parsedKind$delegate", "Lkotlin/Lazy;", "toProvenanceEntry", "Lkotlin/Result;", "Lcom/intellij/code/provenance/core/ProvenanceEntry$OrdinaryEvent;", "pathResolver", "Lkotlin/Function1;", "toProvenanceEntry-IoAF18A", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "(JLjava/lang/String;JLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Long;)Lcom/intellij/code/provenance/core/events/storage/dto/ProvenanceEntryDTO;", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.code.provenance.core"})
@SourceDebugExtension(value={"SMAP\nProvenanceEntryDTO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProvenanceEntryDTO.kt\ncom/intellij/code/provenance/core/events/storage/dto/ProvenanceEntryDTO\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n1#2:173\n*E\n"})
public final class ProvenanceEntryDTO {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long timestamp;
    @NotNull
    private final String type;
    private final long fileId;
    @NotNull
    private final String payloadBase64;
    @NotNull
    private final String extra;
    @Nullable
    private final String kind;
    @Nullable
    private final Long oldContentHash;
    @Nullable
    private final Long newContentHash;
    @NotNull
    private final Lazy parsedKind$delegate;
    @NotNull
    private static final Base64.Default base64 = Base64.Default;

    public ProvenanceEntryDTO(long timestamp, @NotNull String type, long fileId, @NotNull String payloadBase64, @NotNull String extra, @Nullable String kind, @Nullable Long oldContentHash, @Nullable Long newContentHash) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)payloadBase64, (String)"payloadBase64");
        Intrinsics.checkNotNullParameter((Object)extra, (String)"extra");
        this.timestamp = timestamp;
        this.type = type;
        this.fileId = fileId;
        this.payloadBase64 = payloadBase64;
        this.extra = extra;
        this.kind = kind;
        this.oldContentHash = oldContentHash;
        this.newContentHash = newContentHash;
        this.parsedKind$delegate = LazyKt.lazy(() -> ProvenanceEntryDTO.parsedKind_delegate$lambda$0(this));
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    public final long getFileId() {
        return this.fileId;
    }

    @NotNull
    public final String getPayloadBase64() {
        return this.payloadBase64;
    }

    @NotNull
    public final String getExtra() {
        return this.extra;
    }

    @Nullable
    public final String getKind() {
        return this.kind;
    }

    @Nullable
    public final Long getOldContentHash() {
        return this.oldContentHash;
    }

    @Nullable
    public final Long getNewContentHash() {
        return this.newContentHash;
    }

    private final DocumentChangesKind getParsedKind() {
        Lazy lazy = this.parsedKind$delegate;
        return (DocumentChangesKind)lazy.getValue();
    }

    @NotNull
    public final Object toProvenanceEntry-IoAF18A(@NotNull Function1<? super Long, String> pathResolver) {
        ProvenanceEntry.OrdinaryEvent ordinaryEvent;
        byte[] byArray;
        String string;
        Intrinsics.checkNotNullParameter(pathResolver, (String)"pathResolver");
        if (this.fileId == -1L) {
            string = "";
        } else {
            string = (String)pathResolver.invoke((Object)this.fileId);
            if (string == null) {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Failed to decode find file with hash: " + this.fileId)));
            }
        }
        String captionDecoded = string;
        try {
            byArray = Base64.decode$default((Base64)((Base64)base64), (CharSequence)this.payloadBase64, (int)0, (int)0, (int)6, null);
        }
        catch (Throwable e) {
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Failed to decode base64 payload: " + this.payloadBase64 + ", error: " + e.getMessage())));
        }
        byte[] payloadDecoded = byArray;
        String string2 = this.type;
        if (Intrinsics.areEqual((Object)string2, (Object)ProvenanceEntry.Idle.class.getSimpleName())) {
            ordinaryEvent = new ProvenanceEntry.Idle(this.timestamp);
        } else if (Intrinsics.areEqual((Object)string2, (Object)ProvenanceEntry.DocumentChange.class.getSimpleName())) {
            Long l = StringsKt.toLongOrNull((String)this.extra);
            if (l == null) {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Invalid duration for DocumentChange: " + this.extra)));
            }
            long duration = l;
            ordinaryEvent = new ProvenanceEntry.DocumentChange(captionDecoded, ProvenanceEntryDTOKt.deserialize(payloadDecoded), duration, this.timestamp, this.getParsedKind(), this.oldContentHash, this.newContentHash);
        } else if (Intrinsics.areEqual((Object)string2, (Object)ProvenanceEntry.ExternalDocumentChange.class.getSimpleName())) {
            Integer n = StringsKt.toIntOrNull((String)new String(payloadDecoded, Charsets.UTF_8));
            int duration = n != null ? n : 0;
            long l = this.timestamp;
            DocumentChangesKind documentChangesKind = this.getParsedKind();
            Long l2 = this.oldContentHash;
            Long l3 = this.newContentHash;
            ordinaryEvent = new ProvenanceEntry.ExternalDocumentChange(captionDecoded, duration, l, l2, l3, documentChangesKind);
        } else if (Intrinsics.areEqual((Object)string2, (Object)ProvenanceEntry.ContentChangeByLocalHistory.class.getSimpleName())) {
            Integer n = StringsKt.toIntOrNull((String)this.extra);
            if (n == null) {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Invalid contentId for ContentChangeByLocalHistory: " + this.extra)));
            }
            int contentId = n;
            ordinaryEvent = new ProvenanceEntry.ContentChangeByLocalHistory(captionDecoded, new String(payloadDecoded, Charsets.UTF_8), contentId, this.timestamp, this.oldContentHash);
        } else if (Intrinsics.areEqual((Object)string2, (Object)ProvenanceEntry.DocumentRename.class.getSimpleName())) {
            String string3;
            long oldFileId = ByteBuffer.wrap(payloadDecoded).getLong();
            if (oldFileId == -1L) {
                string3 = "";
            } else {
                string3 = (String)pathResolver.invoke((Object)oldFileId);
                if (string3 == null) {
                    return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Failed to decode find file with hash: " + oldFileId)));
                }
            }
            String oldPath = string3;
            ordinaryEvent = new ProvenanceEntry.DocumentRename(oldPath, captionDecoded, this.timestamp);
        } else {
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Unknown event type: " + this.type)));
        }
        ProvenanceEntry.OrdinaryEvent event = ordinaryEvent;
        return Result.constructor-impl((Object)event);
    }

    public final long component1() {
        return this.timestamp;
    }

    @NotNull
    public final String component2() {
        return this.type;
    }

    public final long component3() {
        return this.fileId;
    }

    @NotNull
    public final String component4() {
        return this.payloadBase64;
    }

    @NotNull
    public final String component5() {
        return this.extra;
    }

    @Nullable
    public final String component6() {
        return this.kind;
    }

    @Nullable
    public final Long component7() {
        return this.oldContentHash;
    }

    @Nullable
    public final Long component8() {
        return this.newContentHash;
    }

    @NotNull
    public final ProvenanceEntryDTO copy(long timestamp, @NotNull String type, long fileId, @NotNull String payloadBase64, @NotNull String extra, @Nullable String kind, @Nullable Long oldContentHash, @Nullable Long newContentHash) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)payloadBase64, (String)"payloadBase64");
        Intrinsics.checkNotNullParameter((Object)extra, (String)"extra");
        return new ProvenanceEntryDTO(timestamp, type, fileId, payloadBase64, extra, kind, oldContentHash, newContentHash);
    }

    public static /* synthetic */ ProvenanceEntryDTO copy$default(ProvenanceEntryDTO provenanceEntryDTO, long l, String string, long l2, String string2, String string3, String string4, Long l3, Long l4, int n, Object object) {
        if ((n & 1) != 0) {
            l = provenanceEntryDTO.timestamp;
        }
        if ((n & 2) != 0) {
            string = provenanceEntryDTO.type;
        }
        if ((n & 4) != 0) {
            l2 = provenanceEntryDTO.fileId;
        }
        if ((n & 8) != 0) {
            string2 = provenanceEntryDTO.payloadBase64;
        }
        if ((n & 0x10) != 0) {
            string3 = provenanceEntryDTO.extra;
        }
        if ((n & 0x20) != 0) {
            string4 = provenanceEntryDTO.kind;
        }
        if ((n & 0x40) != 0) {
            l3 = provenanceEntryDTO.oldContentHash;
        }
        if ((n & 0x80) != 0) {
            l4 = provenanceEntryDTO.newContentHash;
        }
        return provenanceEntryDTO.copy(l, string, l2, string2, string3, string4, l3, l4);
    }

    @NotNull
    public String toString() {
        return "ProvenanceEntryDTO(timestamp=" + this.timestamp + ", type=" + this.type + ", fileId=" + this.fileId + ", payloadBase64=" + this.payloadBase64 + ", extra=" + this.extra + ", kind=" + this.kind + ", oldContentHash=" + this.oldContentHash + ", newContentHash=" + this.newContentHash + ")";
    }

    public int hashCode() {
        int result = Long.hashCode(this.timestamp);
        result = result * 31 + this.type.hashCode();
        result = result * 31 + Long.hashCode(this.fileId);
        result = result * 31 + this.payloadBase64.hashCode();
        result = result * 31 + this.extra.hashCode();
        result = result * 31 + (this.kind == null ? 0 : this.kind.hashCode());
        result = result * 31 + (this.oldContentHash == null ? 0 : ((Object)this.oldContentHash).hashCode());
        result = result * 31 + (this.newContentHash == null ? 0 : ((Object)this.newContentHash).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProvenanceEntryDTO)) {
            return false;
        }
        ProvenanceEntryDTO provenanceEntryDTO = (ProvenanceEntryDTO)other;
        if (this.timestamp != provenanceEntryDTO.timestamp) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.type, (Object)provenanceEntryDTO.type)) {
            return false;
        }
        if (this.fileId != provenanceEntryDTO.fileId) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.payloadBase64, (Object)provenanceEntryDTO.payloadBase64)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.extra, (Object)provenanceEntryDTO.extra)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.kind, (Object)provenanceEntryDTO.kind)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.oldContentHash, (Object)provenanceEntryDTO.oldContentHash)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.newContentHash, (Object)provenanceEntryDTO.newContentHash);
    }

    private static final DocumentChangesKind parsedKind_delegate$lambda$0(ProvenanceEntryDTO this$0) {
        String string;
        block3: {
            block2: {
                string = this$0.kind;
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                DocumentChangesKind documentChangesKind = DocumentChangesKind.Companion.fromString(it);
                string = documentChangesKind;
                if (documentChangesKind != null) break block3;
            }
            string = DocumentChangesKind.UNKNOWN;
        }
        return string;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/code/provenance/core/events/storage/dto/ProvenanceEntryDTO$Companion;", "", "<init>", "()V", "base64", "Lkotlin/io/encoding/Base64$Default;", "fromProvenanceEntry", "Lcom/intellij/code/provenance/core/events/storage/dto/ProvenanceEntryDTO;", "entry", "Lcom/intellij/code/provenance/core/ProvenanceEntry$OrdinaryEvent;", "pathResolver", "Lkotlin/Function1;", "", "", "intellij.code.provenance.core"})
    @SourceDebugExtension(value={"SMAP\nProvenanceEntryDTO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProvenanceEntryDTO.kt\ncom/intellij/code/provenance/core/events/storage/dto/ProvenanceEntryDTO$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,172:1\n1#2:173\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProvenanceEntryDTO fromProvenanceEntry(@NotNull ProvenanceEntry.OrdinaryEvent entry, @NotNull Function1<? super String, Long> pathResolver) {
            String string;
            byte[] byArray;
            Long l;
            Long l2;
            Object it;
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            Intrinsics.checkNotNullParameter(pathResolver, (String)"pathResolver");
            String type = entry.getClass().getSimpleName();
            String string2 = ProvenanceEventExtensionsKt.getDocumentPath(entry);
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                l2 = (Long)pathResolver.invoke(it);
            } else {
                l2 = null;
            }
            Long fileId = l2;
            ProvenanceEntry.OrdinaryEvent ordinaryEvent = entry;
            if (ordinaryEvent instanceof ProvenanceEntry.Idle) {
                l = null;
            } else if (ordinaryEvent instanceof ProvenanceEntry.DocumentChangeBase) {
                l = fileId;
            } else if (ordinaryEvent instanceof ProvenanceEntry.ContentChangeByLocalHistory) {
                l = fileId;
            } else if (ordinaryEvent instanceof ProvenanceEntry.DocumentRename) {
                l = fileId;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Long captionRaw = l;
            it = entry;
            if (it instanceof ProvenanceEntry.Idle) {
                byArray = new byte[]{};
            } else if (it instanceof ProvenanceEntry.DocumentChange) {
                byArray = ProvenanceEntryDTOKt.access$serialize(((ProvenanceEntry.DocumentChange)entry).getDiff());
            } else if (it instanceof ProvenanceEntry.ContentChangeByLocalHistory) {
                CharSequence charSequence;
                CharSequence bl = ((ProvenanceEntry.ContentChangeByLocalHistory)entry).getChangeSetName();
                if (bl.length() == 0) {
                    boolean bl2 = false;
                    charSequence = "unknown";
                } else {
                    charSequence = bl;
                }
                bl = (String)charSequence;
                byte[] byArray2 = ((String)bl).getBytes(Charsets.UTF_8);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            } else if (it instanceof ProvenanceEntry.ExternalDocumentChange) {
                String bl = String.valueOf(((ProvenanceEntry.ExternalDocumentChange)entry).getOldContentId());
                byte[] byArray3 = bl.getBytes(Charsets.UTF_8);
                byArray = byArray3;
                Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
            } else if (it instanceof ProvenanceEntry.DocumentRename) {
                Long l3 = (Long)pathResolver.invoke((Object)((ProvenanceEntry.DocumentRename)entry).getOldPath());
                long oldFileId = l3 != null ? l3 : -1L;
                byArray = ByteBuffer.allocate(8).putLong(oldFileId).array();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            byte[] payloadRaw = byArray;
            Base64 base64 = (Base64)base64;
            Intrinsics.checkNotNull((Object)payloadRaw);
            String payloadBase64 = Base64.encode$default((Base64)base64, (byte[])payloadRaw, (int)0, (int)0, (int)6, null);
            ProvenanceEntry.OrdinaryEvent bl2 = entry;
            if (bl2 instanceof ProvenanceEntry.DocumentChange) {
                string = String.valueOf(((ProvenanceEntry.DocumentChange)entry).getDurationMs());
            } else if (bl2 instanceof ProvenanceEntry.ContentChangeByLocalHistory) {
                string = String.valueOf(((ProvenanceEntry.ContentChangeByLocalHistory)entry).getContentId());
            } else if (bl2 instanceof ProvenanceEntry.ExternalDocumentChange || bl2 instanceof ProvenanceEntry.DocumentRename || bl2 instanceof ProvenanceEntry.Idle) {
                string = "";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String extra = string;
            DocumentChangesKind documentChangesKind = ProvenanceEventExtensionsKt.getKind(entry);
            String kind = documentChangesKind != null ? documentChangesKind.name() : null;
            Long oldContentHash = ProvenanceEventExtensionsKt.getOldContentHash(entry);
            Long newContentHash = ProvenanceEventExtensionsKt.getNewContentHash(entry);
            long l4 = entry.getTimestamp();
            Intrinsics.checkNotNull((Object)type);
            Long l5 = captionRaw;
            return new ProvenanceEntryDTO(l4, type, l5 != null ? l5 : -1L, payloadBase64, extra, kind, oldContentHash, newContentHash);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

