/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.protocol.channel;

import com.intellij.platform.split.connection.protocol.wire.TelemetryWireData;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/split/connection/protocol/channel/TelemetryByteChannel;", "Ljava/nio/channels/ByteChannel;", "underlying", "telemetry", "Lcom/intellij/platform/split/connection/protocol/wire/TelemetryWireData;", "<init>", "(Ljava/nio/channels/ByteChannel;Lcom/intellij/platform/split/connection/protocol/wire/TelemetryWireData;)V", "meter", "Lio/opentelemetry/api/metrics/Meter;", "readCounter", "Lio/opentelemetry/api/metrics/LongCounter;", "kotlin.jvm.PlatformType", "writeCounter", "close", "", "isOpen", "", "read", "", "dst", "Ljava/nio/ByteBuffer;", "write", "src", "intellij.platform.split.connection"})
public final class TelemetryByteChannel
implements ByteChannel {
    @NotNull
    private final ByteChannel underlying;
    @NotNull
    private final Meter meter;
    private final LongCounter readCounter;
    private final LongCounter writeCounter;

    public TelemetryByteChannel(@NotNull ByteChannel underlying, @NotNull TelemetryWireData telemetry) {
        Intrinsics.checkNotNullParameter((Object)underlying, (String)"underlying");
        Intrinsics.checkNotNullParameter((Object)telemetry, (String)"telemetry");
        this.underlying = underlying;
        this.meter = telemetry.getMeter();
        this.readCounter = this.meter.counterBuilder("rdct.CountingByteChannel.readBytesRate.project." + telemetry.getProjectId()).setUnit("bytes").build();
        this.writeCounter = this.meter.counterBuilder("rdct.CountingByteChannel.writeBytesRate.project." + telemetry.getProjectId()).setUnit("bytes").build();
    }

    @Override
    public void close() {
        this.underlying.close();
    }

    @Override
    public boolean isOpen() {
        return this.underlying.isOpen();
    }

    @Override
    public int read(@Nullable ByteBuffer dst) {
        int n;
        int it = n = this.underlying.read(dst);
        boolean bl = false;
        this.readCounter.add((long)it);
        return n;
    }

    @Override
    public int write(@Nullable ByteBuffer src) {
        int n;
        int it = n = this.underlying.write(src);
        boolean bl = false;
        this.writeCounter.add((long)it);
        return n;
    }
}

