/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.protocol.transport.creator;

import com.intellij.platform.split.connection.TransportType;
import com.intellij.platform.split.connection.protocol.transport.NamedTransportEntity;
import com.intellij.platform.split.connection.protocol.transport.TransportWrapper;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0001!B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0013J\u0010\u0010 \u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000bR\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\""}, d2={"Lcom/intellij/platform/split/connection/protocol/transport/creator/TransportInfo;", "Lcom/intellij/platform/split/connection/protocol/transport/NamedTransportEntity;", "id", "", "transportType", "Lcom/intellij/platform/split/connection/TransportType;", "transport", "Lcom/intellij/platform/split/connection/protocol/transport/TransportWrapper;", "<init>", "(Ljava/lang/String;Lcom/intellij/platform/split/connection/TransportType;Lcom/intellij/platform/split/connection/protocol/transport/TransportWrapper;)V", "getId", "()Ljava/lang/String;", "getTransportType", "()Lcom/intellij/platform/split/connection/TransportType;", "getTransport", "()Lcom/intellij/platform/split/connection/protocol/transport/TransportWrapper;", "_transportIndex", "Ljava/util/concurrent/atomic/AtomicInteger;", "transportIndex", "", "getTransportIndex", "()I", "_name", "name", "getName", "transportConnectionLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getTransportConnectionLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "assignTransportIndex", "", "index", "getNameByIndex", "Companion", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nTransportInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportInfo.kt\ncom/intellij/platform/split/connection/protocol/transport/creator/TransportInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,46:1\n1#2:47\n*E\n"})
public final class TransportInfo
implements NamedTransportEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final TransportType transportType;
    @NotNull
    private final TransportWrapper transport;
    @NotNull
    private final AtomicInteger _transportIndex;
    @NotNull
    private String _name;
    private static final int UNDEFINED_TRANSPORT_INDEX_VALUE = -1;

    public TransportInfo(@NotNull String id, @NotNull TransportType transportType, @NotNull TransportWrapper transport) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)transportType, (String)"transportType");
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        this.id = id;
        this.transportType = transportType;
        this.transport = transport;
        this._transportIndex = new AtomicInteger(-1);
        this._name = this.getNameByIndex(this.getTransportIndex());
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final TransportType getTransportType() {
        return this.transportType;
    }

    @NotNull
    public final TransportWrapper getTransport() {
        return this.transport;
    }

    public final int getTransportIndex() {
        return this._transportIndex.get();
    }

    @Override
    @NotNull
    public String getName() {
        return this._name;
    }

    @NotNull
    public final Lifetime getTransportConnectionLifetime() {
        return this.transport.getTransportLifetime();
    }

    public final void assignTransportIndex(int index) {
        if (!(index >= 0)) {
            boolean bl = false;
            String string = this.getName() + " Unable to assign transport index: <" + index + ">. Index must have a non-negative integer value.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!this._transportIndex.compareAndSet(-1, index)) {
            throw new IllegalStateException((this.getName() + " Unable to assign index: <" + index + ">. Transport already have index assigned: <" + this.getTransportIndex() + ">").toString());
        }
        this._name = this.getNameByIndex(index);
    }

    private final String getNameByIndex(int index) {
        return "Transport Info (type: " + this.transportType + ", index: " + index + ", id: " + this.id + ")";
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/split/connection/protocol/transport/creator/TransportInfo$Companion;", "", "<init>", "()V", "UNDEFINED_TRANSPORT_INDEX_VALUE", "", "intellij.platform.split.connection"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

