/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.widget;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.Formats;
import com.intellij.platform.split.connection.TransportType;
import com.intellij.platform.split.connection.protocol.ICodeWithMeWire;
import com.intellij.platform.split.connection.protocol.transport.creator.TransportInfo;
import com.intellij.util.containers.ConcurrentList;
import com.jetbrains.rd.platform.codeWithMe.PlatformSplitBundle;
import com.jetbrains.rd.util.PlatformDependentKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J\u001b\u0010\t\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/split/connection/widget/WireStatsPresentationUtil;", "", "<init>", "()V", "getWireStatsPresentableText", "", "wires", "Lcom/intellij/util/containers/ConcurrentList;", "Lcom/intellij/platform/split/connection/protocol/ICodeWithMeWire;", "getTransportTypeLetter", "", "([Lcom/intellij/platform/split/connection/protocol/ICodeWithMeWire;)Ljava/lang/String;", "transportType", "Lcom/intellij/platform/split/connection/TransportType;", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nWireStatsPresentationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WireStatsPresentationUtil.kt\ncom/intellij/platform/split/connection/widget/WireStatsPresentationUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,71:1\n777#2:72\n873#2,2:73\n37#3,2:75\n1#4:77\n14060#5,2:78\n*S KotlinDebug\n*F\n+ 1 WireStatsPresentationUtil.kt\ncom/intellij/platform/split/connection/widget/WireStatsPresentationUtil\n*L\n26#1:72\n26#1:73,2\n32#1:75,2\n45#1:78,2\n*E\n"})
public final class WireStatsPresentationUtil {
    @NotNull
    public static final WireStatsPresentationUtil INSTANCE = new WireStatsPresentationUtil();

    private WireStatsPresentationUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NlsSafe
    @NotNull
    public final String getWireStatsPresentableText(@NotNull ConcurrentList<ICodeWithMeWire> wires) {
        double d;
        double d2;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(wires, (String)"wires");
        Iterable $this$filter$iv = (Iterable)wires;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ICodeWithMeWire wire = (ICodeWithMeWire)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)wire.getConnected().getValue()).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List connectedWires = (List)destination$iv$iv;
        if (connectedWires.isEmpty()) {
            return "";
        }
        Collection $this$toTypedArray$iv = connectedWires;
        boolean $i$f$toTypedArray = false;
        Iterable thisCollection$iv = $this$toTypedArray$iv;
        String transportLetter = this.getTransportTypeLetter(thisCollection$iv.toArray(new ICodeWithMeWire[0]));
        thisCollection$iv = connectedWires;
        double d3 = 0.0;
        for (Object e : thisCollection$iv) {
            void it;
            ICodeWithMeWire bl = (ICodeWithMeWire)e;
            d2 = d3;
            boolean bl2 = false;
            d = it.getTransportStats().getSendSpeed();
            d3 = d2 + d;
        }
        long totalSend = (long)d3;
        Object[] objectArray = connectedWires;
        double d4 = 0.0;
        for (Object t : objectArray) {
            void it;
            ICodeWithMeWire iCodeWithMeWire = (ICodeWithMeWire)t;
            d2 = d4;
            boolean bl = false;
            d = it.getTransportStats().getReceiveSpeed();
            d4 = d2 + d;
        }
        long totalReceive = (long)d4;
        objectArray = new Object[3];
        objectArray[0] = transportLetter;
        Intrinsics.checkNotNullExpressionValue((Object)Formats.formatFileSize((long)totalSend), (String)"formatFileSize(...)");
        Intrinsics.checkNotNullExpressionValue((Object)Formats.formatFileSize((long)totalReceive), (String)"formatFileSize(...)");
        return PlatformSplitBundle.INSTANCE.message("wire.stats.status.bar.text", objectArray);
    }

    private final String getTransportTypeLetter(ICodeWithMeWire[] wires) {
        if (!(!(wires.length == 0))) {
            boolean $i$a$-require-WireStatsPresentationUtil$getTransportTypeLetter$22 = false;
            String $i$a$-require-WireStatsPresentationUtil$getTransportTypeLetter$22 = "Unable to get transport type letter for an empty wires list";
            throw new IllegalArgumentException($i$a$-require-WireStatsPresentationUtil$getTransportTypeLetter$22.toString());
        }
        Map letterCountMap = PlatformDependentKt.concurrentMapOf();
        ICodeWithMeWire[] $this$forEach$iv = wires;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            ICodeWithMeWire element$iv;
            ICodeWithMeWire wire = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            TransportInfo transportInfo = wire.getTransportInfo();
            if (transportInfo == null || (transportInfo = transportInfo.getTransportType()) == null) {
                transportInfo = TransportType.Unknown;
            }
            TransportInfo wireTransportType = transportInfo;
            String letter = INSTANCE.getTransportTypeLetter((TransportType)wireTransportType);
            letterCountMap.putIfAbsent(letter, 0);
            letterCountMap.put(letter, ((Number)MapsKt.getValue((Map)letterCountMap, (Object)letter)).intValue() + 1);
        }
        Function1 transform = WireStatsPresentationUtil::getTransportTypeLetter$lambda$2;
        return CollectionsKt.joinToString$default((Iterable)letterCountMap.entrySet(), (CharSequence)"/", null, null, (int)0, null, (Function1)transform, (int)30, null);
    }

    private final String getTransportTypeLetter(TransportType transportType) {
        return switch (WhenMappings.$EnumSwitchMapping$0[transportType.ordinal()]) {
            case 1 -> "R";
            case 2 -> "T";
            case 3 -> "P";
            case 4 -> "D";
            default -> "?";
        };
    }

    private static final CharSequence getTransportTypeLetter$lambda$2(Map.Entry mapEntry) {
        Intrinsics.checkNotNullParameter((Object)mapEntry, (String)"mapEntry");
        String letter = (String)mapEntry.getKey();
        int count = ((Number)mapEntry.getValue()).intValue();
        return count > 1 ? (CharSequence)(count + letter) : (CharSequence)letter;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TransportType.values().length];
            try {
                nArray[TransportType.WsRelay.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransportType.TurnRelayQuic.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransportType.Peer2PeerQuic.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransportType.DirectTcp.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

