/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.model;

import com.intellij.packageChecker.model.SingleVersionKt;
import java.lang.module.ModuleDescriptor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0000H\u0096\u0082\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\n\u0010\r\u001a\u00020\u0003H\u0096\u0080\u0004J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\f2\b\u0010\n\u001a\u0004\u0018\u00010\u0011H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\tH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/packageChecker/model/SingleVersion;", "", "value", "", "<init>", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "compareTo", "", "other", "checkIfAnyVersion", "", "toString", "component1", "copy", "equals", "", "hashCode", "intellij.packageChecker"})
public final class SingleVersion
implements Comparable<SingleVersion> {
    @NotNull
    private final String value;

    public SingleVersion(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @Override
    public int compareTo(@NotNull SingleVersion other) {
        ModuleDescriptor.Version version;
        ModuleDescriptor.Version version2;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (StringsKt.isBlank((CharSequence)this.value) && StringsKt.isBlank((CharSequence)other.value)) {
            return 0;
        }
        if (StringsKt.isBlank((CharSequence)this.value)) {
            return -1;
        }
        if (StringsKt.isBlank((CharSequence)other.value)) {
            return 1;
        }
        try {
            version2 = ModuleDescriptor.Version.parse(this.value);
        }
        catch (Exception e) {
            version2 = SingleVersionKt.getMinimalVersion();
        }
        ModuleDescriptor.Version myVersion = version2;
        try {
            version = ModuleDescriptor.Version.parse(other.value);
        }
        catch (Exception e) {
            version = SingleVersionKt.getMinimalVersion();
        }
        ModuleDescriptor.Version otherVersion = version;
        return myVersion.compareTo(otherVersion);
    }

    public final boolean checkIfAnyVersion() {
        return Intrinsics.areEqual((Object)this.value, (Object)"*");
    }

    @NotNull
    public String toString() {
        return this.value;
    }

    @NotNull
    public final String component1() {
        return this.value;
    }

    @NotNull
    public final SingleVersion copy(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new SingleVersion(value);
    }

    public static /* synthetic */ SingleVersion copy$default(SingleVersion singleVersion, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = singleVersion.value;
        }
        return singleVersion.copy(string);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SingleVersion)) {
            return false;
        }
        SingleVersion singleVersion = (SingleVersion)other;
        return Intrinsics.areEqual((Object)this.value, (Object)singleVersion.value);
    }
}

