/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action.task;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.action.ExternalSystemToggleAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.RunConfigurationNode;
import com.intellij.openapi.externalSystem.view.TaskNode;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class ToggleTaskActivationAction
extends ExternalSystemToggleAction {
    @NotNull
    private final ExternalSystemTaskActivator.Phase myPhase;

    protected ToggleTaskActivationAction(@NotNull ExternalSystemTaskActivator.Phase phase) {
        if (phase == null) {
            ToggleTaskActivationAction.$$$reportNull$$$0(0);
        }
        this.myPhase = phase;
    }

    @Override
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleTaskActivationAction.$$$reportNull$$$0(1);
        }
        return super.isEnabled(e) && !ToggleTaskActivationAction.getTasks(e).isEmpty();
    }

    @Override
    protected boolean doIsSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleTaskActivationAction.$$$reportNull$$$0(2);
        }
        return this.hasTask(this.getTaskActivator(e), ToggleTaskActivationAction.getTasks(e).get(0));
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        if (e == null) {
            ToggleTaskActivationAction.$$$reportNull$$$0(3);
        }
        ExternalSystemActionsCollector.trigger(this.getProject(e), this.getSystemId(e), (AnAction)this, e);
        List<TaskData> tasks = ToggleTaskActivationAction.getTasks(e);
        if (state) {
            this.addTasks(this.getTaskActivator(e), tasks);
        } else {
            this.removeTasks(this.getTaskActivator(e), tasks);
        }
    }

    @NotNull
    private static List<TaskData> getTasks(@NotNull AnActionEvent e) {
        List selectedNodes;
        if (e == null) {
            ToggleTaskActivationAction.$$$reportNull$$$0(4);
        }
        if ((selectedNodes = (List)e.getData(ExternalSystemDataKeys.SELECTED_NODES)) == null) {
            List<TaskData> list = Collections.emptyList();
            if (list == null) {
                ToggleTaskActivationAction.$$$reportNull$$$0(5);
            }
            return list;
        }
        SmartList tasks = new SmartList();
        for (ExternalSystemNode node : selectedNodes) {
            if (node instanceof TaskNode && !node.isIgnored()) {
                tasks.add((TaskData)node.getData());
                continue;
            }
            if (node instanceof RunConfigurationNode) {
                RunnerAndConfigurationSettings configurationSettings = ((RunConfigurationNode)node).getSettings();
                ExternalSystemRunConfiguration runConfiguration = (ExternalSystemRunConfiguration)configurationSettings.getConfiguration();
                ExternalSystemTaskExecutionSettings taskExecutionSettings = runConfiguration.getSettings();
                tasks.add(new TaskData(taskExecutionSettings.getExternalSystemId(), "run: " + configurationSettings.getName(), taskExecutionSettings.getExternalProjectPath(), null));
                continue;
            }
            List<TaskData> list = Collections.emptyList();
            if (list == null) {
                ToggleTaskActivationAction.$$$reportNull$$$0(6);
            }
            return list;
        }
        SmartList smartList = tasks;
        if (smartList == null) {
            ToggleTaskActivationAction.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    protected boolean hasTask(ExternalSystemTaskActivator manager, TaskData taskData) {
        if (taskData == null) {
            return false;
        }
        return manager.isTaskOfPhase(taskData, this.myPhase);
    }

    private void addTasks(ExternalSystemTaskActivator taskActivator, List<TaskData> tasks) {
        taskActivator.addTasks(tasks, this.myPhase);
    }

    private void removeTasks(ExternalSystemTaskActivator taskActivator, List<TaskData> tasks) {
        taskActivator.removeTasks(tasks, this.myPhase);
    }

    private ExternalSystemTaskActivator getTaskActivator(@NotNull AnActionEvent e) {
        if (e == null) {
            ToggleTaskActivationAction.$$$reportNull$$$0(8);
        }
        return ExternalProjectsManagerImpl.getInstance(this.getProject(e)).getTaskActivator();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/action/task/ToggleTaskActivationAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/action/task/ToggleTaskActivationAction";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doIsSelected";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTasks";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTaskActivator";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

