/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemModificationType;
import com.intellij.openapi.externalSystem.autoimport.ProjectStatus;
import com.intellij.openapi.externalSystem.autoimport.changes.AsyncDocumentChangesListener;
import com.intellij.openapi.externalSystem.autoimport.changes.AsyncVirtualFilesChangesListener;
import com.intellij.openapi.externalSystem.autoimport.changes.FilesChangesListener;
import com.intellij.openapi.externalSystem.autoimport.changes.vfs.VirtualFileChangesListener;
import com.intellij.openapi.externalSystem.autoimport.settings.AsyncSupplier;
import com.intellij.openapi.util.io.CanonicalPathPrefixTree;
import com.intellij.util.containers.prefixTree.PrefixTreeFactory;
import com.intellij.util.containers.prefixTree.set.PrefixTreeSet;
import com.intellij.util.containers.prefixTree.set.PrefixTreeSets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B+\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0010R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/changes/AsyncFileChangesListener;", "", "filesProvider", "Lcom/intellij/openapi/externalSystem/autoimport/settings/AsyncSupplier;", "", "", "changesListener", "Lcom/intellij/openapi/externalSystem/autoimport/changes/FilesChangesListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/externalSystem/autoimport/settings/AsyncSupplier;Lcom/intellij/openapi/externalSystem/autoimport/changes/FilesChangesListener;Lcom/intellij/openapi/Disposable;)V", "updatedFiles", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/externalSystem/autoimport/changes/AsyncFileChangesListener$ModificationData;", "init", "", "onFileChange", "path", "modificationStamp", "", "modificationType", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemModificationType;", "apply", "ModificationData", "Companion", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nAsyncFileChangesListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncFileChangesListener.kt\ncom/intellij/openapi/externalSystem/autoimport/changes/AsyncFileChangesListener\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n78#2:98\n99#2,2:99\n101#2,3:105\n1586#3:101\n1661#3,3:102\n*S KotlinDebug\n*F\n+ 1 AsyncFileChangesListener.kt\ncom/intellij/openapi/externalSystem/autoimport/changes/AsyncFileChangesListener\n*L\n42#1:98\n42#1:99,2\n42#1:105,3\n44#1:101\n44#1:102,3\n*E\n"})
public final class AsyncFileChangesListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AsyncSupplier<Set<String>> filesProvider;
    @NotNull
    private final FilesChangesListener changesListener;
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final ConcurrentHashMap<String, ModificationData> updatedFiles;

    public AsyncFileChangesListener(@NotNull AsyncSupplier<Set<String>> filesProvider, @NotNull FilesChangesListener changesListener, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(filesProvider, (String)"filesProvider");
        Intrinsics.checkNotNullParameter((Object)changesListener, (String)"changesListener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.filesProvider = filesProvider;
        this.changesListener = changesListener;
        this.parentDisposable = parentDisposable;
        this.updatedFiles = new ConcurrentHashMap();
    }

    public final void init() {
        this.updatedFiles.clear();
    }

    public final void onFileChange(@NotNull String path, long modificationStamp, @NotNull ExternalSystemModificationType modificationType) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)modificationType, (String)"modificationType");
        ((Map)this.updatedFiles).put(path, new ModificationData(modificationStamp, modificationType));
    }

    public final void apply() {
        ProjectStatus.Stamp stamp = ProjectStatus.Stamp.Companion.nextStamp();
        HashMap updatedFilesSnapshot = new HashMap(this.updatedFiles);
        this.filesProvider.supply(this.parentDisposable, (Function1<Set<String>, Unit>)((Function1)arg_0 -> AsyncFileChangesListener.apply$lambda$0(updatedFilesSnapshot, this, stamp, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit apply$lambda$0(HashMap $updatedFilesSnapshot, AsyncFileChangesListener this$0, ProjectStatus.Stamp $stamp, Set filesToWatch) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)filesToWatch, (String)"filesToWatch");
        PrefixTreeSet index = PrefixTreeSets.toPrefixTreeSet((Iterable)filesToWatch, (PrefixTreeFactory)((PrefixTreeFactory)CanonicalPathPrefixTree.INSTANCE));
        Map $this$flatMap$iv = $updatedFilesSnapshot;
        boolean $i$f$flatMap = false;
        Map map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            String path = (String)entry.getKey();
            ModificationData modificationData = (ModificationData)entry.getValue();
            Intrinsics.checkNotNull((Object)path);
            Iterable iterable = index.getDescendants((Object)path);
            boolean $i$f$map = false;
            void var19_20 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(TuplesKt.to((Object)it, (Object)modificationData));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List updatedWatchedFiles = (List)destination$iv$iv;
        if (!((Collection)updatedWatchedFiles).isEmpty()) {
            this$0.changesListener.init();
            for (Pair pair : updatedWatchedFiles) {
                String path = (String)pair.component1();
                ModificationData modificationData = (ModificationData)pair.component2();
                long modificationStamp = modificationData.component1();
                ExternalSystemModificationType modificationType = modificationData.component2();
                this$0.changesListener.onFileChange($stamp, path, modificationStamp, modificationType);
            }
            this$0.changesListener.apply();
        }
        return Unit.INSTANCE;
    }

    @JvmStatic
    public static final void subscribeOnDocumentsAndVirtualFilesChanges(@NotNull AsyncSupplier<Set<String>> filesProvider, @NotNull FilesChangesListener listener2, @NotNull Disposable parentDisposable) {
        Companion.subscribeOnDocumentsAndVirtualFilesChanges(filesProvider, listener2, parentDisposable);
    }

    @JvmStatic
    public static final void subscribeOnVirtualFilesChanges(boolean isIgnoreInternalChanges, @NotNull AsyncSupplier<Set<String>> filesProvider, @NotNull FilesChangesListener listener2, @NotNull Disposable parentDisposable) {
        Companion.subscribeOnVirtualFilesChanges(isIgnoreInternalChanges, filesProvider, listener2, parentDisposable);
    }

    @JvmStatic
    public static final void subscribeOnDocumentsChanges(boolean isIgnoreExternalChanges, @NotNull AsyncSupplier<Set<String>> filesProvider, @NotNull FilesChangesListener listener2, @NotNull Disposable parentDisposable) {
        Companion.subscribeOnDocumentsChanges(isIgnoreExternalChanges, filesProvider, listener2, parentDisposable);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J4\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J4\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00102\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/changes/AsyncFileChangesListener$Companion;", "", "<init>", "()V", "subscribeOnDocumentsAndVirtualFilesChanges", "", "filesProvider", "Lcom/intellij/openapi/externalSystem/autoimport/settings/AsyncSupplier;", "", "", "listener", "Lcom/intellij/openapi/externalSystem/autoimport/changes/FilesChangesListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "subscribeOnVirtualFilesChanges", "isIgnoreInternalChanges", "", "subscribeOnDocumentsChanges", "isIgnoreExternalChanges", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void subscribeOnDocumentsAndVirtualFilesChanges(@NotNull AsyncSupplier<Set<String>> filesProvider, @NotNull FilesChangesListener listener2, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter(filesProvider, (String)"filesProvider");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            this.subscribeOnVirtualFilesChanges(true, filesProvider, listener2, parentDisposable);
            this.subscribeOnDocumentsChanges(true, filesProvider, listener2, parentDisposable);
        }

        @JvmStatic
        public final void subscribeOnVirtualFilesChanges(boolean isIgnoreInternalChanges, @NotNull AsyncSupplier<Set<String>> filesProvider, @NotNull FilesChangesListener listener2, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter(filesProvider, (String)"filesProvider");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            AsyncFileChangesListener fileListener = new AsyncFileChangesListener(filesProvider, listener2, parentDisposable);
            AsyncVirtualFilesChangesListener virtualFileListener = new AsyncVirtualFilesChangesListener(isIgnoreInternalChanges, fileListener);
            VirtualFileChangesListener.Companion.installAsyncVirtualFileListener(virtualFileListener, parentDisposable);
        }

        @JvmStatic
        public final void subscribeOnDocumentsChanges(boolean isIgnoreExternalChanges, @NotNull AsyncSupplier<Set<String>> filesProvider, @NotNull FilesChangesListener listener2, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter(filesProvider, (String)"filesProvider");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            AsyncFileChangesListener fileListener = new AsyncFileChangesListener(filesProvider, listener2, parentDisposable);
            AsyncDocumentChangesListener documentListener = new AsyncDocumentChangesListener(isIgnoreExternalChanges, fileListener);
            EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)documentListener, parentDisposable);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/changes/AsyncFileChangesListener$ModificationData;", "", "modificationStamp", "", "modificationType", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemModificationType;", "<init>", "(JLcom/intellij/openapi/externalSystem/autoimport/ExternalSystemModificationType;)V", "getModificationStamp", "()J", "getModificationType", "()Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemModificationType;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.externalSystem.impl"})
    private static final class ModificationData {
        private final long modificationStamp;
        @NotNull
        private final ExternalSystemModificationType modificationType;

        public ModificationData(long modificationStamp, @NotNull ExternalSystemModificationType modificationType) {
            Intrinsics.checkNotNullParameter((Object)modificationType, (String)"modificationType");
            this.modificationStamp = modificationStamp;
            this.modificationType = modificationType;
        }

        public final long getModificationStamp() {
            return this.modificationStamp;
        }

        @NotNull
        public final ExternalSystemModificationType getModificationType() {
            return this.modificationType;
        }

        public final long component1() {
            return this.modificationStamp;
        }

        @NotNull
        public final ExternalSystemModificationType component2() {
            return this.modificationType;
        }

        @NotNull
        public final ModificationData copy(long modificationStamp, @NotNull ExternalSystemModificationType modificationType) {
            Intrinsics.checkNotNullParameter((Object)modificationType, (String)"modificationType");
            return new ModificationData(modificationStamp, modificationType);
        }

        public static /* synthetic */ ModificationData copy$default(ModificationData modificationData, long l, ExternalSystemModificationType externalSystemModificationType, int n, Object object) {
            if ((n & 1) != 0) {
                l = modificationData.modificationStamp;
            }
            if ((n & 2) != 0) {
                externalSystemModificationType = modificationData.modificationType;
            }
            return modificationData.copy(l, externalSystemModificationType);
        }

        @NotNull
        public String toString() {
            return "ModificationData(modificationStamp=" + this.modificationStamp + ", modificationType=" + this.modificationType + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.modificationStamp);
            result = result * 31 + this.modificationType.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModificationData)) {
                return false;
            }
            ModificationData modificationData = (ModificationData)other;
            if (this.modificationStamp != modificationData.modificationStamp) {
                return false;
            }
            return this.modificationType == modificationData.modificationType;
        }
    }
}

