/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.internal;

import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemExecutionAware;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.externalSystem.service.internal.AbstractExternalSystemTask;
import com.intellij.openapi.externalSystem.service.remote.ExternalSystemProgressNotificationManagerImpl;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemTaskCollector;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.execution.ParametersListUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemExecuteTaskTask
extends AbstractExternalSystemTask {
    @NotNull
    private final List<String> myTasksToExecute;
    @Nullable
    private final String myVmOptions;
    @Nullable
    private String myArguments;
    @Nullable
    private final String myJvmParametersSetup;
    private final boolean myPassParentEnvs;
    private final Map<String, String> myEnv;
    @NotNull
    private final ExternalSystemRunConfiguration myConfiguration;

    public ExternalSystemExecuteTaskTask(@NotNull Project project, @NotNull ExternalSystemTaskExecutionSettings settings, @Nullable String jvmParametersSetup, @NotNull ExternalSystemRunConfiguration configuration) throws IllegalArgumentException {
        if (project == null) {
            ExternalSystemExecuteTaskTask.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            ExternalSystemExecuteTaskTask.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            ExternalSystemExecuteTaskTask.$$$reportNull$$$0(2);
        }
        super(settings.getExternalSystemId(), ExternalSystemTaskType.EXECUTE_TASK, project, settings.getExternalProjectPath());
        this.myTasksToExecute = new ArrayList<String>(settings.getTaskNames());
        this.myVmOptions = settings.getVmOptions();
        this.myArguments = settings.getScriptParameters();
        this.myPassParentEnvs = settings.isPassParentEnvs();
        this.myEnv = settings.getEnv();
        this.myJvmParametersSetup = jvmParametersSetup;
        this.myConfiguration = configuration;
        configuration.copyUserDataTo(this);
    }

    @NotNull
    public List<String> getTasksToExecute() {
        List<String> list = this.myTasksToExecute;
        if (list == null) {
            ExternalSystemExecuteTaskTask.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public String getVmOptions() {
        return this.myVmOptions;
    }

    @Nullable
    public String getArguments() {
        return this.myArguments;
    }

    public void appendArguments(@NotNull String arguments) {
        if (arguments == null) {
            ExternalSystemExecuteTaskTask.$$$reportNull$$$0(4);
        }
        this.myArguments = this.myArguments == null ? arguments : this.myArguments + " " + arguments;
    }

    @Override
    protected void doExecute() throws Exception {
        Project project = this.getIdeProject();
        ProjectSystemId projectSystemId = this.getExternalSystemId();
        String projectPath = this.getExternalProjectPath();
        ExternalSystemProgressNotificationManagerImpl progressNotificationManager = ExternalSystemProgressNotificationManagerImpl.getInstanceImpl();
        ExternalSystemTaskNotificationListener progressNotificationListener = ExternalSystemExecuteTaskTask.wrapWithListener(progressNotificationManager);
        for (ExternalSystemExecutionAware executionAware : ExternalSystemExecutionAware.getExtensions(projectSystemId)) {
            executionAware.prepareExecution(this, projectPath, false, progressNotificationListener, project);
        }
        ExternalSystemExecutionSettings settings = ExternalSystemApiUtil.getExecutionSettings((Project)project, (String)projectPath, (ProjectSystemId)projectSystemId).withVmOptions(ExternalSystemExecuteTaskTask.parseCmdParameters(this.myVmOptions)).withArguments(ExternalSystemExecuteTaskTask.parseCmdParameters(this.myArguments)).withEnvironmentVariables(this.myEnv).passParentEnvs(this.myPassParentEnvs);
        settings.setTasks(this.myTasksToExecute);
        settings.setJvmParameters(this.myJvmParametersSetup);
        this.putUserDataTo((UserDataHolder)settings);
        TargetEnvironmentConfigurationProvider environmentConfigurationProvider = null;
        for (ExternalSystemExecutionAware executionAware : ExternalSystemExecutionAware.getExtensions(projectSystemId)) {
            if (environmentConfigurationProvider != null) continue;
            environmentConfigurationProvider = executionAware.getEnvironmentConfigurationProvider(this.myConfiguration, project);
        }
        ExternalSystemExecutionAware.setEnvironmentConfigurationProvider(settings, environmentConfigurationProvider);
        this.executeTasks(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTasks(@NotNull ExternalSystemExecutionSettings settings) throws Exception {
        if (settings == null) {
            ExternalSystemExecuteTaskTask.$$$reportNull$$$0(5);
        }
        ExternalSystemTaskId id = this.getId();
        Project project = this.getIdeProject();
        ProjectSystemId projectSystemId = this.getExternalSystemId();
        String projectPath = this.getExternalProjectPath();
        TargetEnvironmentConfigurationProvider environmentConfigurationProvider = ExternalSystemExecutionAware.getEnvironmentConfigurationProvider(settings);
        StructuredIdeActivity activity = ExternalSystemTaskCollector.externalSystemTaskStarted(project, projectSystemId, com.intellij.openapi.externalSystem.statistics.ExternalSystemTaskId.ExecuteTask, environmentConfigurationProvider);
        try {
            ExternalSystemFacadeManager manager = ExternalSystemFacadeManager.getInstance();
            RemoteExternalSystemFacade facade = manager.getFacade(project, projectPath, projectSystemId);
            RemoteExternalSystemTaskManager<ExternalSystemExecutionSettings> taskManager = facade.getTaskManager();
            taskManager.executeTasks(projectPath, id, settings);
        }
        finally {
            activity.finished();
        }
    }

    @Override
    protected boolean doCancel() throws Exception {
        ExternalSystemFacadeManager manager = ExternalSystemFacadeManager.getInstance();
        RemoteExternalSystemFacade facade = manager.getFacade(this.getIdeProject(), this.getExternalProjectPath(), this.getExternalSystemId());
        RemoteExternalSystemTaskManager taskManager = facade.getTaskManager();
        return taskManager.cancelTask(this.getId());
    }

    private static List<String> parseCmdParameters(@Nullable String cmdArgsLine) {
        return cmdArgsLine != null ? ParametersListUtil.parse((String)cmdArgsLine, (boolean)false, (boolean)true) : new ArrayList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/internal/ExternalSystemExecuteTaskTask";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/internal/ExternalSystemExecuteTaskTask";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasksToExecute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendArguments";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "executeTasks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

