/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.build.AbstractViewManager;
import com.intellij.build.BuildBundle;
import com.intellij.build.BuildConsoleUtils;
import com.intellij.build.BuildContentDescriptor;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildEventDispatcher;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.FinishBuildEvent;
import com.intellij.build.events.impl.FailureImpl;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.OutputBuildEventImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.icons.AllIcons;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.execution.ExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.importing.ImportSpec;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.issue.BuildIssueException;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.service.ImportCanceledException;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.DefaultExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemEventDispatcher;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemProcessHandler;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunnableState;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemResolveProjectTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ContentRootDataService;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManagerImpl;
import com.intellij.openapi.externalSystem.service.project.trusted.ExternalSystemTrustedProjectDialog;
import com.intellij.openapi.externalSystem.service.ui.ExternalProjectDataSelectorDialog;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemStatUtilKt;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemActivityKey;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemProgressEventConverter;
import com.intellij.openapi.externalSystem.util.ExternalSystemTaskUnderProgress;
import com.intellij.openapi.externalSystem.util.ExternalSystemTelemetryUtil;
import com.intellij.openapi.externalSystem.util.task.TaskExecutionSpec;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.IncompleteDependenciesService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.platform.backend.observation.ActivityKey;
import com.intellij.platform.backend.observation.TrackingUtil;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.HashingStrategy;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalSystemUtil {
    private static final Logger LOG = Logger.getInstance(ExternalSystemUtil.class);
    @NotNull
    private static final Map<String, String> RUNNER_IDS = new HashMap<String, String>();
    public static final HashingStrategy<Pair<ProjectSystemId, File>> HASHING_STRATEGY = new HashingStrategy<Pair<ProjectSystemId, File>>(){

        public int hashCode(Pair<ProjectSystemId, File> object) {
            return ((ProjectSystemId)object.first).hashCode() + FileUtil.fileHashCode((File)((File)object.second));
        }

        public boolean equals(Pair<ProjectSystemId, File> o1, Pair<ProjectSystemId, File> o2) {
            return ((ProjectSystemId)o1.first).equals(o2.first) && FileUtil.filesEqual((File)((File)o1.second), (File)((File)o2.second));
        }
    };

    private ExternalSystemUtil() {
    }

    public static int fileHashCode(@Nullable File file) {
        int hash;
        try {
            hash = FileUtil.pathHashCode((String)(file == null ? null : file.getCanonicalPath()));
        }
        catch (IOException e) {
            LOG.warn("unable to get canonical file path", (Throwable)e);
            hash = FileUtil.fileHashCode((File)file);
        }
        return hash;
    }

    public static boolean filesEqual(@Nullable File file1, @Nullable File file2) {
        try {
            return FileUtil.pathsEqual((String)(file1 == null ? null : file1.getCanonicalPath()), (String)(file2 == null ? null : file2.getCanonicalPath()));
        }
        catch (IOException e) {
            LOG.warn("unable to get canonical file path", (Throwable)e);
            return FileUtil.filesEqual((File)file1, (File)file2);
        }
    }

    @Nullable
    public static ToolWindow ensureToolWindowContentInitialized(@NotNull Project project, @NotNull ProjectSystemId externalSystemId) {
        if (project == null) {
            ExternalSystemUtil.$$$reportNull$$$0(0);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(1);
        }
        return ToolWindowManager.getInstance((Project)project).getToolWindow(externalSystemId.getReadableName());
    }

    public static void refreshProjects(@NotNull ImportSpecBuilder specBuilder) {
        if (specBuilder == null) {
            ExternalSystemUtil.$$$reportNull$$$0(2);
        }
        ExternalSystemUtil.refreshProjects(specBuilder.build());
    }

    public static void refreshProjects(@NotNull ImportSpec spec) {
        ExternalSystemManager manager;
        if (spec == null) {
            ExternalSystemUtil.$$$reportNull$$$0(3);
        }
        if ((manager = ExternalSystemApiUtil.getManager((ProjectSystemId)spec.getExternalSystemId())) == null) {
            return;
        }
        AbstractExternalSystemSettings settings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)spec.getProject());
        Collection projectsSettings = settings.getLinkedProjectsSettings();
        if (projectsSettings.isEmpty()) {
            return;
        }
        HashSet<String> externalProjectPaths = new HashSet<String>();
        for (ExternalProjectSettings setting : projectsSettings) {
            externalProjectPaths.add(setting.getExternalProjectPath());
        }
        ExternalSystemUtil.refreshProjectImpl(externalProjectPaths, spec);
    }

    @NotNull
    private static String extractDetails(@NotNull Throwable e) {
        ExternalSystemException esException;
        String reason;
        Throwable unwrapped;
        if (e == null) {
            ExternalSystemUtil.$$$reportNull$$$0(4);
        }
        if ((unwrapped = RemoteUtil.unwrap((Throwable)e)) instanceof ExternalSystemException && !(reason = (esException = (ExternalSystemException)unwrapped).getOriginalReason()).isEmpty()) {
            String string = reason;
            if (string == null) {
                ExternalSystemUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = ExternalSystemApiUtil.stacktraceAsString((Throwable)e);
        if (string == null) {
            ExternalSystemUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Deprecated
    public static void refreshProject(@NotNull Project project, @NotNull ProjectSystemId externalSystemId, @NotNull String externalProjectPath, boolean isPreviewMode, @NotNull ProgressExecutionMode progressExecutionMode) {
        if (project == null) {
            ExternalSystemUtil.$$$reportNull$$$0(7);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(8);
        }
        if (externalProjectPath == null) {
            ExternalSystemUtil.$$$reportNull$$$0(9);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.$$$reportNull$$$0(10);
        }
        ImportSpecBuilder builder = new ImportSpecBuilder(project, externalSystemId).use(progressExecutionMode).withPreviewMode(isPreviewMode);
        ExternalSystemUtil.refreshProject(externalProjectPath, builder);
    }

    @Deprecated
    public static void refreshProject(@NotNull Project project, @NotNull ProjectSystemId externalSystemId, @NotNull String externalProjectPath, @NotNull ExternalProjectRefreshCallback callback, boolean isPreviewMode, @NotNull ProgressExecutionMode progressExecutionMode) {
        if (project == null) {
            ExternalSystemUtil.$$$reportNull$$$0(11);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(12);
        }
        if (externalProjectPath == null) {
            ExternalSystemUtil.$$$reportNull$$$0(13);
        }
        if (callback == null) {
            ExternalSystemUtil.$$$reportNull$$$0(14);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.$$$reportNull$$$0(15);
        }
        ImportSpecBuilder builder = new ImportSpecBuilder(project, externalSystemId).callback(callback).use(progressExecutionMode).withPreviewMode(isPreviewMode);
        ExternalSystemUtil.refreshProject(externalProjectPath, builder);
    }

    @Deprecated
    public static void refreshProject(@NotNull Project project, @NotNull ProjectSystemId externalSystemId, @NotNull String externalProjectPath, @NotNull ExternalProjectRefreshCallback callback, boolean isPreviewMode, @NotNull ProgressExecutionMode progressExecutionMode, boolean reportRefreshError) {
        if (project == null) {
            ExternalSystemUtil.$$$reportNull$$$0(16);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(17);
        }
        if (externalProjectPath == null) {
            ExternalSystemUtil.$$$reportNull$$$0(18);
        }
        if (callback == null) {
            ExternalSystemUtil.$$$reportNull$$$0(19);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.$$$reportNull$$$0(20);
        }
        ImportSpecBuilder builder = new ImportSpecBuilder(project, externalSystemId).callback(callback).use(progressExecutionMode).withPreviewMode(isPreviewMode).withActivateToolWindowOnFailure(reportRefreshError);
        ExternalSystemUtil.refreshProject(externalProjectPath, builder);
    }

    public static void refreshProject(@NotNull String externalProjectPath, @NotNull ImportSpecBuilder importSpecBuilder) {
        if (externalProjectPath == null) {
            ExternalSystemUtil.$$$reportNull$$$0(21);
        }
        if (importSpecBuilder == null) {
            ExternalSystemUtil.$$$reportNull$$$0(22);
        }
        ExternalSystemUtil.refreshProject(externalProjectPath, importSpecBuilder.build());
    }

    public static void refreshProject(@NotNull String externalProjectPath, @NotNull ImportSpec importSpec) {
        if (externalProjectPath == null) {
            ExternalSystemUtil.$$$reportNull$$$0(23);
        }
        if (importSpec == null) {
            ExternalSystemUtil.$$$reportNull$$$0(24);
        }
        ExternalSystemUtil.refreshProjectImpl(Collections.singleton(externalProjectPath), importSpec);
    }

    private static void refreshProjectImpl(@NotNull Set<String> externalProjectPaths, @NotNull ImportSpec _importSpec) {
        if (externalProjectPaths == null) {
            ExternalSystemUtil.$$$reportNull$$$0(25);
        }
        if (_importSpec == null) {
            ExternalSystemUtil.$$$reportNull$$$0(26);
        }
        final ImportSpec importSpec = new ImportSpecBuilder(_importSpec).withPreviewMode(_importSpec.isPreviewMode() || !TrustedProjects.isProjectTrusted((Project)_importSpec.getProject())).build();
        final Project project = importSpec.getProject();
        final ProjectSystemId externalSystemId = importSpec.getExternalSystemId();
        boolean isPreviewMode = importSpec.isPreviewMode();
        ProgressExecutionMode progressExecutionMode = importSpec.getProgressExecutionMode();
        if (progressExecutionMode == ProgressExecutionMode.NO_PROGRESS_SYNC || progressExecutionMode == ProgressExecutionMode.NO_PROGRESS_ASYNC) {
            throw new IllegalArgumentException("Please, use progress for the project import!");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stated " + String.valueOf(externalSystemId) + " load", new Throwable());
        }
        TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        ApplicationManager.getApplication().invokeAndWait(() -> ((FileDocumentManager)FileDocumentManager.getInstance()).saveAllDocuments());
        ExternalSystemNotificationManager.getInstance(importSpec.getProject()).clearNotifications(null, NotificationSource.PROJECT_SYNC, importSpec.getExternalSystemId());
        AbstractExternalSystemLocalSettings localSettings = ExternalSystemApiUtil.getLocalSettings((Project)project, (ProjectSystemId)externalSystemId);
        for (final String externalProjectPath : externalProjectPaths) {
            Map projectSyncTypeStorage = localSettings.getProjectSyncType();
            AbstractExternalSystemLocalSettings.SyncType previousSyncType = (AbstractExternalSystemLocalSettings.SyncType)projectSyncTypeStorage.get(externalProjectPath);
            AbstractExternalSystemLocalSettings.SyncType syncType = isPreviewMode ? AbstractExternalSystemLocalSettings.SyncType.PREVIEW : (previousSyncType == AbstractExternalSystemLocalSettings.SyncType.PREVIEW ? AbstractExternalSystemLocalSettings.SyncType.IMPORT : AbstractExternalSystemLocalSettings.SyncType.RE_IMPORT);
            projectSyncTypeStorage.put(externalProjectPath, syncType);
            final ExternalSystemResolveProjectTask resolveProjectTask = new ExternalSystemResolveProjectTask(project, externalProjectPath, importSpec);
            final ExternalSystemTaskId taskId = resolveProjectTask.getId();
            String projectName = resolveProjectTask.getProjectName();
            String externalSystemName = externalSystemId.getReadableName();
            String title = progressExecutionMode == ProgressExecutionMode.MODAL_SYNC ? ExternalSystemBundle.message((String)"progress.import.text", (Object[])new Object[]{projectName, externalSystemName}) : ExternalSystemBundle.message((String)"progress.refresh.text", (Object[])new Object[]{projectName, externalSystemName});
            ExternalSystemTaskUnderProgress.executeTaskUnderProgress(project, title, progressExecutionMode, new ExternalSystemTaskUnderProgress(){

                @NotNull
                public ExternalSystemTaskId getId() {
                    ExternalSystemTaskId externalSystemTaskId = taskId;
                    if (externalSystemTaskId == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return externalSystemTaskId;
                }

                @Override
                public void execute(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    StructuredIdeActivity activity = ExternalSystemStatUtilKt.importActivityStarted(project, externalSystemId, null);
                    try {
                        ExternalSystemTelemetryUtil.runWithSpan(externalSystemId, "ExternalSystemSyncProjectTask", __ -> ExternalSystemUtil.executeSync(externalProjectPath, importSpec, resolveProjectTask, indicator));
                    }
                    finally {
                        activity.finished();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 2;
                        case 1 -> 3;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$2";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getId";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "execute";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalStateException(string);
                        case 1 -> new IllegalArgumentException(string);
                    };
                }
            });
        }
    }

    private static void executeSync(final @NotNull String externalProjectPath, final @NotNull ImportSpec importSpec, final @NotNull ExternalSystemResolveProjectTask resolveProjectTask, @NotNull ProgressIndicator indicator) {
        ExternalSystemProcessingManager processingManager;
        if (externalProjectPath == null) {
            ExternalSystemUtil.$$$reportNull$$$0(27);
        }
        if (importSpec == null) {
            ExternalSystemUtil.$$$reportNull$$$0(28);
        }
        if (resolveProjectTask == null) {
            ExternalSystemUtil.$$$reportNull$$$0(29);
        }
        if (indicator == null) {
            ExternalSystemUtil.$$$reportNull$$$0(30);
        }
        Project project = importSpec.getProject();
        ExternalSystemTaskId taskId = resolveProjectTask.getId();
        ProjectSystemId externalSystemId = taskId.getProjectSystemId();
        ExternalProjectRefreshCallback callback = importSpec.getCallback();
        final boolean isPreviewMode = importSpec.isPreviewMode();
        if (project.isDisposed()) {
            return;
        }
        if (indicator instanceof ProgressIndicatorEx) {
            ProgressIndicatorEx indicatorEx = (ProgressIndicatorEx)indicator;
            indicatorEx.addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                public void cancel() {
                    super.cancel();
                    resolveProjectTask.cancel(new ExternalSystemTaskNotificationListener[0]);
                }
            });
        }
        if ((processingManager = ExternalSystemProcessingManager.getInstance()).findTask(ExternalSystemTaskType.RESOLVE_PROJECT, externalSystemId, externalProjectPath) != null) {
            if (callback != null) {
                callback.onFailure(taskId, ExternalSystemBundle.message((String)"error.resolve.already.running", (Object[])new Object[]{externalProjectPath}), null);
            }
            return;
        }
        if (!isPreviewMode) {
            ExternalSystemTaskActivator externalSystemTaskActivator = ExternalProjectsManagerImpl.getInstance(project).getTaskActivator();
            if (!externalSystemTaskActivator.runTasks(externalProjectPath, ExternalSystemTaskActivator.Phase.BEFORE_SYNC)) {
                return;
            }
        }
        String projectName = resolveProjectTask.getProjectName();
        ExternalSystemProcessHandler processHandler = new ExternalSystemProcessHandler(resolveProjectTask, projectName + " import"){

            @Override
            protected void destroyProcessImpl() {
                resolveProjectTask.cancel(new ExternalSystemTaskNotificationListener[0]);
                this.closeInput();
            }
        };
        ExternalSystemExecutionConsoleManager<ExecutionConsole, ProcessHandler> consoleManager = ExternalSystemUtil.getConsoleManagerFor(resolveProjectTask);
        ExecutionConsole consoleView = consoleManager.attachExecutionConsole(project, (ExternalSystemTask)resolveProjectTask, null, (ProcessHandler)processHandler);
        Disposer.register((Disposable)project, (Disposable)Objects.requireNonNullElse(consoleView, processHandler));
        SyncViewManager syncViewManager = (SyncViewManager)project.getService(SyncViewManager.class);
        try (ExternalSystemEventDispatcher eventDispatcher = new ExternalSystemEventDispatcher(taskId, (BuildProgressListener)syncViewManager, false);){
            Ref finishSyncEventSupplier = new Ref();
            ExternalSystemTaskNotificationListener taskListener = new ExternalSystemTaskNotificationListener(){
                final /* synthetic */ 4 val$processHandler;
                final /* synthetic */ ExecutionConsole val$consoleView;
                final /* synthetic */ ExternalSystemExecutionConsoleManager val$consoleManager;
                final /* synthetic */ BuildEventDispatcher val$eventDispatcher;
                final /* synthetic */ Ref val$finishSyncEventSupplier;
                final /* synthetic */ ProjectSystemId val$externalSystemId;
                final /* synthetic */ String val$projectName;
                final /* synthetic */ SyncViewManager val$syncViewManager;
                final /* synthetic */ Project val$project;
                {
                    this.val$processHandler = var5_5;
                    this.val$consoleView = executionConsole;
                    this.val$consoleManager = externalSystemExecutionConsoleManager;
                    this.val$eventDispatcher = buildEventDispatcher;
                    this.val$finishSyncEventSupplier = ref;
                    this.val$externalSystemId = projectSystemId;
                    this.val$projectName = string2;
                    this.val$syncViewManager = syncViewManager;
                    this.val$project = project;
                }

                public void onStart(@NotNull String projectPath, @NotNull ExternalSystemTaskId id) {
                    if (projectPath == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (id == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    if (isPreviewMode) {
                        return;
                    }
                    DefaultBuildDescriptor buildDescriptor = ExternalSystemUtil.createSyncDescriptor(externalProjectPath, importSpec, resolveProjectTask, this.val$processHandler, this.val$consoleView, (ExternalSystemExecutionConsoleManager<ExecutionConsole, ProcessHandler>)this.val$consoleManager);
                    this.val$eventDispatcher.onEvent((Object)id, (BuildEvent)new StartBuildEventImpl((BuildDescriptor)buildDescriptor, BuildBundle.message((String)"build.event.message.syncing", (Object[])new Object[0])));
                }

                public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text, @NotNull ProcessOutputType processOutputType) {
                    if (id == null) {
                        5.$$$reportNull$$$0(2);
                    }
                    if (text == null) {
                        5.$$$reportNull$$$0(3);
                    }
                    if (processOutputType == null) {
                        5.$$$reportNull$$$0(4);
                    }
                    this.val$processHandler.notifyTextAvailable(text, (Key)processOutputType);
                    this.val$eventDispatcher.setStdOut(processOutputType.isStdout());
                    this.val$eventDispatcher.append((CharSequence)text);
                }

                public void onFailure(@NotNull String projectPath, @NotNull ExternalSystemTaskId id, @NotNull Exception exception) {
                    if (projectPath == null) {
                        5.$$$reportNull$$$0(5);
                    }
                    if (id == null) {
                        5.$$$reportNull$$$0(6);
                    }
                    if (exception == null) {
                        5.$$$reportNull$$$0(7);
                    }
                    this.val$finishSyncEventSupplier.set(() -> {
                        long eventTime = System.currentTimeMillis();
                        String eventMessage = BuildBundle.message((String)"build.status.failed", (Object[])new Object[0]);
                        String externalSystemName = this.val$externalSystemId.getReadableName();
                        String title = ExternalSystemBundle.message((String)"notification.project.refresh.fail.title", (Object[])new Object[]{externalSystemName, this.val$projectName});
                        DataContext dataContext = BuildConsoleUtils.getDataContext((Object)id, (AbstractViewManager)this.val$syncViewManager);
                        FailureResultImpl eventResult = ExternalSystemUtil.createFailureResult(title, exception, this.val$externalSystemId, this.val$project, externalProjectPath, dataContext);
                        return new FinishBuildEventImpl((Object)id, null, eventTime, eventMessage, (EventResult)eventResult);
                    });
                    this.val$processHandler.notifyProcessTerminated(1);
                }

                public void onCancel(@NotNull String projectPath, @NotNull ExternalSystemTaskId id) {
                    if (projectPath == null) {
                        5.$$$reportNull$$$0(8);
                    }
                    if (id == null) {
                        5.$$$reportNull$$$0(9);
                    }
                    this.val$finishSyncEventSupplier.set(() -> {
                        long eventTime = System.currentTimeMillis();
                        String eventMessage = BuildBundle.message((String)"build.status.cancelled", (Object[])new Object[0]);
                        FailureResultImpl eventResult = new FailureResultImpl();
                        return new FinishBuildEventImpl((Object)id, null, eventTime, eventMessage, (EventResult)eventResult);
                    });
                    this.val$processHandler.notifyProcessTerminated(1);
                }

                public void onSuccess(@NotNull String projectPath, @NotNull ExternalSystemTaskId id) {
                    if (projectPath == null) {
                        5.$$$reportNull$$$0(10);
                    }
                    if (id == null) {
                        5.$$$reportNull$$$0(11);
                    }
                    this.val$finishSyncEventSupplier.set(() -> {
                        long eventTime = System.currentTimeMillis();
                        String eventMessage = BuildBundle.message((String)"build.status.finished", (Object[])new Object[0]);
                        SuccessResultImpl eventResult = new SuccessResultImpl();
                        return new FinishBuildEventImpl((Object)id, null, eventTime, eventMessage, (EventResult)eventResult);
                    });
                    this.val$processHandler.notifyProcessTerminated(0);
                }

                public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                    if (event == null) {
                        5.$$$reportNull$$$0(12);
                    }
                    if (isPreviewMode) {
                        return;
                    }
                    if (event instanceof ExternalSystemBuildEvent) {
                        BuildEvent buildEvent = ((ExternalSystemBuildEvent)event).getBuildEvent();
                        this.val$eventDispatcher.onEvent((Object)event.getId(), buildEvent);
                    } else if (event instanceof ExternalSystemTaskExecutionEvent) {
                        BuildEvent buildEvent = ExternalSystemUtil.convert((ExternalSystemTaskExecutionEvent)event);
                        this.val$eventDispatcher.onEvent((Object)event.getId(), buildEvent);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "projectPath";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 6: 
                        case 9: 
                        case 11: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "id";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "text";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "processOutputType";
                            break;
                        }
                        case 7: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "exception";
                            break;
                        }
                        case 12: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$5";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onStart";
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTaskOutput";
                            break;
                        }
                        case 5: 
                        case 6: 
                        case 7: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onFailure";
                            break;
                        }
                        case 8: 
                        case 9: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onCancel";
                            break;
                        }
                        case 10: 
                        case 11: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onSuccess";
                            break;
                        }
                        case 12: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onStatusChange";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            ExternalSystemUtil.incompleteDependenciesState(project, (Object)resolveProjectTask, () -> ExternalSystemUtil.lambda$executeSync$1(externalProjectPath, resolveProjectTask, indicator, taskListener, externalSystemId, importSpec, eventDispatcher, finishSyncEventSupplier));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void incompleteDependenciesState(@NotNull Project project, @NotNull Object requestor, @NotNull Runnable runnable) {
        if (project == null) {
            ExternalSystemUtil.$$$reportNull$$$0(31);
        }
        if (requestor == null) {
            ExternalSystemUtil.$$$reportNull$$$0(32);
        }
        if (runnable == null) {
            ExternalSystemUtil.$$$reportNull$$$0(33);
        }
        if (!Registry.is((String)"external.system.incomplete.dependencies.state.during.sync")) {
            runnable.run();
        }
        IncompleteDependenciesService incompleteDependenciesService = (IncompleteDependenciesService)project.getService(IncompleteDependenciesService.class);
        IncompleteDependenciesService.IncompleteDependenciesAccessToken incompleteDependenciesAccessToken = (IncompleteDependenciesService.IncompleteDependenciesAccessToken)WriteAction.computeAndWait(() -> incompleteDependenciesService.enterIncompleteState(requestor));
        try {
            runnable.run();
        }
        finally {
            WriteAction.runAndWait(() -> incompleteDependenciesAccessToken.finish());
        }
    }

    @NotNull
    private static DefaultBuildDescriptor createSyncDescriptor(final @NotNull String externalProjectPath, final @NotNull ImportSpec importSpec, @NotNull ExternalSystemResolveProjectTask resolveProjectTask, final @NotNull ExternalSystemProcessHandler processHandler, @Nullable ExecutionConsole consoleView, @NotNull ExternalSystemExecutionConsoleManager<ExecutionConsole, ProcessHandler> consoleManager) {
        if (externalProjectPath == null) {
            ExternalSystemUtil.$$$reportNull$$$0(34);
        }
        if (importSpec == null) {
            ExternalSystemUtil.$$$reportNull$$$0(35);
        }
        if (resolveProjectTask == null) {
            ExternalSystemUtil.$$$reportNull$$$0(36);
        }
        if (processHandler == null) {
            ExternalSystemUtil.$$$reportNull$$$0(37);
        }
        if (consoleManager == null) {
            ExternalSystemUtil.$$$reportNull$$$0(38);
        }
        Project project = importSpec.getProject();
        ExternalSystemTaskId taskId = resolveProjectTask.getId();
        ProjectSystemId externalSystemId = taskId.getProjectSystemId();
        DumbAwareAction rerunImportAction = new DumbAwareAction(){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(processHandler.isProcessTerminated());
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    6.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(2);
                }
                e.getPresentation().setEnabled(false);
                Runnable rerunRunnable = importSpec.getRerunAction();
                if (rerunRunnable == null) {
                    ExternalSystemUtil.refreshProject(externalProjectPath, importSpec);
                } else {
                    rerunRunnable.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$6";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        String systemId = externalSystemId.getReadableName();
        rerunImportAction.getTemplatePresentation().setText(ExternalSystemBundle.messagePointer((String)"action.refresh.project.text", (Object[])new Object[]{systemId}));
        rerunImportAction.getTemplatePresentation().setDescription(ExternalSystemBundle.messagePointer((String)"action.refresh.project.description", (Object[])new Object[]{systemId}));
        rerunImportAction.getTemplatePresentation().setIcon(AllIcons.Actions.Refresh);
        String projectName = resolveProjectTask.getProjectName();
        DefaultBuildDescriptor defaultBuildDescriptor = new DefaultBuildDescriptor((Object)taskId, projectName, externalProjectPath, System.currentTimeMillis()).withProcessHandler((BuildProcessHandler)processHandler, null).withRestartAction((AnAction)rerunImportAction).withContentDescriptor(() -> {
            if (consoleView == null) {
                return null;
            }
            BuildContentDescriptor contentDescriptor = new BuildContentDescriptor(consoleView, (ProcessHandler)processHandler, consoleView.getComponent(), ExternalSystemBundle.message((String)"build.event.title.sync", (Object[])new Object[0]));
            contentDescriptor.setActivateToolWindowWhenAdded(importSpec.isActivateBuildToolWindowOnStart());
            contentDescriptor.setActivateToolWindowWhenFailed(importSpec.isActivateBuildToolWindowOnFailure());
            contentDescriptor.setNavigateToError(importSpec.isNavigateToError());
            contentDescriptor.setAutoFocusContent(importSpec.isActivateBuildToolWindowOnFailure());
            return contentDescriptor;
        }).withActions(consoleManager.getCustomActions(project, (ExternalSystemTask)resolveProjectTask, null)).withContextActions(consoleManager.getCustomContextActions(project, (ExternalSystemTask)resolveProjectTask, null)).withExecutionFilters(consoleManager.getCustomExecutionFilters(project, (ExternalSystemTask)resolveProjectTask, null));
        if (defaultBuildDescriptor == null) {
            ExternalSystemUtil.$$$reportNull$$$0(39);
        }
        return defaultBuildDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void handleSyncResult(@NotNull String externalProjectPath, @NotNull ImportSpec importSpec, @NotNull ExternalSystemResolveProjectTask resolveProjectTask, @NotNull BuildEventDispatcher eventDispatcher, @NotNull Ref<Supplier<? extends FinishBuildEvent>> finishSyncEventSupplier) {
        VirtualFile virtualFile;
        Throwable error;
        ExternalProjectRefreshCallback callback;
        boolean isPreviewMode;
        ProjectSystemId externalSystemId;
        ExternalSystemTaskId taskId;
        Project project;
        block26: {
            VirtualFile virtualFile2;
            block25: {
                VirtualFile virtualFile3;
                if (externalProjectPath == null) {
                    ExternalSystemUtil.$$$reportNull$$$0(40);
                }
                if (importSpec == null) {
                    ExternalSystemUtil.$$$reportNull$$$0(41);
                }
                if (resolveProjectTask == null) {
                    ExternalSystemUtil.$$$reportNull$$$0(42);
                }
                if (eventDispatcher == null) {
                    ExternalSystemUtil.$$$reportNull$$$0(43);
                }
                if (finishSyncEventSupplier == null) {
                    ExternalSystemUtil.$$$reportNull$$$0(44);
                }
                project = importSpec.getProject();
                taskId = resolveProjectTask.getId();
                externalSystemId = taskId.getProjectSystemId();
                isPreviewMode = importSpec.isPreviewMode();
                callback = importSpec.getCallback();
                if (project.isDisposed()) {
                    return;
                }
                error = resolveProjectTask.getError();
                if (error != null) break block25;
                ProjectDataManager projectDataManager = ProjectDataManager.getInstance();
                ExternalProjectInfo externalProjectData = projectDataManager.getExternalProjectData(project, externalSystemId, externalProjectPath);
                DataNode externalProject = (DataNode)ObjectUtils.doIfNotNull((Object)externalProjectData, it -> it.getExternalProjectStructure());
                if (externalProject != null) {
                    if (importSpec.shouldCreateDirectoriesForEmptyContentRoots()) {
                        externalProject.putUserData(ContentRootDataService.CREATE_EMPTY_DIRECTORIES, (Object)Boolean.TRUE);
                    }
                    if (importSpec.shouldImportProjectData()) {
                        if (importSpec.shouldSelectProjectDataToImport()) {
                            ExternalSystemUtil.selectProjectDataToImport(project, externalProjectData);
                        }
                        projectDataManager.importData(externalProject, project);
                    }
                }
                if (callback != null) {
                    callback.onSuccess(taskId, externalProject);
                }
                if (!isPreviewMode) {
                    ExternalSystemTaskActivator externalSystemTaskActivator = ExternalProjectsManagerImpl.getInstance(project).getTaskActivator();
                    externalSystemTaskActivator.runTasks(externalProjectPath, ExternalSystemTaskActivator.Phase.AFTER_SYNC);
                }
                if (isPreviewMode) return;
                if (ExternalSystemUtil.isNewProject(project) && (virtualFile3 = VfsUtil.findFileByIoFile((File)new File(externalProjectPath), (boolean)false)) != null) {
                    VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile3});
                }
                project.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, null);
                project.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, null);
                project.putUserData(ExternalSystemDataKeys.NEWLY_OPENED_PROJECT_WITH_IDE_CACHES, null);
                eventDispatcher.onEvent((Object)taskId, (BuildEvent)ExternalSystemUtil.getSyncFinishEvent(taskId, finishSyncEventSupplier));
                return;
            }
            if (!(error instanceof ImportCanceledException)) break block26;
            if (isPreviewMode) return;
            if (ExternalSystemUtil.isNewProject(project) && (virtualFile2 = VfsUtil.findFileByIoFile((File)new File(externalProjectPath), (boolean)false)) != null) {
                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile2});
            }
            project.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, null);
            project.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, null);
            project.putUserData(ExternalSystemDataKeys.NEWLY_OPENED_PROJECT_WITH_IDE_CACHES, null);
            eventDispatcher.onEvent((Object)taskId, (BuildEvent)ExternalSystemUtil.getSyncFinishEvent(taskId, finishSyncEventSupplier));
            return;
        }
        try {
            if (callback != null) {
                String message = ExternalSystemApiUtil.buildErrorMessage((Throwable)error);
                if (StringUtil.isEmpty((String)message)) {
                    String systemName = externalSystemId.getReadableName();
                    message = String.format("Can't resolve %s project at '%s'. Reason: %s", systemName, externalProjectPath, message);
                }
                callback.onFailure(taskId, message, ExternalSystemUtil.extractDetails(error));
            }
            if (isPreviewMode) return;
        }
        catch (Throwable t) {
            VirtualFile virtualFile4;
            try {
                finishSyncEventSupplier.set(() -> {
                    long eventTime = System.currentTimeMillis();
                    String eventMessage = BuildBundle.message((String)"build.status.failed", (Object[])new Object[0]);
                    String systemName = externalSystemId.getReadableName();
                    String projectName = resolveProjectTask.getProjectName();
                    String title = ExternalSystemBundle.message((String)"notification.project.refresh.fail.title", (Object[])new Object[]{systemName, projectName});
                    FailureResultImpl eventResult = ExternalSystemUtil.createFailureResult(title, t, externalSystemId, project, externalProjectPath, DataContext.EMPTY_CONTEXT);
                    return new FinishBuildEventImpl((Object)taskId, null, eventTime, eventMessage, (EventResult)eventResult);
                });
                if (isPreviewMode) return;
            }
            catch (Throwable throwable) {
                VirtualFile virtualFile5;
                if (isPreviewMode) throw throwable;
                if (ExternalSystemUtil.isNewProject(project) && (virtualFile5 = VfsUtil.findFileByIoFile((File)new File(externalProjectPath), (boolean)false)) != null) {
                    VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile5});
                }
                project.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, null);
                project.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, null);
                project.putUserData(ExternalSystemDataKeys.NEWLY_OPENED_PROJECT_WITH_IDE_CACHES, null);
                eventDispatcher.onEvent((Object)taskId, (BuildEvent)ExternalSystemUtil.getSyncFinishEvent(taskId, finishSyncEventSupplier));
                throw throwable;
            }
            if (ExternalSystemUtil.isNewProject(project) && (virtualFile4 = VfsUtil.findFileByIoFile((File)new File(externalProjectPath), (boolean)false)) != null) {
                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile4});
            }
            project.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, null);
            project.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, null);
            project.putUserData(ExternalSystemDataKeys.NEWLY_OPENED_PROJECT_WITH_IDE_CACHES, null);
            eventDispatcher.onEvent((Object)taskId, (BuildEvent)ExternalSystemUtil.getSyncFinishEvent(taskId, finishSyncEventSupplier));
            return;
        }
        if (ExternalSystemUtil.isNewProject(project) && (virtualFile = VfsUtil.findFileByIoFile((File)new File(externalProjectPath), (boolean)false)) != null) {
            VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile});
        }
        project.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, null);
        project.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, null);
        project.putUserData(ExternalSystemDataKeys.NEWLY_OPENED_PROJECT_WITH_IDE_CACHES, null);
        eventDispatcher.onEvent((Object)taskId, (BuildEvent)ExternalSystemUtil.getSyncFinishEvent(taskId, finishSyncEventSupplier));
        return;
    }

    private static void selectProjectDataToImport(@NotNull Project project, @NotNull ExternalProjectInfo projectInfo) {
        Application application;
        if (project == null) {
            ExternalSystemUtil.$$$reportNull$$$0(45);
        }
        if (projectInfo == null) {
            ExternalSystemUtil.$$$reportNull$$$0(46);
        }
        if (!(application = ApplicationManager.getApplication()).isHeadlessEnvironment()) {
            application.invokeAndWait(() -> {
                ExternalProjectDataSelectorDialog dialog = new ExternalProjectDataSelectorDialog(project, projectInfo);
                if (dialog.hasMultipleDataToSelect()) {
                    dialog.showAndGet();
                } else {
                    Disposer.dispose((Disposable)dialog.getDisposable());
                }
            });
        }
    }

    @NotNull
    private static FinishBuildEvent getSyncFinishEvent(@NotNull ExternalSystemTaskId taskId, @NotNull Ref<? extends Supplier<? extends FinishBuildEvent>> finishSyncEventSupplier) {
        if (taskId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(47);
        }
        if (finishSyncEventSupplier == null) {
            ExternalSystemUtil.$$$reportNull$$$0(48);
        }
        Exception exception = null;
        Supplier finishBuildEventSupplier = (Supplier)finishSyncEventSupplier.get();
        if (finishBuildEventSupplier != null) {
            FinishBuildEvent finishBuildEvent;
            try {
                finishBuildEvent = (FinishBuildEvent)finishBuildEventSupplier.get();
            }
            catch (Exception e) {
                exception = e;
            }
            if (finishBuildEvent == null) {
                ExternalSystemUtil.$$$reportNull$$$0(49);
            }
            return finishBuildEvent;
        }
        if (!(exception instanceof ControlFlowException)) {
            LOG.warn("Sync finish event has not been received", (Throwable)exception);
        }
        long eventTime = System.currentTimeMillis();
        String eventMessage = BuildBundle.message((String)"build.status.cancelled", (Object[])new Object[0]);
        FailureResultImpl eventResult = new FailureResultImpl();
        return new FinishBuildEventImpl((Object)taskId, null, eventTime, eventMessage, (EventResult)eventResult);
    }

    @Deprecated
    public static boolean confirmLoadingUntrustedProject(@NotNull Project project, @NotNull ProjectSystemId systemId) {
        if (project == null) {
            ExternalSystemUtil.$$$reportNull$$$0(50);
        }
        if (systemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(51);
        }
        return ExternalSystemTrustedProjectDialog.confirmLoadingUntrustedProject(project, systemId);
    }

    @NotNull
    @Nls
    public static String naturalJoinSystemIds(@NotNull Collection<ProjectSystemId> systemIds) {
        if (systemIds == null) {
            ExternalSystemUtil.$$$reportNull$$$0(52);
        }
        String string = (String)new HashSet<ProjectSystemId>(systemIds).stream().map(it -> it.getReadableName()).sorted(NaturalComparator.INSTANCE).collect(NlsMessages.joiningAnd());
        if (string == null) {
            ExternalSystemUtil.$$$reportNull$$$0(53);
        }
        return string;
    }

    public static boolean isNewProject(Project project) {
        return project.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT) == Boolean.TRUE || project.getUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT) == Boolean.TRUE;
    }

    @ApiStatus.Internal
    public static void configureNewModule(@NotNull Module module, boolean isCreatingNewProject, boolean isMavenModule) {
        if (module == null) {
            ExternalSystemUtil.$$$reportNull$$$0(54);
        }
        Project project = module.getProject();
        project.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, (Object)(isCreatingNewProject ? Boolean.TRUE : null));
        project.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)(isCreatingNewProject ? Boolean.TRUE : null));
        ExternalSystemUtil.markModuleAsMaven(module, null, isMavenModule);
    }

    @ApiStatus.Internal
    public static void markModuleAsMaven(@NotNull Module module, @Nullable String moduleVersion, boolean isMavenModule) {
        if (module == null) {
            ExternalSystemUtil.$$$reportNull$$$0(55);
        }
        ExternalSystemModulePropertyManager.getInstance((Module)module).setMavenized(isMavenModule, moduleVersion);
    }

    @ApiStatus.Internal
    @NotNull
    public static FailureResultImpl createFailureResult(@NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String title, @NotNull Throwable exception, @NotNull ProjectSystemId externalSystemId, @NotNull Project project, @NotNull String externalProjectPath, @NotNull DataContext dataContext) {
        if (title == null) {
            ExternalSystemUtil.$$$reportNull$$$0(56);
        }
        if (exception == null) {
            ExternalSystemUtil.$$$reportNull$$$0(57);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(58);
        }
        if (project == null) {
            ExternalSystemUtil.$$$reportNull$$$0(59);
        }
        if (externalProjectPath == null) {
            ExternalSystemUtil.$$$reportNull$$$0(60);
        }
        if (dataContext == null) {
            ExternalSystemUtil.$$$reportNull$$$0(61);
        }
        ExternalSystemNotificationManager notificationManager = ExternalSystemNotificationManager.getInstance(project);
        NotificationData notificationData = ExternalSystemNotificationManager.createNotification(title, exception, externalSystemId, project, externalProjectPath, dataContext);
        if (notificationData == null) {
            return new FailureResultImpl();
        }
        return ExternalSystemUtil.createFailureResult(exception, externalSystemId, project, notificationManager, notificationData);
    }

    @NotNull
    private static FailureResultImpl createFailureResult(@NotNull Throwable exception, @NotNull ProjectSystemId externalSystemId, @NotNull Project project, @NotNull ExternalSystemNotificationManager notificationManager, @NotNull NotificationData notificationData) {
        FailureImpl failure;
        Navigatable buildIssueNavigatable;
        ExternalProjectsView externalProjectsView;
        if (exception == null) {
            ExternalSystemUtil.$$$reportNull$$$0(62);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(63);
        }
        if (project == null) {
            ExternalSystemUtil.$$$reportNull$$$0(64);
        }
        if (notificationManager == null) {
            ExternalSystemUtil.$$$reportNull$$$0(65);
        }
        if (notificationData == null) {
            ExternalSystemUtil.$$$reportNull$$$0(66);
        }
        if (notificationData.isBalloonNotification()) {
            notificationManager.showNotification(externalSystemId, notificationData);
            return new FailureResultImpl(exception);
        }
        NotificationGroup group = notificationData.getBalloonGroup() == null ? ((externalProjectsView = ExternalProjectsManagerImpl.getInstance(project).getExternalProjectsView(externalSystemId)) instanceof ExternalProjectsViewImpl ? ((ExternalProjectsViewImpl)externalProjectsView).getNotificationGroup() : null) : notificationData.getBalloonGroup();
        int line = notificationData.getLine() - 1;
        int column2 = notificationData.getColumn() - 1;
        VirtualFile virtualFile = notificationData.getFilePath() != null ? ExternalSystemUtil.findLocalFileByPath(notificationData.getFilePath()) : null;
        Navigatable navigatable = buildIssueNavigatable = exception instanceof BuildIssueException ? ((BuildIssueException)((Object)exception)).getBuildIssue().getNavigatable(project) : null;
        Object navigatable2 = !ExternalSystemUtil.isNullOrNonNavigatable(buildIssueNavigatable) ? buildIssueNavigatable : (ExternalSystemUtil.isNullOrNonNavigatable(notificationData.getNavigatable()) ? (virtualFile != null ? new OpenFileDescriptor(project, virtualFile, line, column2) : NonNavigatable.INSTANCE) : notificationData.getNavigatable());
        Notification notification = group == null ? new Notification(externalSystemId.getReadableName() + " build", notificationData.getTitle(), notificationData.getMessage(), notificationData.getNotificationCategory().getNotificationType()).setListener(notificationData.getListener()) : group.createNotification(notificationData.getTitle(), notificationData.getMessage(), notificationData.getNotificationCategory().getNotificationType()).setListener(notificationData.getListener());
        if (exception instanceof BuildIssueException) {
            BuildIssue buildIssue = ((BuildIssueException)((Object)exception)).getBuildIssue();
            failure = new FailureImpl(buildIssue.getTitle(), notificationData.getMessage(), Collections.emptyList(), exception, notification, navigatable2);
        } else {
            failure = new FailureImpl(notificationData.getMessage(), exception, notification, navigatable2);
        }
        return new FailureResultImpl(Collections.singletonList(failure));
    }

    private static boolean isNullOrNonNavigatable(@Nullable Navigatable navigatable) {
        return navigatable == null || navigatable == NonNavigatable.INSTANCE;
    }

    @NotNull
    public static BuildEvent convert(@NotNull ExternalSystemTaskExecutionEvent event) {
        BuildEvent buildEvent;
        if (event == null) {
            ExternalSystemUtil.$$$reportNull$$$0(67);
        }
        if ((buildEvent = ExternalSystemProgressEventConverter.convertBuildEvent(event)) == null) {
            return new OutputBuildEventImpl((Object)event.getProgressEvent().getEventId(), ObjectUtils.chooseNotNull((Object)event.getProgressEvent().getParentEventId(), (Object)event.getId()), event.getProgressEvent().getDescriptor().getDisplayName(), true);
        }
        BuildEvent buildEvent2 = buildEvent;
        if (buildEvent2 == null) {
            ExternalSystemUtil.$$$reportNull$$$0(68);
        }
        return buildEvent2;
    }

    @ApiStatus.Obsolete
    public static void runTask(@NotNull ExternalSystemTaskExecutionSettings taskSettings, @NotNull String executorId, @NotNull Project project, @NotNull ProjectSystemId externalSystemId) {
        if (taskSettings == null) {
            ExternalSystemUtil.$$$reportNull$$$0(69);
        }
        if (executorId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(70);
        }
        if (project == null) {
            ExternalSystemUtil.$$$reportNull$$$0(71);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(72);
        }
        ExternalSystemUtil.runTask(taskSettings, executorId, project, externalSystemId, null, ProgressExecutionMode.IN_BACKGROUND_ASYNC);
    }

    @ApiStatus.Obsolete
    public static void runTask(@NotNull ExternalSystemTaskExecutionSettings taskSettings, @NotNull String executorId, @NotNull Project project, @NotNull ProjectSystemId externalSystemId, @Nullable TaskCallback callback, @NotNull ProgressExecutionMode progressExecutionMode) {
        if (taskSettings == null) {
            ExternalSystemUtil.$$$reportNull$$$0(73);
        }
        if (executorId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(74);
        }
        if (project == null) {
            ExternalSystemUtil.$$$reportNull$$$0(75);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(76);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.$$$reportNull$$$0(77);
        }
        ExternalSystemUtil.runTask(taskSettings, executorId, project, externalSystemId, callback, progressExecutionMode, true);
    }

    @ApiStatus.Obsolete
    public static void runTask(@NotNull ExternalSystemTaskExecutionSettings taskSettings, @NotNull String executorId, @NotNull Project project, @NotNull ProjectSystemId externalSystemId, @Nullable TaskCallback callback, @NotNull ProgressExecutionMode progressExecutionMode, boolean activateToolWindowBeforeRun) {
        if (taskSettings == null) {
            ExternalSystemUtil.$$$reportNull$$$0(78);
        }
        if (executorId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(79);
        }
        if (project == null) {
            ExternalSystemUtil.$$$reportNull$$$0(80);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(81);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.$$$reportNull$$$0(82);
        }
        ExternalSystemUtil.runTask(taskSettings, executorId, project, externalSystemId, callback, progressExecutionMode, activateToolWindowBeforeRun, null);
    }

    @ApiStatus.Obsolete
    public static void runTask(@NotNull ExternalSystemTaskExecutionSettings taskSettings, @NotNull String executorId, @NotNull Project project, @NotNull ProjectSystemId externalSystemId, @Nullable TaskCallback callback, @NotNull ProgressExecutionMode progressExecutionMode, boolean activateToolWindowBeforeRun, @Nullable UserDataHolderBase userData) {
        if (taskSettings == null) {
            ExternalSystemUtil.$$$reportNull$$$0(83);
        }
        if (executorId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(84);
        }
        if (project == null) {
            ExternalSystemUtil.$$$reportNull$$$0(85);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(86);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.$$$reportNull$$$0(87);
        }
        TaskExecutionSpec spec = TaskExecutionSpec.create().withProject(project).withSystemId(externalSystemId).withExecutorId(executorId).withSettings(taskSettings).withProgressExecutionMode(progressExecutionMode).withCallback(callback).withUserData(userData).withActivateToolWindowBeforeRun(activateToolWindowBeforeRun).build();
        ExternalSystemUtil.runTask(spec);
    }

    public static void runTask(final @NotNull TaskExecutionSpec spec) {
        ProjectSystemId externalSystemId;
        Project project;
        ExecutionEnvironment environment;
        if (spec == null) {
            ExternalSystemUtil.$$$reportNull$$$0(88);
        }
        if ((environment = ExternalSystemUtil.createExecutionEnvironment(project = spec.getProject(), externalSystemId = spec.getSystemId(), spec.getSettings(), spec.getExecutorId())) == null) {
            LOG.warn("Execution environment for " + String.valueOf(externalSystemId) + " is null");
            return;
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = environment.getRunnerAndConfigurationSettings();
        assert (runnerAndConfigurationSettings != null);
        runnerAndConfigurationSettings.setActivateToolWindowBeforeRun(spec.getActivateToolWindowBeforeRun());
        UserDataHolderBase userData = spec.getUserData();
        if (userData != null) {
            ExternalSystemRunConfiguration runConfiguration = (ExternalSystemRunConfiguration)runnerAndConfigurationSettings.getConfiguration();
            userData.copyUserDataTo((UserDataHolderBase)runConfiguration);
        }
        String title = AbstractExternalSystemTaskConfigurationType.generateName(project, spec.getSettings());
        ExternalSystemTaskUnderProgress.executeTaskUnderProgress(project, title, spec.getProgressExecutionMode(), new ExternalSystemTaskUnderProgress(){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    7.$$$reportNull$$$0(0);
                }
                environment.putUserData(ExternalSystemRunnableState.PROGRESS_INDICATOR_KEY, (Object)indicator);
                environment.putUserData(ExternalSystemRunnableState.TASK_NOTIFICATION_LISTENER_KEY, (Object)spec.getListener());
                environment.putUserData(ExternalSystemRunnableState.NAVIGATE_TO_ERROR_KEY, (Object)spec.getNavigateToError());
                indicator.setIndeterminate(true);
                boolean result = ExternalSystemUtil.waitForProcessExecution(project, environment, (ThrowableRunnable<ExecutionException>)((ThrowableRunnable)() -> environment.getRunner().execute(environment)));
                TaskCallback callback = spec.getCallback();
                if (callback != null) {
                    if (result) {
                        callback.onSuccess();
                    } else {
                        callback.onFailure();
                    }
                }
                if (!result && spec.getActivateToolWindowOnFailure()) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(environment.getExecutor().getToolWindowId());
                        if (window != null) {
                            window.activate(null, false, false);
                        }
                    }, project.getDisposed());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$7", "execute"));
            }
        });
    }

    @Nullable
    public static ExecutionEnvironment createExecutionEnvironment(@NotNull Project project, @NotNull ProjectSystemId externalSystemId, @NotNull ExternalSystemTaskExecutionSettings taskSettings, @NotNull String executorId) {
        Executor executor;
        if (project == null) {
            ExternalSystemUtil.$$$reportNull$$$0(89);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(90);
        }
        if (taskSettings == null) {
            ExternalSystemUtil.$$$reportNull$$$0(91);
        }
        if (executorId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(92);
        }
        if ((executor = ExecutorRegistry.getInstance().getExecutorById(executorId)) == null) {
            return null;
        }
        String runnerId = ExternalSystemUtil.getRunnerId(executorId);
        if (runnerId == null) {
            return null;
        }
        ProgramRunner runner = ProgramRunner.findRunnerById((String)runnerId);
        if (runner == null) {
            return null;
        }
        RunnerAndConfigurationSettings settings = ExternalSystemUtil.createExternalSystemRunnerAndConfigurationSettings(taskSettings, project, externalSystemId);
        if (settings == null) {
            return null;
        }
        return new ExecutionEnvironment(executor, runner, settings, project);
    }

    @Nullable
    public static RunnerAndConfigurationSettings createExternalSystemRunnerAndConfigurationSettings(@NotNull ExternalSystemTaskExecutionSettings taskSettings, @NotNull Project project, @NotNull ProjectSystemId externalSystemId) {
        AbstractExternalSystemTaskConfigurationType configurationType;
        if (taskSettings == null) {
            ExternalSystemUtil.$$$reportNull$$$0(93);
        }
        if (project == null) {
            ExternalSystemUtil.$$$reportNull$$$0(94);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(95);
        }
        if ((configurationType = ExternalSystemUtil.findConfigurationType(externalSystemId)) == null) {
            return null;
        }
        String name = AbstractExternalSystemTaskConfigurationType.generateName(project, taskSettings);
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)project).createConfiguration(name, configurationType.getFactory());
        ((ExternalSystemRunConfiguration)settings.getConfiguration()).getSettings().setFrom(taskSettings);
        return settings;
    }

    @Nullable
    public static AbstractExternalSystemTaskConfigurationType findConfigurationType(@NotNull ProjectSystemId externalSystemId) {
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(96);
        }
        for (ConfigurationType type : ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList()) {
            AbstractExternalSystemTaskConfigurationType candidate;
            if (!(type instanceof AbstractExternalSystemTaskConfigurationType) || !externalSystemId.equals((Object)(candidate = (AbstractExternalSystemTaskConfigurationType)type).getExternalSystemId())) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    public static String getRunnerId(@NotNull String executorId) {
        if (executorId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(97);
        }
        return RUNNER_IDS.get(executorId);
    }

    public static void registerRunnerId(@NotNull String executorId, @NotNull String externalSystemRunnerId) {
        if (executorId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(98);
        }
        if (externalSystemRunnerId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(99);
        }
        if (RUNNER_IDS.containsKey(executorId)) {
            throw new ExternalSystemException("Executor with ID " + executorId + " is already registered");
        }
        RUNNER_IDS.put(executorId, externalSystemRunnerId);
    }

    @Deprecated
    public static void linkExternalProject(@NotNull ProjectSystemId externalSystemId, @NotNull ExternalProjectSettings projectSettings, @NotNull Project project, @Nullable Consumer<? super Boolean> importResultCallback, boolean isPreviewMode, @NotNull ProgressExecutionMode progressExecutionMode) {
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(100);
        }
        if (projectSettings == null) {
            ExternalSystemUtil.$$$reportNull$$$0(101);
        }
        if (project == null) {
            ExternalSystemUtil.$$$reportNull$$$0(102);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.$$$reportNull$$$0(103);
        }
        ImportSpecBuilder builder = new ImportSpecBuilder(project, externalSystemId).use(progressExecutionMode).withPreviewMode(isPreviewMode).withCallback(it -> {
            if (importResultCallback != null) {
                importResultCallback.accept(it);
            }
        });
        ExternalSystemUtil.linkExternalProject(projectSettings, builder);
    }

    public static void linkExternalProject(@NotNull ExternalProjectSettings projectSettings, @NotNull ImportSpecBuilder importSpec) {
        if (projectSettings == null) {
            ExternalSystemUtil.$$$reportNull$$$0(104);
        }
        if (importSpec == null) {
            ExternalSystemUtil.$$$reportNull$$$0(105);
        }
        ExternalSystemUtil.linkExternalProject(projectSettings, importSpec.build());
    }

    public static void linkExternalProject(@NotNull ExternalProjectSettings projectSettings, @NotNull ImportSpec importSpec) {
        if (projectSettings == null) {
            ExternalSystemUtil.$$$reportNull$$$0(106);
        }
        if (importSpec == null) {
            ExternalSystemUtil.$$$reportNull$$$0(107);
        }
        TrackingUtil.trackActivity((Project)importSpec.getProject(), (ActivityKey)ExternalSystemActivityKey.INSTANCE, () -> {
            AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings((Project)importSpec.getProject(), (ProjectSystemId)importSpec.getExternalSystemId());
            ExternalProjectSettings existingSettings = systemSettings.getLinkedProjectSettings(projectSettings.getExternalProjectPath());
            if (existingSettings != null) {
                return;
            }
            systemSettings.linkProject(projectSettings);
            if (!Registry.is((String)"external.system.auto.import.disabled")) {
                ExternalProjectsManager.getInstance((Project)importSpec.getProject()).runWhenInitialized(() -> ExternalSystemUtil.refreshProject(projectSettings.getExternalProjectPath(), new ImportSpecBuilder(importSpec).withSelectProjectDataToImport(systemSettings.showSelectiveImportDialogOnInitialImport())));
            }
        });
    }

    @Nullable
    public static VirtualFile refreshAndFindFileByIoFile(@NotNull File file) {
        Application app;
        if (file == null) {
            ExternalSystemUtil.$$$reportNull$$$0(108);
        }
        if (!(app = ApplicationManager.getApplication()).isDispatchThread()) assert (!app.holdsReadLock());
        return LocalFileSystem.getInstance().refreshAndFindFileByNioFile(file.toPath());
    }

    @Nullable
    public static VirtualFile findLocalFileByPath(String path) {
        Application application = ApplicationManager.getApplication();
        if (!application.isDispatchThread() && application.isReadAccessAllowed()) {
            return StandardFileSystems.local().findFileByPath(path);
        }
        return StandardFileSystems.local().refreshAndFindFileByPath(path);
    }

    public static void scheduleExternalViewStructureUpdate(@NotNull Project project, @NotNull ProjectSystemId systemId) {
        ExternalProjectsView externalProjectsView;
        if (project == null) {
            ExternalSystemUtil.$$$reportNull$$$0(109);
        }
        if (systemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(110);
        }
        if ((externalProjectsView = ExternalProjectsManagerImpl.getInstance(project).getExternalProjectsView(systemId)) instanceof ExternalProjectsViewImpl) {
            ExternalProjectsViewImpl externalProjectsViewImpl = (ExternalProjectsViewImpl)externalProjectsView;
            externalProjectsViewImpl.scheduleStructureUpdate();
        }
    }

    @Nullable
    public static ExternalProjectInfo getExternalProjectInfo(@NotNull Project project, @NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        ExternalProjectSettings linkedProjectSettings;
        if (project == null) {
            ExternalSystemUtil.$$$reportNull$$$0(111);
        }
        if (projectSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(112);
        }
        if (externalProjectPath == null) {
            ExternalSystemUtil.$$$reportNull$$$0(113);
        }
        if ((linkedProjectSettings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)projectSystemId).getLinkedProjectSettings(externalProjectPath)) == null) {
            return null;
        }
        return ProjectDataManagerImpl.getInstance().getExternalProjectData(project, projectSystemId, linkedProjectSettings.getExternalProjectPath());
    }

    @NotNull
    public static ExternalSystemExecutionConsoleManager<ExecutionConsole, ProcessHandler> getConsoleManagerFor(@NotNull ExternalSystemTask task) {
        if (task == null) {
            ExternalSystemUtil.$$$reportNull$$$0(114);
        }
        for (ExternalSystemExecutionConsoleManager executionConsoleManager : (ExternalSystemExecutionConsoleManager[])ExternalSystemExecutionConsoleManager.EP_NAME.getExtensions()) {
            if (!executionConsoleManager.isApplicableFor(task)) continue;
            ExternalSystemExecutionConsoleManager externalSystemExecutionConsoleManager = executionConsoleManager;
            if (externalSystemExecutionConsoleManager == null) {
                ExternalSystemUtil.$$$reportNull$$$0(115);
            }
            return externalSystemExecutionConsoleManager;
        }
        return new DefaultExternalSystemExecutionConsoleManager();
    }

    public static void invokeLater(Project p, Runnable r) {
        ExternalSystemUtil.invokeLater(p, ModalityState.defaultModalityState(), r);
    }

    public static void invokeLater(Project p, ModalityState state, Runnable r) {
        if (ExternalSystemUtil.isNoBackgroundMode()) {
            r.run();
        } else {
            ApplicationManager.getApplication().invokeLater(r, state, p.getDisposed());
        }
    }

    public static boolean isNoBackgroundMode() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment() && !PlatformUtils.isFleetBackend();
    }

    @ApiStatus.Internal
    public static CompletableFuture<Void> requestImport(@NotNull Project project, @NotNull String projectPath, @NotNull ProjectSystemId systemId) {
        if (project == null) {
            ExternalSystemUtil.$$$reportNull$$$0(116);
        }
        if (projectPath == null) {
            ExternalSystemUtil.$$$reportNull$$$0(117);
        }
        if (systemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(118);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        ImportSpecBuilder builder = new ImportSpecBuilder(project, systemId).withCallback(future);
        ExternalSystemUtil.refreshProject(projectPath, builder.build());
        return future;
    }

    @RequiresBackgroundThread
    private static boolean waitForProcessExecution(@NotNull Project project, final @NotNull ExecutionEnvironment environment, @NotNull ThrowableRunnable<ExecutionException> runnable) {
        if (project == null) {
            ExternalSystemUtil.$$$reportNull$$$0(119);
        }
        if (environment == null) {
            ExternalSystemUtil.$$$reportNull$$$0(120);
        }
        if (runnable == null) {
            ExternalSystemUtil.$$$reportNull$$$0(121);
        }
        ThreadingAssertions.assertBackgroundThread();
        try (AutoCloseableDisposable disposable = new AutoCloseableDisposable();){
            final Semaphore targetDone = new Semaphore();
            final Ref result = new Ref((Object)false);
            final String executorId = environment.getExecutor().getId();
            project.getMessageBus().connect((Disposable)disposable).subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

                public void processStartScheduled(@NotNull String executorIdLocal, @NotNull ExecutionEnvironment environmentLocal) {
                    if (executorIdLocal == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    if (environmentLocal == null) {
                        8.$$$reportNull$$$0(1);
                    }
                    if (executorId.equals(executorIdLocal) && environment.equals(environmentLocal)) {
                        targetDone.down();
                    }
                }

                public void processNotStarted(@NotNull String executorIdLocal, @NotNull ExecutionEnvironment environmentLocal) {
                    if (executorIdLocal == null) {
                        8.$$$reportNull$$$0(2);
                    }
                    if (environmentLocal == null) {
                        8.$$$reportNull$$$0(3);
                    }
                    if (executorId.equals(executorIdLocal) && environment.equals(environmentLocal)) {
                        targetDone.up();
                    }
                }

                public void processTerminated(@NotNull String executorIdLocal, @NotNull ExecutionEnvironment environmentLocal, @NotNull ProcessHandler handler, int exitCode) {
                    if (executorIdLocal == null) {
                        8.$$$reportNull$$$0(4);
                    }
                    if (environmentLocal == null) {
                        8.$$$reportNull$$$0(5);
                    }
                    if (handler == null) {
                        8.$$$reportNull$$$0(6);
                    }
                    if (executorId.equals(executorIdLocal) && environment.equals(environmentLocal)) {
                        result.set((Object)(exitCode == 0 ? 1 : 0));
                        targetDone.up();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "executorIdLocal";
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "environmentLocal";
                            break;
                        }
                        case 6: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "handler";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$8";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processStartScheduled";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processNotStarted";
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 6: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            try {
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    try {
                        runnable.run();
                    }
                    catch (ExecutionException e) {
                        targetDone.up();
                        LOG.error((Throwable)e);
                    }
                }, ModalityState.defaultModalityState());
            }
            catch (Exception e) {
                targetDone.up();
                LOG.error((Throwable)e);
            }
            targetDone.waitFor();
            boolean bl = (Boolean)result.get();
            return bl;
        }
    }

    private static /* synthetic */ void lambda$executeSync$1(String externalProjectPath, ExternalSystemResolveProjectTask resolveProjectTask, ProgressIndicator indicator, 5 taskListener, ProjectSystemId externalSystemId, ImportSpec importSpec, BuildEventDispatcher eventDispatcher, Ref finishSyncEventSupplier) {
        LOG.info("External project [" + externalProjectPath + "] resolution task started");
        long startTS = System.currentTimeMillis();
        resolveProjectTask.execute(indicator, taskListener);
        long endTS = System.currentTimeMillis();
        LOG.info("External project [" + externalProjectPath + "] resolution task executed in " + (endTS - startTS) + " ms.");
        ExternalSystemTelemetryUtil.runWithSpan(externalSystemId, "ExternalSystemSyncResultProcessing", ignore -> ExternalSystemUtil.handleSyncResult(externalProjectPath, importSpec, resolveProjectTask, eventDispatcher, (Ref<Supplier<? extends FinishBuildEvent>>)finishSyncEventSupplier));
    }

    static {
        RUNNER_IDS.put("Run", "ExternalSystemTaskRunner");
        String debugExecutorId = "Debug";
        RUNNER_IDS.put(debugExecutorId, "ExternalSystemTaskDebugRunner");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 39, 49, 53, 68, 115 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 12: 
            case 17: 
            case 58: 
            case 63: 
            case 72: 
            case 76: 
            case 81: 
            case 86: 
            case 90: 
            case 95: 
            case 96: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specBuilder";
                break;
            }
            case 3: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 6: 
            case 39: 
            case 49: 
            case 53: 
            case 68: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/util/ExternalSystemUtil";
                break;
            }
            case 9: 
            case 13: 
            case 18: 
            case 21: 
            case 23: 
            case 27: 
            case 34: 
            case 40: 
            case 60: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 10: 
            case 15: 
            case 20: 
            case 77: 
            case 82: 
            case 87: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressExecutionMode";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSpecBuilder";
                break;
            }
            case 24: 
            case 28: 
            case 35: 
            case 41: 
            case 105: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSpec";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPaths";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_importSpec";
                break;
            }
            case 29: 
            case 36: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveProjectTask";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 33: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleManager";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventDispatcher";
                break;
            }
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finishSyncEventSupplier";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectInfo";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskId";
                break;
            }
            case 51: 
            case 110: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemIds";
                break;
            }
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 57: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationManager";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationData";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 69: 
            case 73: 
            case 78: 
            case 83: 
            case 91: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskSettings";
                break;
            }
            case 70: 
            case 74: 
            case 79: 
            case 84: 
            case 92: 
            case 97: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemRunnerId";
                break;
            }
            case 101: 
            case 104: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSettings";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/util/ExternalSystemUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "extractDetails";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createSyncDescriptor";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyncFinishEvent";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "naturalJoinSystemIds";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleManagerFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ensureToolWindowContentInitialized";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refreshProjects";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractDetails";
                break;
            }
            case 5: 
            case 6: 
            case 39: 
            case 49: 
            case 53: 
            case 68: 
            case 115: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "refreshProject";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "refreshProjectImpl";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "executeSync";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "incompleteDependenciesState";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createSyncDescriptor";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "handleSyncResult";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "selectProjectDataToImport";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getSyncFinishEvent";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "confirmLoadingUntrustedProject";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "naturalJoinSystemIds";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "configureNewModule";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "markModuleAsMaven";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "createFailureResult";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "runTask";
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "createExecutionEnvironment";
                break;
            }
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "createExternalSystemRunnerAndConfigurationSettings";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "findConfigurationType";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "getRunnerId";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "registerRunnerId";
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "linkExternalProject";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByIoFile";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "scheduleExternalViewStructureUpdate";
                break;
            }
            case 111: 
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProjectInfo";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleManagerFor";
                break;
            }
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "requestImport";
                break;
            }
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "waitForProcessExecution";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 39, 49, 53, 68, 115 -> new IllegalStateException(string);
        };
    }

    private static class AutoCloseableDisposable
    implements AutoCloseable,
    Disposable {
        private AutoCloseableDisposable() {
        }

        public void dispose() {
        }

        @Override
        public void close() {
            Disposer.dispose((Disposable)this);
        }
    }
}

