/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyNode;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemShortcutsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsStructure;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public abstract class ExternalSystemNode<T>
extends SimpleNode
implements Comparable<ExternalSystemNode<?>> {
    static final int BUILTIN_TASKS_DATA_NODE_ORDER = 10;
    static final int BUILTIN_DEPENDENCIES_DATA_NODE_ORDER = 20;
    static final int BUILTIN_RUN_CONFIGURATIONS_DATA_NODE_ORDER = 30;
    static final int BUILTIN_MODULE_DATA_NODE_ORDER = 40;
    @NotNull
    private static final Comparator<? super ExternalSystemNode<?>> ORDER_AWARE_COMPARATOR = new Comparator<ExternalSystemNode<?>>(){

        @Override
        public int compare(@NotNull ExternalSystemNode<?> o1, @NotNull ExternalSystemNode<?> o2) {
            int order2;
            int order1;
            if (o1 == null) {
                1.$$$reportNull$$$0(0);
            }
            if (o2 == null) {
                1.$$$reportNull$$$0(1);
            }
            if ((order1 = this.getOrder(o1)) == (order2 = this.getOrder(o2))) {
                return o1.compareTo(o2);
            }
            return order1 < order2 ? -1 : 1;
        }

        private int getOrder(@NotNull ExternalSystemNode<?> o) {
            Order annotation;
            if (o == null) {
                1.$$$reportNull$$$0(2);
            }
            if ((annotation = o.getClass().getAnnotation(Order.class)) != null) {
                return annotation.value();
            }
            return 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalSystemNode$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compare";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getOrder";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    protected static final ExternalSystemNode<?>[] NO_CHILDREN = new ExternalSystemNode[0];
    private static final List<ExternalSystemNode<?>> NO_CHILDREN_LIST = Collections.emptyList();
    private static final List<String> NO_ERRORS_LIST = Collections.emptyList();
    private final ExternalProjectsView myExternalProjectsView;
    private List<ExternalSystemNode<?>> myChildrenList;
    DataNode<T> myDataNode;
    @Nullable
    private ExternalSystemNode<?> myParent;
    private ExternalSystemNode<?>[] myChildren;
    @NotNull
    private ExternalProjectsStructure.ErrorLevel myErrorLevel;
    private List<String> myErrors;
    private ExternalProjectsStructure.ErrorLevel myTotalErrorLevel;

    public ExternalSystemNode(@NotNull ExternalProjectsView externalProjectsView, @Nullable ExternalSystemNode<?> parent) {
        if (externalProjectsView == null) {
            ExternalSystemNode.$$$reportNull$$$0(0);
        }
        this(externalProjectsView, parent, null);
    }

    public ExternalSystemNode(@NotNull ExternalProjectsView externalProjectsView, @Nullable ExternalSystemNode<?> parent, @Nullable DataNode<T> dataNode) {
        if (externalProjectsView == null) {
            ExternalSystemNode.$$$reportNull$$$0(1);
        }
        super(externalProjectsView.getProject(), null);
        this.myChildrenList = NO_CHILDREN_LIST;
        this.myErrorLevel = ExternalProjectsStructure.ErrorLevel.NONE;
        this.myErrors = NO_ERRORS_LIST;
        this.myTotalErrorLevel = null;
        this.myExternalProjectsView = externalProjectsView;
        this.myDataNode = dataNode;
        this.myParent = parent;
    }

    public boolean isAutoExpandNode() {
        SimpleNode parent = this.getParent();
        return parent != null && parent.getChildCount() == 1;
    }

    public void setParent(@Nullable ExternalSystemNode<?> parent) {
        this.myParent = parent;
    }

    @Nullable
    public T getData() {
        return (T)(this.myDataNode != null ? this.myDataNode.getData() : null);
    }

    @Nullable
    public DependencyNode getDependencyNode() {
        return null;
    }

    public NodeDescriptor getParentDescriptor() {
        return this.myParent;
    }

    @NlsSafe
    public String getName() {
        String displayName = this.getExternalProjectsView().getDisplayName(this.myDataNode);
        return displayName == null ? super.getName() : displayName;
    }

    protected ExternalProjectsView getExternalProjectsView() {
        return this.myExternalProjectsView;
    }

    protected ExternalSystemUiAware getUiAware() {
        return this.myExternalProjectsView.getUiAware();
    }

    protected ExternalProjectsStructure getStructure() {
        return this.myExternalProjectsView.getStructure();
    }

    @ApiStatus.Internal
    protected ExternalSystemShortcutsManager getShortcutsManager() {
        return this.myExternalProjectsView.getShortcutsManager();
    }

    protected ExternalSystemTaskActivator getTaskActivator() {
        return this.myExternalProjectsView.getTaskActivator();
    }

    @Nullable
    public <DataType> DataType findNode(Class<DataType> aClass, @NotNull Function<? super ExternalSystemNode<?>, Object> map) {
        if (map == null) {
            ExternalSystemNode.$$$reportNull$$$0(2);
        }
        ExternalSystemNode<?> node = this;
        while (node != null) {
            Object data = map.apply(node);
            if (aClass.isInstance(data)) {
                return (DataType)data;
            }
            node = node.myParent;
        }
        return null;
    }

    @Nullable
    public <DataType extends ExternalSystemNode<?>> DataType findNode(Class<DataType> aClass) {
        return (DataType)((ExternalSystemNode)this.findNode(aClass, it -> it));
    }

    @Nullable
    public <DataType extends DependencyNode> DataType findDependencyNode(Class<DataType> aClass) {
        return (DataType)((DependencyNode)this.findNode(aClass, it -> it.getDependencyNode()));
    }

    @Nullable
    public <DataType extends ExternalSystemNode<?>> DataType findParent(Class<DataType> aClass) {
        return (DataType)((ExternalSystemNode)ObjectUtils.doIfNotNull(this.myParent, p -> p.findNode(aClass)));
    }

    public boolean isVisible() {
        return this.getDisplayKind() != ExternalProjectsStructure.DisplayKind.NEVER && (!this.isIgnored() || this.myExternalProjectsView.getShowIgnored());
    }

    public boolean isIgnored() {
        if (this.myDataNode != null) {
            return this.myDataNode.isIgnored();
        }
        SimpleNode parent = this.getParent();
        return parent instanceof ExternalSystemNode && ((ExternalSystemNode)parent).isIgnored();
    }

    public void setIgnored(boolean ignored) {
        if (this.myDataNode != null) {
            ExternalProjectsManager.getInstance((Project)this.myExternalProjectsView.getProject()).setIgnored(this.myDataNode, ignored);
        }
    }

    private ExternalProjectsStructure.DisplayKind getDisplayKind() {
        Class<? extends ExternalSystemNode>[] visibles = this.getStructure().getVisibleNodesClasses();
        if (visibles == null) {
            return ExternalProjectsStructure.DisplayKind.NORMAL;
        }
        for (Class<? extends ExternalSystemNode> each : visibles) {
            if (!each.isInstance(this)) continue;
            return ExternalProjectsStructure.DisplayKind.ALWAYS;
        }
        return ExternalProjectsStructure.DisplayKind.NEVER;
    }

    public final ExternalSystemNode<?> @NotNull [] getChildren() {
        if (this.myChildren == null) {
            this.myChildren = this.buildChildren();
        }
        if (this.myChildren == null) {
            ExternalSystemNode.$$$reportNull$$$0(3);
        }
        return this.myChildren;
    }

    private ExternalSystemNode<?> @NotNull [] buildChildren() {
        ArrayList newChildrenCandidates = new ArrayList(this.doBuildChildren());
        if (newChildrenCandidates.isEmpty()) {
            if (NO_CHILDREN == null) {
                ExternalSystemNode.$$$reportNull$$$0(4);
            }
            return NO_CHILDREN;
        }
        this.addAll(newChildrenCandidates, true);
        this.sort(this.myChildrenList);
        ArrayList visibleNodes = new ArrayList();
        for (ExternalSystemNode<?> each : this.myChildrenList) {
            if (!each.isVisible()) continue;
            visibleNodes.add(each);
        }
        ExternalSystemNode[] externalSystemNodeArray = visibleNodes.toArray(new ExternalSystemNode[0]);
        if (externalSystemNodeArray == null) {
            ExternalSystemNode.$$$reportNull$$$0(5);
        }
        return externalSystemNodeArray;
    }

    void cleanUpCache() {
        this.myChildren = null;
        this.myChildrenList = NO_CHILDREN_LIST;
        this.myTotalErrorLevel = null;
    }

    ExternalSystemNode<?> @Nullable [] getCached() {
        return this.myChildren;
    }

    protected void sort(List<ExternalSystemNode<?>> list) {
        if (!list.isEmpty()) {
            list.sort(ORDER_AWARE_COMPARATOR);
        }
    }

    public boolean addAll(Collection<? extends ExternalSystemNode<?>> externalSystemNodes) {
        return this.addAll(externalSystemNodes, false);
    }

    private boolean addAll(Collection<? extends ExternalSystemNode<?>> externalSystemNodes, boolean silently) {
        if (externalSystemNodes.isEmpty()) {
            return false;
        }
        if (this.myChildrenList == NO_CHILDREN_LIST) {
            this.myChildrenList = new CopyOnWriteArrayList();
        }
        for (ExternalSystemNode<?> externalSystemNode : externalSystemNodes) {
            externalSystemNode.setParent(this);
            this.myChildrenList.add(externalSystemNode);
        }
        if (!silently) {
            this.childrenChanged();
        }
        return true;
    }

    public boolean add(ExternalSystemNode<?> externalSystemNode) {
        return this.addAll(Collections.singletonList(externalSystemNode));
    }

    public boolean removeAll(Collection<? extends ExternalSystemNode<?>> externalSystemNodes) {
        return this.removeAll(externalSystemNodes, false);
    }

    private boolean removeAll(Collection<? extends ExternalSystemNode<?>> externalSystemNodes, boolean silently) {
        if (externalSystemNodes.isEmpty()) {
            return false;
        }
        for (ExternalSystemNode<?> externalSystemNode : externalSystemNodes) {
            externalSystemNode.setParent(null);
            if (this.myChildrenList == NO_CHILDREN_LIST) continue;
            this.myChildrenList.remove(externalSystemNode);
        }
        if (!silently) {
            this.childrenChanged();
        }
        return true;
    }

    public void remove(ExternalSystemNode<?> externalSystemNode) {
        this.removeAll(Collections.singletonList(externalSystemNode));
    }

    protected void childrenChanged() {
        for (ExternalSystemNode each = this; each != null; each = (ExternalSystemNode)each.getParent()) {
            each.myTotalErrorLevel = null;
        }
        this.sort(this.myChildrenList);
        List visibleNodes = ContainerUtil.filter(this.myChildrenList, node -> node.isVisible());
        this.myChildren = visibleNodes.toArray(new ExternalSystemNode[0]);
        this.myExternalProjectsView.updateUpTo(this);
    }

    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }

    @NotNull
    protected List<? extends ExternalSystemNode<?>> doBuildChildren() {
        if (this.myDataNode != null && !this.myDataNode.getChildren().isEmpty()) {
            ExternalProjectsView externalProjectsView = this.getExternalProjectsView();
            List<ExternalSystemNode<?>> list = externalProjectsView.createNodes(externalProjectsView, this, this.myDataNode);
            if (list == null) {
                ExternalSystemNode.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<ExternalSystemNode<?>> list = this.myChildrenList;
        if (list == null) {
            ExternalSystemNode.$$$reportNull$$$0(7);
        }
        return list;
    }

    private void setDataNode(DataNode<T> dataNode) {
        this.myDataNode = dataNode;
    }

    @NotNull
    private ExternalProjectsStructure.ErrorLevel getTotalErrorLevel() {
        ExternalProjectsStructure.ErrorLevel level = this.myTotalErrorLevel;
        if (level == null) {
            this.myTotalErrorLevel = level = this.calcTotalErrorLevel();
        }
        ExternalProjectsStructure.ErrorLevel errorLevel = level;
        if (errorLevel == null) {
            ExternalSystemNode.$$$reportNull$$$0(8);
        }
        return errorLevel;
    }

    @NotNull
    private ExternalProjectsStructure.ErrorLevel calcTotalErrorLevel() {
        ExternalProjectsStructure.ErrorLevel childrenErrorLevel = this.getChildrenErrorLevel();
        ExternalProjectsStructure.ErrorLevel errorLevel = childrenErrorLevel.compareTo(this.myErrorLevel) > 0 ? childrenErrorLevel : this.myErrorLevel;
        if (errorLevel == null) {
            ExternalSystemNode.$$$reportNull$$$0(9);
        }
        return errorLevel;
    }

    public ExternalProjectsStructure.ErrorLevel getChildrenErrorLevel() {
        if (this.myChildren == null && this.myDataNode != null) {
            return this.getExternalProjectsView().getErrorLevelRecursively(this.myDataNode);
        }
        ExternalProjectsStructure.ErrorLevel result = ExternalProjectsStructure.ErrorLevel.NONE;
        for (ExternalSystemNode<?> each : this.getChildren()) {
            ExternalProjectsStructure.ErrorLevel eachLevel = each.getTotalErrorLevel();
            if (eachLevel.compareTo(result) > 0) {
                result = eachLevel;
            }
            if (result == ExternalProjectsStructure.ErrorLevel.ERROR) break;
        }
        return result;
    }

    public void setErrorLevel(@NotNull ExternalProjectsStructure.ErrorLevel level, String ... errors) {
        if (level == null) {
            ExternalSystemNode.$$$reportNull$$$0(10);
        }
        if (this.myErrorLevel == level) {
            return;
        }
        this.myErrorLevel = level;
        this.myErrors = errors.length == 0 ? NO_ERRORS_LIST : Arrays.asList(errors);
        this.myExternalProjectsView.updateUpTo(this);
    }

    protected void doUpdate(@NotNull PresentationData presentation) {
        if (presentation == null) {
            ExternalSystemNode.$$$reportNull$$$0(11);
        }
        this.setNameAndTooltip(presentation, this.getName(), null);
    }

    protected void setNameAndTooltip(@NotNull PresentationData presentation, @NlsSafe String name, @NlsContexts.Tooltip @Nullable String tooltip) {
        if (presentation == null) {
            ExternalSystemNode.$$$reportNull$$$0(12);
        }
        this.setNameAndTooltip(presentation, name, tooltip, (String)null);
    }

    protected void setNameAndTooltip(@NotNull PresentationData presentation, @NlsSafe String name, @NlsContexts.Tooltip @Nullable String tooltip, @Nullable @NlsSafe String hint) {
        boolean ignored;
        if (presentation == null) {
            ExternalSystemNode.$$$reportNull$$$0(13);
        }
        SimpleTextAttributes textAttributes = (ignored = this.isIgnored()) ? SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES : this.getPlainAttributes();
        this.setNameAndTooltip(presentation, name, tooltip, textAttributes);
        if (!StringUtil.isEmptyOrSpaces((String)hint)) {
            presentation.addText(" (" + hint + ")", ignored ? SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    protected void setNameAndTooltip(@NotNull PresentationData presentation, @NlsSafe String name, @NlsContexts.Tooltip @Nullable String tooltip, SimpleTextAttributes attributes) {
        if (presentation == null) {
            ExternalSystemNode.$$$reportNull$$$0(14);
        }
        presentation.clearText();
        presentation.addText(name, this.prepareAttributes(attributes));
        String s = (String)(tooltip != null ? tooltip + "\n\r" : "") + StringUtil.join(this.myErrors, (String)"\n\r");
        presentation.setTooltip(s);
    }

    private SimpleTextAttributes prepareAttributes(SimpleTextAttributes from) {
        ExternalProjectsStructure.ErrorLevel level = this.getTotalErrorLevel();
        JBColor waveColor = level == ExternalProjectsStructure.ErrorLevel.NONE ? null : JBColor.RED;
        int style = from.getStyle();
        if (waveColor != null) {
            style |= 8;
        }
        return new SimpleTextAttributes(from.getBgColor(), from.getFgColor(), (Color)waveColor, style);
    }

    @Language(value="devkit-action-id")
    @Nullable
    @NonNls
    protected String getActionId() {
        return null;
    }

    @Nullable
    @NonNls
    protected String getMenuId() {
        return null;
    }

    protected String message(@PropertyKey(resourceBundle="messages.ExternalSystemBundle") @NotNull @PropertyKey(resourceBundle="messages.ExternalSystemBundle") @NotNull String key, Object ... params) {
        if (key == null) {
            ExternalSystemNode.$$$reportNull$$$0(15);
        }
        if (params == null) {
            ExternalSystemNode.$$$reportNull$$$0(16);
        }
        return ExternalSystemBundle.message((String)key, (Object[])params);
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return null;
    }

    @Nullable
    public Navigatable getNavigatable() {
        return null;
    }

    public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
        String actionId = this.getActionId();
        this.getExternalProjectsView().handleDoubleClickOrEnter(this, actionId, inputEvent);
    }

    @Override
    public int compareTo(@NotNull ExternalSystemNode<?> node) {
        if (node == null) {
            ExternalSystemNode.$$$reportNull$$$0(17);
        }
        return StringUtil.compare((String)this.getName(), (String)node.getName(), (boolean)true);
    }

    public void mergeWith(@NotNull ExternalSystemNode<T> newNode) {
        if (newNode == null) {
            ExternalSystemNode.$$$reportNull$$$0(18);
        }
        this.setDataNode(newNode.myDataNode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectsView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/view/ExternalSystemNode";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalSystemNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChildren";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doBuildChildren";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTotalErrorLevel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "calcTotalErrorLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findNode";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setErrorLevel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doUpdate";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setNameAndTooltip";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "message";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "mergeWith";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

