/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.cloud.gateway;

import com.intellij.ide.presentation.Presentation;
import com.intellij.microservices.url.HttpUrlResolver;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.spring.boot.cloud.gateway.endpoints.SpringCloudGatewayUrlTargetInfo;
import com.intellij.spring.boot.cloud.gateway.utils.SpringCloudGatewayUtil;
import com.intellij.spring.model.SpringBeanPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Presentation(icon="com.intellij.spring.SpringApiIcons.RequestMapping", typeName="Spring Cloud Gateway")
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/spring/boot/cloud/gateway/SpringCloudGatewayUrlResolver;", "Lcom/intellij/microservices/url/HttpUrlResolver;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "resolve", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "request", "Lcom/intellij/microservices/url/UrlResolveRequest;", "getVariants", "intellij.spring.boot.cloud.gateway"})
@SourceDebugExtension(value={"SMAP\nSpringCloudGatewayResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringCloudGatewayResolver.kt\ncom/intellij/spring/boot/cloud/gateway/SpringCloudGatewayUrlResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,32:1\n777#2:33\n873#2,2:34\n*S KotlinDebug\n*F\n+ 1 SpringCloudGatewayResolver.kt\ncom/intellij/spring/boot/cloud/gateway/SpringCloudGatewayUrlResolver\n*L\n18#1:33\n18#1:34,2\n*E\n"})
public final class SpringCloudGatewayUrlResolver
extends HttpUrlResolver {
    @NotNull
    private final Project myProject;

    public SpringCloudGatewayUrlResolver(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
    }

    @NotNull
    public Iterable<UrlTargetInfo> resolve(@NotNull UrlResolveRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMapIterable((Sequence)UrlPath.Companion.combinations(request.getPath()), arg_0 -> SpringCloudGatewayUrlResolver.resolve$lambda$0(this, arg_0)));
    }

    @NotNull
    public Iterable<UrlTargetInfo> getVariants() {
        Set urls = new HashSet();
        Module[] moduleArray = ModuleManager.Companion.getInstance(this.myProject).getModules();
        int n = moduleArray.length;
        for (int i = 0; i < n; ++i) {
            Module module;
            Module module2 = module = moduleArray[i];
            Intrinsics.checkNotNull((Object)module2);
            if (!SpringCloudGatewayUtil.hasSpringCloudGatewayLibrary(module2)) continue;
            Iterator<SpringBeanPointer<?>> iterator = SpringCloudGatewayUtil.getRouteLocatorBeans(module).iterator();
            while (iterator.hasNext()) {
                SpringBeanPointer<?> routeLocatorBean;
                SpringBeanPointer<?> springBeanPointer = routeLocatorBean = iterator.next();
                Intrinsics.checkNotNull(springBeanPointer);
                Set<SpringCloudGatewayUrlTargetInfo> set = SpringCloudGatewayUtil.getRouteLocatorPaths(module, springBeanPointer);
                Intrinsics.checkNotNullExpressionValue(set, (String)"getRouteLocatorPaths(...)");
                urls.addAll((Collection)set);
            }
        }
        return urls;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable resolve$lambda$0(SpringCloudGatewayUrlResolver this$0, UrlPath urlPath) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)urlPath, (String)"urlPath");
        Iterable<UrlTargetInfo> $this$filter$iv = this$0.getVariants();
        boolean $i$f$filter = false;
        Iterable<UrlTargetInfo> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            UrlTargetInfo it = (UrlTargetInfo)element$iv$iv;
            boolean bl = false;
            if (!it.getPath().isCompatibleWith(urlPath)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

