/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.plots;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.editor.outputs.NotebookDisplayOutputDataKeyExtractor;
import com.intellij.jupyter.core.jupyter.nbformat.DisplayDataContainer;
import com.intellij.jupyter.core.jupyter.nbformat.MimeType;
import com.intellij.jupyter.execution.util.JsonKt;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookApplicationOptions;
import com.intellij.kotlin.jupyter.plots.LetsPlotOutputDataKey;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.editor.Editor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.toolkit.json.SerializeSpecKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJC\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/intellij/kotlin/jupyter/plots/PlotDataKeyExtractor;", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/NotebookDisplayOutputDataKeyExtractor;", "<init>", "()V", "extractKey", "Lcom/intellij/kotlin/jupyter/plots/LetsPlotOutputDataKey;", "data", "Lcom/intellij/jupyter/core/jupyter/nbformat/DisplayDataContainer;", "executionCount", "", "(Lcom/intellij/jupyter/core/jupyter/nbformat/DisplayDataContainer;Ljava/lang/Integer;)Lcom/intellij/kotlin/jupyter/plots/LetsPlotOutputDataKey;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "isLastForCell", "", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Lcom/intellij/jupyter/core/jupyter/nbformat/DisplayDataContainer;Ljava/lang/Integer;Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;Z)Lcom/intellij/kotlin/jupyter/plots/LetsPlotOutputDataKey;", "Companion", "intellij.kotlin.jupyter.plots"})
@SourceDebugExtension(value={"SMAP\nPlotDataKeyExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotDataKeyExtractor.kt\ncom/intellij/kotlin/jupyter/plots/PlotDataKeyExtractor\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,62:1\n18#2:63\n18#2:64\n18#2:65\n18#2:66\n18#2:67\n*S KotlinDebug\n*F\n+ 1 PlotDataKeyExtractor.kt\ncom/intellij/kotlin/jupyter/plots/PlotDataKeyExtractor\n*L\n28#1:63\n29#1:64\n31#1:65\n33#1:66\n34#1:67\n*E\n"})
public final class PlotDataKeyExtractor
implements NotebookDisplayOutputDataKeyExtractor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String PLOT_TYPE_KEY = "output_type";
    @NotNull
    private static final String APPLY_COLOR_SCHEME_KEY = "apply_color_scheme";
    @NotNull
    private static final String SWING_ENABLED_KEY = "swing_enabled";

    @Nullable
    public final LetsPlotOutputDataKey extractKey(@NotNull DisplayDataContainer data, @Nullable Integer executionCount) {
        LetsPlotOutputDataKey letsPlotOutputDataKey;
        Object object;
        boolean swingEnabled;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!KotlinNotebookApplicationOptions.INSTANCE.get().getShowLetsPlotAsSwing()) {
            return null;
        }
        ObjectNode dataObject = data.toV4Json();
        if (!dataObject.has(MimeType.LETS_PLOT.getMimeType())) {
            return null;
        }
        JsonNode $this$asSafely$iv = dataObject.get(MimeType.LETS_PLOT.getMimeType());
        boolean $i$f$asSafely = false;
        JsonNode jsonNode = $this$asSafely$iv;
        if (!(jsonNode instanceof ObjectNode)) {
            jsonNode = null;
        }
        ObjectNode objectNode = (ObjectNode)jsonNode;
        if (objectNode == null) {
            return null;
        }
        ObjectNode plotValue = objectNode;
        JsonNode $this$asSafely$iv2 = plotValue.get(SWING_ENABLED_KEY);
        boolean $i$f$asSafely2 = false;
        JsonNode jsonNode2 = $this$asSafely$iv2;
        if (!(jsonNode2 instanceof BooleanNode)) {
            jsonNode2 = null;
        }
        BooleanNode booleanNode = (BooleanNode)jsonNode2;
        boolean bl = swingEnabled = !(booleanNode != null ? !booleanNode.asBoolean() : false);
        if (!swingEnabled) {
            return null;
        }
        JsonNode $this$asSafely$iv3 = plotValue.get(PLOT_TYPE_KEY);
        boolean $i$f$asSafely3 = false;
        JsonNode jsonNode3 = $this$asSafely$iv3;
        if (!(jsonNode3 instanceof TextNode)) {
            jsonNode3 = null;
        }
        if ((object = (TextNode)jsonNode3) == null || (object = object.asText()) == null) {
            return null;
        }
        Object plotType = object;
        if (Intrinsics.areEqual((Object)plotType, (Object)"lets_plot_spec")) {
            JsonNode $this$asSafely$iv4 = plotValue.get("output");
            boolean $i$f$asSafely4 = false;
            JsonNode jsonNode4 = $this$asSafely$iv4;
            if (!(jsonNode4 instanceof ObjectNode)) {
                jsonNode4 = null;
            }
            ObjectNode objectNode2 = (ObjectNode)jsonNode4;
            if (objectNode2 != null) {
                ObjectNode outputSpec = objectNode2;
                boolean bl2 = false;
                JsonNode $this$asSafely$iv5 = plotValue.get(APPLY_COLOR_SCHEME_KEY);
                boolean $i$f$asSafely5 = false;
                JsonNode jsonNode5 = $this$asSafely$iv5;
                if (!(jsonNode5 instanceof BooleanNode)) {
                    jsonNode5 = null;
                }
                BooleanNode booleanNode2 = (BooleanNode)jsonNode5;
                boolean applyColorScheme = !(booleanNode2 != null ? !booleanNode2.asBoolean() : false);
                letsPlotOutputDataKey = new LetsPlotOutputDataKey(SerializeSpecKt.deserializeJsonMap((JsonElement)JsonKt.convertObject((ObjectNode)outputSpec)), executionCount, applyColorScheme);
            } else {
                letsPlotOutputDataKey = null;
            }
        } else {
            letsPlotOutputDataKey = null;
        }
        return letsPlotOutputDataKey;
    }

    @Nullable
    public LetsPlotOutputDataKey extractKey(@NotNull Editor editor, @Nullable BackedNotebookVirtualFile file, @NotNull DisplayDataContainer data, @Nullable Integer executionCount, @NotNull NotebookIntervalPointer cellPointer, boolean isLastForCell) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        return this.extractKey(data, executionCount);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/kotlin/jupyter/plots/PlotDataKeyExtractor$Companion;", "", "<init>", "()V", "PLOT_TYPE_KEY", "", "APPLY_COLOR_SCHEME_KEY", "SWING_ENABLED_KEY", "intellij.kotlin.jupyter.plots"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

