/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.index;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.java.stubs.index.JavaAutoModuleFilterScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.indexing.hints.FileTypeInputFilterPredicate;
import com.intellij.util.indexing.hints.FileTypeSubstitutionStrategy;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;

public final class JavaSourceModuleNameIndex
extends ScalarIndexExtension<String> {
    private static final ID<String, Void> NAME = ID.create((String)"java.source.module.name");
    private final DataIndexer<String, Void, FileContent> myIndexer = data -> {
        try {
            String name = new Manifest(new ByteArrayInputStream(data.getContent())).getMainAttributes().getValue("Automatic-Module-Name");
            if (name != null) {
                return Collections.singletonMap(name, null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Collections.emptyMap();
    };

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = NAME;
        if (iD == null) {
            JavaSourceModuleNameIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    public int getVersion() {
        return 4;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            JavaSourceModuleNameIndex.$$$reportNull$$$0(1);
        }
        return enumeratorStringDescriptor;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileType manifestFileType = FileTypeRegistry.getInstance().getFileTypeByFileName("Manifest.mf");
        return new FileTypeInputFilterPredicate(FileTypeSubstitutionStrategy.BEFORE_SUBSTITUTION, type -> type.equals((Object)manifestFileType));
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer<String, Void, FileContent> dataIndexer = this.myIndexer;
        if (dataIndexer == null) {
            JavaSourceModuleNameIndex.$$$reportNull$$$0(2);
        }
        return dataIndexer;
    }

    @NotNull
    public Collection<FileType> getFileTypesWithSizeLimitNotApplicable() {
        Set<JavaClassFileType> set = Collections.singleton(JavaClassFileType.INSTANCE);
        if (set == null) {
            JavaSourceModuleNameIndex.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public static Collection<VirtualFile> getFilesByKey(@NotNull String moduleName, @NotNull GlobalSearchScope scope) {
        if (moduleName == null) {
            JavaSourceModuleNameIndex.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            JavaSourceModuleNameIndex.$$$reportNull$$$0(5);
        }
        Collection collection = FileBasedIndex.getInstance().getContainingFiles(NAME, (Object)moduleName, (GlobalSearchScope)new JavaAutoModuleFilterScope(scope));
        if (collection == null) {
            JavaSourceModuleNameIndex.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    public static Collection<String> getAllKeys(@NotNull Project project) {
        if (project == null) {
            JavaSourceModuleNameIndex.$$$reportNull$$$0(7);
        }
        Collection collection = FileBasedIndex.getInstance().getAllKeys(NAME, project);
        if (collection == null) {
            JavaSourceModuleNameIndex.$$$reportNull$$$0(8);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/stubs/index/JavaSourceModuleNameIndex";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypesWithSizeLimitNotApplicable";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/stubs/index/JavaSourceModuleNameIndex";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesByKey";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeys";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByKey";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllKeys";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 7 -> new IllegalArgumentException(string);
        };
    }
}

