/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.search.JavaOverridingMethodsSearcher;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllOverridingMethodsSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class JavaAllOverridingMethodsSearcher
implements QueryExecutor<Pair<PsiMethod, PsiMethod>, AllOverridingMethodsSearch.SearchParameters> {
    public boolean execute(@NotNull AllOverridingMethodsSearch.SearchParameters p, @NotNull Processor<? super Pair<PsiMethod, PsiMethod>> consumer) {
        PsiClass psiClass;
        List potentials;
        if (p == null) {
            JavaAllOverridingMethodsSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            JavaAllOverridingMethodsSearcher.$$$reportNull$$$0(1);
        }
        if ((potentials = (List)ReadAction.compute(() -> JavaAllOverridingMethodsSearcher.lambda$execute$0(psiClass = p.getPsiClass()))).isEmpty()) {
            return true;
        }
        SearchScope scope = p.getScope();
        JavaPsiFacade psiFacade = (JavaPsiFacade)ReadAction.compute(() -> JavaPsiFacade.getInstance((Project)psiClass.getProject()));
        Processor inheritorsProcessor = inheritor -> {
            for (PsiMethod superMethod : potentials) {
                PsiMethod inInheritor;
                ProgressManager.checkCanceled();
                if (superMethod.hasModifierProperty("packageLocal") && !psiFacade.arePackagesTheSame((PsiElement)psiClass, (PsiElement)inheritor) || (inInheritor = JavaOverridingMethodsSearcher.findOverridingMethod(inheritor, superMethod, psiClass)) == null || consumer.process((Object)Pair.create((Object)superMethod, (Object)inInheritor))) continue;
                return false;
            }
            return true;
        };
        return ClassInheritorsSearch.search((PsiClass)psiClass, (SearchScope)scope, (boolean)true).allowParallelProcessing().forEach(inheritorsProcessor);
    }

    private static /* synthetic */ List lambda$execute$0(PsiClass psiClass) throws RuntimeException {
        return ContainerUtil.filter((Object[])psiClass.getMethods(), PsiUtil::canBeOverridden);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "p";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/impl/search/JavaAllOverridingMethodsSearcher";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

