/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.java.codeserver.core.JavaManifestUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.java.stubs.index.JavaAutoModuleNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaModuleNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaSourceModuleNameIndex;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.JavaModuleSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaModuleSearcher
implements QueryExecutor<PsiJavaModule, JavaModuleSearch.Parameters> {
    public boolean execute(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull JavaModuleSearch.Parameters queryParameters, @NotNull Processor<? super PsiJavaModule> consumer) {
        if (consumer == null) {
            JavaModuleSearcher.$$$reportNull$$$0(0);
        }
        if (queryParameters == null) {
            JavaModuleSearcher.$$$reportNull$$$0(1);
        }
        String moduleName = queryParameters.getName();
        Project project = queryParameters.getProject();
        GlobalSearchScope scope = queryParameters.getScope();
        if (moduleName == null) {
            return JavaModuleSearcher.processAllModules(project, consumer);
        }
        return JavaModuleSearcher.processModuleByName(moduleName, project, scope, consumer);
    }

    private static boolean processAllModules(@NotNull Project project, @NotNull Processor<? super PsiJavaModule> consumer) {
        if (project == null) {
            JavaModuleSearcher.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            JavaModuleSearcher.$$$reportNull$$$0(3);
        }
        GlobalSearchScope indexScope = GlobalSearchScope.allScope((Project)project);
        LinkedHashSet<String> allNames = new LinkedHashSet<String>();
        allNames.addAll(JavaModuleNameIndex.getInstance().getAllKeys(project));
        allNames.addAll(JavaSourceModuleNameIndex.getAllKeys(project));
        allNames.addAll(JavaAutoModuleNameIndex.getAllKeys(project));
        HashSet namesWithResults = new HashSet();
        for (String name : allNames) {
            if (JavaModuleSearcher.processModulesFromIndices(name, project, indexScope, consumer, namesWithResults)) continue;
            return false;
        }
        return JavaModuleSearcher.processJpsModules(project, consumer, namesWithResults, null);
    }

    private static boolean processModuleByName(@NotNull String moduleName, @NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiJavaModule> consumer) {
        HashSet namesWithResults;
        if (moduleName == null) {
            JavaModuleSearcher.$$$reportNull$$$0(4);
        }
        if (project == null) {
            JavaModuleSearcher.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            JavaModuleSearcher.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            JavaModuleSearcher.$$$reportNull$$$0(7);
        }
        if (!JavaModuleSearcher.processModulesFromIndices(moduleName, project, scope, consumer, namesWithResults = new HashSet())) {
            return false;
        }
        if (namesWithResults.contains(moduleName)) {
            return true;
        }
        return JavaModuleSearcher.processJpsModules(project, consumer, namesWithResults, moduleName);
    }

    private static boolean processJpsModules(@NotNull Project project, @NotNull Processor<? super PsiJavaModule> consumer, @NotNull Set<? super String> namesWithResults, @Nullable String moduleName) {
        Module[] modules;
        if (project == null) {
            JavaModuleSearcher.$$$reportNull$$$0(8);
        }
        if (consumer == null) {
            JavaModuleSearcher.$$$reportNull$$$0(9);
        }
        if (namesWithResults == null) {
            JavaModuleSearcher.$$$reportNull$$$0(10);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)project);
        ProjectRootModificationTracker tracker = ProjectRootModificationTracker.getInstance((Project)project);
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            String defaultModuleName;
            VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots(false);
            if (sourceRoots.length == 0) continue;
            VirtualFile root = sourceRoots[0];
            String autoModuleName = JavaManifestUtil.getManifestAttributeValue((Module)module, (String)"Automatic-Module-Name");
            if (autoModuleName != null && !namesWithResults.contains(autoModuleName)) {
                if (moduleName != null && moduleName.equals(autoModuleName)) {
                    namesWithResults.add(autoModuleName);
                    return consumer.process((Object)LightJavaModule.create((PsiManager)psiManager, (VirtualFile)root, (String)autoModuleName));
                }
                if (moduleName == null) {
                    namesWithResults.add(autoModuleName);
                    if (consumer.process((Object)LightJavaModule.create((PsiManager)psiManager, (VirtualFile)root, (String)autoModuleName))) continue;
                    return false;
                }
            }
            if (namesWithResults.contains(defaultModuleName = (String)valuesManager.getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create((Object)LightJavaModule.moduleName((String)module.getName()), (Object[])new Object[]{tracker})))) continue;
            if (moduleName != null && moduleName.equals(defaultModuleName)) {
                namesWithResults.add(defaultModuleName);
                return consumer.process((Object)LightJavaModule.create((PsiManager)psiManager, (VirtualFile)root, (String)defaultModuleName));
            }
            if (moduleName != null) continue;
            namesWithResults.add(defaultModuleName);
            if (consumer.process((Object)LightJavaModule.create((PsiManager)psiManager, (VirtualFile)root, (String)defaultModuleName))) continue;
            return false;
        }
        return true;
    }

    private static boolean processModulesFromIndices(@NotNull String moduleName, @NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiJavaModule> consumer, @NotNull Set<? super String> namesWithResults) {
        if (moduleName == null) {
            JavaModuleSearcher.$$$reportNull$$$0(11);
        }
        if (project == null) {
            JavaModuleSearcher.$$$reportNull$$$0(12);
        }
        if (scope == null) {
            JavaModuleSearcher.$$$reportNull$$$0(13);
        }
        if (consumer == null) {
            JavaModuleSearcher.$$$reportNull$$$0(14);
        }
        if (namesWithResults == null) {
            JavaModuleSearcher.$$$reportNull$$$0(15);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (PsiJavaModule module : JavaModuleNameIndex.getInstance().getModules(moduleName, project, scope)) {
            namesWithResults.add(moduleName);
            if (consumer.process((Object)module)) continue;
            return false;
        }
        HashSet<VirtualFile> shadowedRoots = new HashSet<VirtualFile>();
        for (VirtualFile manifest : JavaSourceModuleNameIndex.getFilesByKey(moduleName, scope)) {
            VirtualFile root = JavaModuleSearcher.getSourceRootFromManifest(manifest);
            if (root == null) continue;
            namesWithResults.add(moduleName);
            shadowedRoots.add(root);
            if (consumer.process((Object)LightJavaModule.create((PsiManager)psiManager, (VirtualFile)root, (String)moduleName))) continue;
            return false;
        }
        for (VirtualFile root : JavaAutoModuleNameIndex.getFilesByKey(moduleName, scope)) {
            VirtualFile manifest;
            if (shadowedRoots.contains(root) || (manifest = root.findFileByRelativePath("META-INF/MANIFEST.MF")) != null && LightJavaModule.claimedModuleName((VirtualFile)manifest) != null) continue;
            namesWithResults.add(moduleName);
            if (consumer.process((Object)LightJavaModule.create((PsiManager)psiManager, (VirtualFile)root, (String)moduleName))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static VirtualFile getSourceRootFromManifest(@NotNull VirtualFile manifest) {
        VirtualFile parent;
        if (manifest == null) {
            JavaModuleSearcher.$$$reportNull$$$0(16);
        }
        if ((parent = manifest.getParent()) == null) {
            return null;
        }
        VirtualFile root = parent.getParent();
        if (root == null) {
            return null;
        }
        return root;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesWithResults";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifest";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/search/JavaModuleSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllModules";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processModuleByName";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "processJpsModules";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "processModulesFromIndices";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getSourceRootFromManifest";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

