/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ijent;

import com.intellij.docker.agent.util.ShortId;
import com.intellij.docker.ijent.DockerEelPathFormat;
import com.intellij.docker.ijent.DockerEndpointEncoder;
import com.intellij.docker.utils.InternalUtilsKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmInline;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bw\u0018\u0000 \u00112\u00020\u0001:\u0006\f\r\u000e\u000f\u0010\u0011J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u0007H&J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0007H&\u0082\u0001\u0003\u0012\u0013\u0014\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0015\u00c0\u0006\u0001"}, d2={"Lcom/intellij/docker/ijent/DockerEelPathFormat;", "", "buildRootPath", "Lcom/intellij/docker/ijent/DockerEelPathFormat$PathRepresentation;", "containerIdentifier", "Lcom/intellij/docker/ijent/DockerEelPathFormat$ContainerIdentifier;", "endpoint", "", "parse", "path", "matches", "", "Standard", "Devcontainer", "Obsolete", "ContainerIdentifier", "PathRepresentation", "Companion", "Lcom/intellij/docker/ijent/DockerEelPathFormat$Devcontainer;", "Lcom/intellij/docker/ijent/DockerEelPathFormat$Obsolete;", "Lcom/intellij/docker/ijent/DockerEelPathFormat$Standard;", "intellij.clouds.docker"})
@ApiStatus.Internal
public sealed interface DockerEelPathFormat {
    @NotNull
    public static final Companion Companion = com.intellij.docker.ijent.DockerEelPathFormat$Companion.$$INSTANCE;

    @NotNull
    public PathRepresentation buildRootPath(@NotNull ContainerIdentifier var1, @Nullable String var2);

    @Nullable
    public PathRepresentation parse(@NotNull String var1);

    public boolean matches(@NotNull String var1);

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ.\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00110\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/ijent/DockerEelPathFormat$Companion;", "", "<init>", "()V", "IS_WINDOWS", "", "detect", "Lcom/intellij/docker/ijent/DockerEelPathFormat;", "path", "", "isWindows", "parseWithEndpoint", "Lcom/intellij/docker/ijent/DockerEelPathFormat$PathRepresentation;", "pathPrefix", "afterPrefix", "createIdentifier", "Lkotlin/Function1;", "Lcom/intellij/docker/ijent/DockerEelPathFormat$ContainerIdentifier;", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerEelPathFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerEelPathFormat.kt\ncom/intellij/docker/ijent/DockerEelPathFormat$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,482:1\n184#2,2:483\n*S KotlinDebug\n*F\n+ 1 DockerEelPathFormat.kt\ncom/intellij/docker/ijent/DockerEelPathFormat$Companion\n*L\n283#1:483,2\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        private static final boolean IS_WINDOWS;

        private Companion() {
        }

        @VisibleForTesting
        @Nullable
        public final DockerEelPathFormat detect(@NotNull String path2, boolean isWindows) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                Object[] objectArray = new DockerEelPathFormat[]{new Standard(isWindows), new Devcontainer(isWindows), new Obsolete(isWindows)};
                Sequence $this$firstOrNull$iv = SequencesKt.sequenceOf((Object[])objectArray);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    DockerEelPathFormat it = (DockerEelPathFormat)element$iv;
                    boolean bl = false;
                    if (!it.matches(path2)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @Nullable
        public final DockerEelPathFormat detect(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return this.detect(path2, IS_WINDOWS);
        }

        private final PathRepresentation parseWithEndpoint(String pathPrefix, String afterPrefix, Function1<? super String, ? extends ContainerIdentifier> createIdentifier) {
            ContainerIdentifier containerIdentifier;
            Pair pair;
            int atIndex = StringsKt.indexOf$default((CharSequence)afterPrefix, (char)'@', (int)0, (boolean)false, (int)6, null);
            if (atIndex == -1) {
                return null;
            }
            String string = afterPrefix.substring(0, atIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String containerStr = string;
            if (((CharSequence)containerStr).length() == 0) {
                return null;
            }
            String string2 = afterPrefix.substring(atIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String remainder = string2;
            int separatorIndex = StringsKt.indexOf$default((CharSequence)remainder, (char)'/', (int)0, (boolean)false, (int)6, null);
            if (separatorIndex == -1) {
                pair = TuplesKt.to((Object)remainder, (Object)"");
            } else {
                String string3 = remainder.substring(0, separatorIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                String string4 = remainder.substring(separatorIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                pair = TuplesKt.to((Object)string3, (Object)string4);
            }
            Pair pair2 = pair;
            String encodedEndpoint = (String)pair2.component1();
            String innerPath = (String)pair2.component2();
            try {
                containerIdentifier = (ContainerIdentifier)createIdentifier.invoke((Object)containerStr);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            ContainerIdentifier identifier = containerIdentifier;
            return new PathRepresentation(pathPrefix, identifier, encodedEndpoint, innerPath);
        }

        static {
            $$INSTANCE = new Companion();
            IS_WINDOWS = File.separatorChar == '\\';
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \b2\u00020\u0001:\u0003\u0006\u0007\bR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\t\n\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/docker/ijent/DockerEelPathFormat$ContainerIdentifier;", "", "value", "", "getValue", "()Ljava/lang/String;", "Id", "DevcontainerId", "Companion", "Lcom/intellij/docker/ijent/DockerEelPathFormat$ContainerIdentifier$DevcontainerId;", "Lcom/intellij/docker/ijent/DockerEelPathFormat$ContainerIdentifier$Id;", "intellij.clouds.docker"})
    public static sealed interface ContainerIdentifier {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @NotNull
        public String getValue();

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/docker/ijent/DockerEelPathFormat$ContainerIdentifier$Companion;", "", "<init>", "()V", "validateContainerId", "", "value", "", "type", "intellij.clouds.docker"})
        @SourceDebugExtension(value={"SMAP\nDockerEelPathFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerEelPathFormat.kt\ncom/intellij/docker/ijent/DockerEelPathFormat$ContainerIdentifier$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,482:1\n1#2:483\n1088#3,2:484\n*S KotlinDebug\n*F\n+ 1 DockerEelPathFormat.kt\ncom/intellij/docker/ijent/DockerEelPathFormat$ContainerIdentifier$Companion\n*L\n224#1:484,2\n*E\n"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            /*
             * Unable to fully structure code
             */
            private final void validateContainerId(String value, String type) {
                block6: {
                    if (!(((CharSequence)value).length() > 0)) {
                        $i$a$-require-DockerEelPathFormat$ContainerIdentifier$Companion$validateContainerId$1 = false;
                        $i$a$-require-DockerEelPathFormat$ContainerIdentifier$Companion$validateContainerId$1 = type + " cannot be empty";
                        throw new IllegalArgumentException($i$a$-require-DockerEelPathFormat$ContainerIdentifier$Companion$validateContainerId$1.toString());
                    }
                    if (!(value.length() == 12)) {
                        $i$a$-require-DockerEelPathFormat$ContainerIdentifier$Companion$validateContainerId$2 = false;
                        $i$a$-require-DockerEelPathFormat$ContainerIdentifier$Companion$validateContainerId$2 = type + " must be 12 characters: " + value;
                        throw new IllegalArgumentException($i$a$-require-DockerEelPathFormat$ContainerIdentifier$Companion$validateContainerId$2.toString());
                    }
                    $this$all$iv = value;
                    $i$f$all = false;
                    for (var5_10 = 0; var5_10 < $this$all$iv.length(); ++var5_10) {
                        it = element$iv = $this$all$iv.charAt(var5_10);
                        $i$a$-all-DockerEelPathFormat$ContainerIdentifier$Companion$validateContainerId$3 = false;
                        if ('0' <= it ? it < ':' : false) ** GOTO lbl-1000
                        if ('a' <= it ? it < '{' : false) ** GOTO lbl-1000
                        v0 = 'A' <= it ? it < '[' : false;
                        if (v0) lbl-1000:
                        // 3 sources

                        {
                            v1 = true;
                        } else {
                            v1 = false;
                        }
                        if (v1) continue;
                        v2 = false;
                        break block6;
                    }
                    v2 = true;
                }
                if (!v2) {
                    $i$a$-require-DockerEelPathFormat$ContainerIdentifier$Companion$validateContainerId$4 = false;
                    var4_8 = type + " must contain only ASCII alphanumeric characters: " + value;
                    throw new IllegalArgumentException(var4_8.toString());
                }
            }

            static {
                $$INSTANCE = new Companion();
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @JvmInline
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087@\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0011\u0010\u000b\u001a\u00020\u0003H\u0096\u0080\u0004\u00a2\u0006\u0004\b\f\u0010\u0005J\u001b\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0083\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0011\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0088\u0001\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/docker/ijent/DockerEelPathFormat$ContainerIdentifier$DevcontainerId;", "Lcom/intellij/docker/ijent/DockerEelPathFormat$ContainerIdentifier;", "value", "", "constructor-impl", "(Ljava/lang/String;)Ljava/lang/String;", "id", "Lcom/intellij/docker/agent/util/ShortId;", "(Lcom/intellij/docker/agent/util/ShortId;)Ljava/lang/String;", "getValue", "()Ljava/lang/String;", "toString", "toString-impl", "equals", "", "other", "", "equals-impl", "(Ljava/lang/String;Ljava/lang/Object;)Z", "hashCode", "", "hashCode-impl", "(Ljava/lang/String;)I", "intellij.clouds.docker"})
        public static final class DevcontainerId
        implements ContainerIdentifier {
            @NotNull
            private final String value;

            @Override
            @NotNull
            public String getValue() {
                return this.value;
            }

            @NotNull
            public static String constructor-impl(@NotNull ShortId id) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                return DevcontainerId.constructor-impl(id.toString());
            }

            @NotNull
            public static String toString-impl(String arg0) {
                return arg0;
            }

            @NotNull
            public String toString() {
                return DevcontainerId.toString-impl(this.value);
            }

            public static int hashCode-impl(String arg0) {
                return arg0.hashCode();
            }

            public int hashCode() {
                return DevcontainerId.hashCode-impl(this.value);
            }

            public static boolean equals-impl(String arg0, Object other) {
                if (!(other instanceof DevcontainerId)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)arg0, (Object)((DevcontainerId)other).unbox-impl());
            }

            public boolean equals(Object other) {
                return DevcontainerId.equals-impl(this.value, other);
            }

            private /* synthetic */ DevcontainerId(String value) {
                this.value = value;
            }

            @NotNull
            public static String constructor-impl(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                String string = value;
                Companion.validateContainerId(string, "DevContainer ID");
                return string;
            }

            public static final /* synthetic */ DevcontainerId box-impl(String v) {
                return new DevcontainerId(v);
            }

            public final /* synthetic */ String unbox-impl() {
                return this.value;
            }

            public static final boolean equals-impl0(String p1, String p2) {
                return Intrinsics.areEqual((Object)p1, (Object)p2);
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @JvmInline
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087@\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0011\u0010\u000b\u001a\u00020\u0003H\u0096\u0080\u0004\u00a2\u0006\u0004\b\f\u0010\u0005J\u001b\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0083\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0011\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0088\u0001\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/docker/ijent/DockerEelPathFormat$ContainerIdentifier$Id;", "Lcom/intellij/docker/ijent/DockerEelPathFormat$ContainerIdentifier;", "value", "", "constructor-impl", "(Ljava/lang/String;)Ljava/lang/String;", "id", "Lcom/intellij/docker/agent/util/ShortId;", "(Lcom/intellij/docker/agent/util/ShortId;)Ljava/lang/String;", "getValue", "()Ljava/lang/String;", "toString", "toString-impl", "equals", "", "other", "", "equals-impl", "(Ljava/lang/String;Ljava/lang/Object;)Z", "hashCode", "", "hashCode-impl", "(Ljava/lang/String;)I", "intellij.clouds.docker"})
        public static final class Id
        implements ContainerIdentifier {
            @NotNull
            private final String value;

            @Override
            @NotNull
            public String getValue() {
                return this.value;
            }

            @NotNull
            public static String constructor-impl(@NotNull ShortId id) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                return Id.constructor-impl(id.toString());
            }

            @NotNull
            public static String toString-impl(String arg0) {
                return arg0;
            }

            @NotNull
            public String toString() {
                return Id.toString-impl(this.value);
            }

            public static int hashCode-impl(String arg0) {
                return arg0.hashCode();
            }

            public int hashCode() {
                return Id.hashCode-impl(this.value);
            }

            public static boolean equals-impl(String arg0, Object other) {
                if (!(other instanceof Id)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)arg0, (Object)((Id)other).unbox-impl());
            }

            public boolean equals(Object other) {
                return Id.equals-impl(this.value, other);
            }

            private /* synthetic */ Id(String value) {
                this.value = value;
            }

            @NotNull
            public static String constructor-impl(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                String string = value;
                Companion.validateContainerId(string, "Container ID");
                return string;
            }

            public static final /* synthetic */ Id box-impl(String v) {
                return new Id(v);
            }

            public final /* synthetic */ String unbox-impl() {
                return this.value;
            }

            public static final boolean equals-impl0(String p1, String p2) {
                return Intrinsics.areEqual((Object)p1, (Object)p2);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\bH\u0016J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/docker/ijent/DockerEelPathFormat$Devcontainer;", "Lcom/intellij/docker/ijent/DockerEelPathFormat;", "isWindows", "", "<init>", "(Z)V", "()V", "pathPrefix", "", "getPathPrefix", "()Ljava/lang/String;", "matches", "path", "buildRootPath", "Lcom/intellij/docker/ijent/DockerEelPathFormat$PathRepresentation;", "containerIdentifier", "Lcom/intellij/docker/ijent/DockerEelPathFormat$ContainerIdentifier;", "endpoint", "parse", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerEelPathFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerEelPathFormat.kt\ncom/intellij/docker/ijent/DockerEelPathFormat$Devcontainer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,482:1\n1#2:483\n*E\n"})
    public static final class Devcontainer
    implements DockerEelPathFormat {
        private final boolean isWindows;

        @VisibleForTesting
        public Devcontainer(boolean isWindows) {
            this.isWindows = isWindows;
        }

        public Devcontainer() {
            this(com.intellij.docker.ijent.DockerEelPathFormat$Companion.IS_WINDOWS);
        }

        private final String getPathPrefix() {
            return this.isWindows ? "//devcontainer.ij/" : "/$devcontainer.ij/";
        }

        @Override
        public boolean matches(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return StringsKt.startsWith$default((String)path2, (String)this.getPathPrefix(), (boolean)false, (int)2, null);
        }

        @Override
        @NotNull
        public PathRepresentation buildRootPath(@NotNull ContainerIdentifier containerIdentifier, @Nullable String endpoint) {
            Intrinsics.checkNotNullParameter((Object)containerIdentifier, (String)"containerIdentifier");
            if (!(endpoint != null)) {
                boolean bl = false;
                String string = "Endpoint is required for Devcontainer format";
                throw new IllegalStateException(string.toString());
            }
            String encodedEndpoint = DockerEndpointEncoder.INSTANCE.encodeOrAlias(endpoint);
            return new PathRepresentation(this.getPathPrefix(), containerIdentifier, encodedEndpoint, "");
        }

        @Override
        @Nullable
        public PathRepresentation parse(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            if (!this.matches(path2)) {
                return null;
            }
            String string = InternalUtilsKt.substringAfterPrefix(path2, this.getPathPrefix());
            if (string == null) {
                return null;
            }
            String afterPrefix = string;
            return Companion.parseWithEndpoint(this.getPathPrefix(), afterPrefix, (Function1<? super String, ? extends ContainerIdentifier>)parse.1.INSTANCE);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0011\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\bH\u0016J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/docker/ijent/DockerEelPathFormat$Obsolete;", "Lcom/intellij/docker/ijent/DockerEelPathFormat;", "isWindows", "", "<init>", "(Z)V", "()V", "pathPrefix", "", "getPathPrefix", "()Ljava/lang/String;", "matches", "path", "buildRootPath", "Lcom/intellij/docker/ijent/DockerEelPathFormat$PathRepresentation;", "containerIdentifier", "Lcom/intellij/docker/ijent/DockerEelPathFormat$ContainerIdentifier;", "endpoint", "parse", "extractContainerIdentifier", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerEelPathFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerEelPathFormat.kt\ncom/intellij/docker/ijent/DockerEelPathFormat$Obsolete\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,482:1\n1#2:483\n*E\n"})
    public static final class Obsolete
    implements DockerEelPathFormat {
        private final boolean isWindows;

        @VisibleForTesting
        public Obsolete(boolean isWindows) {
            this.isWindows = isWindows;
        }

        public Obsolete() {
            this(com.intellij.docker.ijent.DockerEelPathFormat$Companion.IS_WINDOWS);
        }

        private final String getPathPrefix() {
            return this.isWindows ? "//docker/" : "/docker-";
        }

        @Override
        public boolean matches(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return StringsKt.startsWith$default((String)path2, (String)this.getPathPrefix(), (boolean)false, (int)2, null);
        }

        @Override
        @NotNull
        public PathRepresentation buildRootPath(@NotNull ContainerIdentifier containerIdentifier, @Nullable String endpoint) {
            Intrinsics.checkNotNullParameter((Object)containerIdentifier, (String)"containerIdentifier");
            if (!(endpoint == null)) {
                boolean bl = false;
                String string = "Endpoint is not supported for Obsolete format";
                throw new IllegalStateException(string.toString());
            }
            return new PathRepresentation(this.getPathPrefix(), containerIdentifier, null, "");
        }

        @Override
        @Nullable
        public PathRepresentation parse(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            String string = this.extractContainerIdentifier(path2);
            if (string == null) {
                return null;
            }
            String containerId = string;
            String containerIdentifier = ContainerIdentifier.Id.constructor-impl(containerId);
            String innerPath = StringsKt.substringAfter((String)path2, (String)(this.getPathPrefix() + containerId), (String)"");
            return new PathRepresentation(this.getPathPrefix(), ContainerIdentifier.Id.box-impl(containerIdentifier), null, innerPath);
        }

        private final String extractContainerIdentifier(String path2) {
            String id;
            String string;
            String string2;
            String string3 = InternalUtilsKt.substringAfterPrefix(path2, this.getPathPrefix());
            if (string3 != null && (string2 = StringsKt.substringBefore$default((String)string3, (String)"/", null, (int)2, null)) != null) {
                String string4;
                String p0 = string4 = string2;
                boolean bl = false;
                string = ((CharSequence)p0).length() > 0 ? string4 : null;
            } else {
                string = null;
            }
            String string5 = id = string;
            return !(string5 != null ? string5.length() == 12 : false) ? null : id;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B+\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\u0013\u001a\u00020\u0003H\u0096\u0080\u0004J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J8\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c0\u0001\u00a2\u0006\u0002\b\u0019J\u0014\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001d\u001a\u00020\u001eH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lcom/intellij/docker/ijent/DockerEelPathFormat$PathRepresentation;", "", "prefix", "", "containerIdentifier", "Lcom/intellij/docker/ijent/DockerEelPathFormat$ContainerIdentifier;", "encodedEndpoint", "innerPath", "<init>", "(Ljava/lang/String;Lcom/intellij/docker/ijent/DockerEelPathFormat$ContainerIdentifier;Ljava/lang/String;Ljava/lang/String;)V", "getPrefix", "()Ljava/lang/String;", "getContainerIdentifier", "()Lcom/intellij/docker/ijent/DockerEelPathFormat$ContainerIdentifier;", "getInnerPath", "endpoint", "getEndpoint", "stringRoot", "getStringRoot", "toString", "component1", "component2", "component3", "component4", "copy", "copy$intellij_clouds_docker", "equals", "", "other", "hashCode", "", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerEelPathFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerEelPathFormat.kt\ncom/intellij/docker/ijent/DockerEelPathFormat$PathRepresentation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,482:1\n1#2:483\n*E\n"})
    public static final class PathRepresentation {
        @NotNull
        private final String prefix;
        @NotNull
        private final ContainerIdentifier containerIdentifier;
        @Nullable
        private final String encodedEndpoint;
        @NotNull
        private final String innerPath;
        @Nullable
        private final String endpoint;
        @NotNull
        private final String stringRoot;

        /*
         * WARNING - void declaration
         */
        public PathRepresentation(@NotNull String prefix, @NotNull ContainerIdentifier containerIdentifier, @Nullable String encodedEndpoint, @NotNull String innerPath) {
            String string;
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)containerIdentifier, (String)"containerIdentifier");
            Intrinsics.checkNotNullParameter((Object)innerPath, (String)"innerPath");
            this.prefix = prefix;
            this.containerIdentifier = containerIdentifier;
            this.encodedEndpoint = encodedEndpoint;
            this.innerPath = innerPath;
            PathRepresentation pathRepresentation = this;
            String string2 = this.encodedEndpoint;
            if (string2 != null) {
                void p0;
                String string3 = string2;
                DockerEndpointEncoder dockerEndpointEncoder = DockerEndpointEncoder.INSTANCE;
                String string4 = string3;
                PathRepresentation pathRepresentation2 = pathRepresentation;
                boolean bl = false;
                string = dockerEndpointEncoder.decodeOrDefault((String)p0);
                pathRepresentation = pathRepresentation2;
            } else {
                string = null;
            }
            pathRepresentation.endpoint = string;
            this.stringRoot = this.encodedEndpoint != null ? this.prefix + this.containerIdentifier + "@" + this.encodedEndpoint : this.prefix + this.containerIdentifier;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final ContainerIdentifier getContainerIdentifier() {
            return this.containerIdentifier;
        }

        @NotNull
        public final String getInnerPath() {
            return this.innerPath;
        }

        @Nullable
        public final String getEndpoint() {
            return this.endpoint;
        }

        @NotNull
        public final String getStringRoot() {
            return this.stringRoot;
        }

        @NotNull
        public String toString() {
            return this.stringRoot + this.innerPath;
        }

        @NotNull
        public final String component1() {
            return this.prefix;
        }

        @NotNull
        public final ContainerIdentifier component2() {
            return this.containerIdentifier;
        }

        private final String component3() {
            return this.encodedEndpoint;
        }

        @NotNull
        public final String component4() {
            return this.innerPath;
        }

        @NotNull
        public final PathRepresentation copy$intellij_clouds_docker(@NotNull String prefix, @NotNull ContainerIdentifier containerIdentifier, @Nullable String encodedEndpoint, @NotNull String innerPath) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)containerIdentifier, (String)"containerIdentifier");
            Intrinsics.checkNotNullParameter((Object)innerPath, (String)"innerPath");
            return new PathRepresentation(prefix, containerIdentifier, encodedEndpoint, innerPath);
        }

        public static /* synthetic */ PathRepresentation copy$intellij_clouds_docker$default(PathRepresentation pathRepresentation, String string, ContainerIdentifier containerIdentifier, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = pathRepresentation.prefix;
            }
            if ((n & 2) != 0) {
                containerIdentifier = pathRepresentation.containerIdentifier;
            }
            if ((n & 4) != 0) {
                string2 = pathRepresentation.encodedEndpoint;
            }
            if ((n & 8) != 0) {
                string3 = pathRepresentation.innerPath;
            }
            return pathRepresentation.copy$intellij_clouds_docker(string, containerIdentifier, string2, string3);
        }

        public int hashCode() {
            int result2 = this.prefix.hashCode();
            result2 = result2 * 31 + this.containerIdentifier.hashCode();
            result2 = result2 * 31 + (this.encodedEndpoint == null ? 0 : this.encodedEndpoint.hashCode());
            result2 = result2 * 31 + this.innerPath.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PathRepresentation)) {
                return false;
            }
            PathRepresentation pathRepresentation = (PathRepresentation)other;
            if (!Intrinsics.areEqual((Object)this.prefix, (Object)pathRepresentation.prefix)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.containerIdentifier, (Object)pathRepresentation.containerIdentifier)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.encodedEndpoint, (Object)pathRepresentation.encodedEndpoint)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.innerPath, (Object)pathRepresentation.innerPath);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\bH\u0016J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/docker/ijent/DockerEelPathFormat$Standard;", "Lcom/intellij/docker/ijent/DockerEelPathFormat;", "isWindows", "", "<init>", "(Z)V", "()V", "pathPrefix", "", "getPathPrefix", "()Ljava/lang/String;", "matches", "path", "buildRootPath", "Lcom/intellij/docker/ijent/DockerEelPathFormat$PathRepresentation;", "containerIdentifier", "Lcom/intellij/docker/ijent/DockerEelPathFormat$ContainerIdentifier;", "endpoint", "parse", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerEelPathFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerEelPathFormat.kt\ncom/intellij/docker/ijent/DockerEelPathFormat$Standard\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,482:1\n1#2:483\n*E\n"})
    public static final class Standard
    implements DockerEelPathFormat {
        private final boolean isWindows;

        @VisibleForTesting
        public Standard(boolean isWindows) {
            this.isWindows = isWindows;
        }

        public Standard() {
            this(com.intellij.docker.ijent.DockerEelPathFormat$Companion.IS_WINDOWS);
        }

        private final String getPathPrefix() {
            return this.isWindows ? "//docker.ij/" : "/$docker.ij/";
        }

        @Override
        public boolean matches(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return StringsKt.startsWith$default((String)path2, (String)this.getPathPrefix(), (boolean)false, (int)2, null);
        }

        @Override
        @NotNull
        public PathRepresentation buildRootPath(@NotNull ContainerIdentifier containerIdentifier, @Nullable String endpoint) {
            Intrinsics.checkNotNullParameter((Object)containerIdentifier, (String)"containerIdentifier");
            if (!(endpoint != null)) {
                boolean bl = false;
                String string = "Endpoint is required for Standard format";
                throw new IllegalStateException(string.toString());
            }
            String encodedEndpoint = DockerEndpointEncoder.INSTANCE.encodeOrAlias(endpoint);
            return new PathRepresentation(this.getPathPrefix(), containerIdentifier, encodedEndpoint, "");
        }

        @Override
        @Nullable
        public PathRepresentation parse(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            if (!this.matches(path2)) {
                return null;
            }
            String string = InternalUtilsKt.substringAfterPrefix(path2, this.getPathPrefix());
            if (string == null) {
                return null;
            }
            String afterPrefix = string;
            return Companion.parseWithEndpoint(this.getPathPrefix(), afterPrefix, (Function1<? super String, ? extends ContainerIdentifier>)parse.1.INSTANCE);
        }
    }
}

