/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.chrome.wip;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.console.ConsoleMessage;
import com.intellij.javascript.debugger.console.ConsoleMessageBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateContextBase;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.wip.RequestInfo;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.console.ConsoleMessageValue;
import org.jetbrains.wip.protocol.network.InitiatorValue;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;
import org.jetbrains.wip.protocol.runtime.RemoteObjectValue;
import org.jetbrains.wip.protocol.runtime.StackTraceValue;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J*\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/javascript/debugger/chrome/wip/WipConsoleMessageTask;", "Lcom/intellij/javascript/debugger/console/ConsoleMessage;", "message", "Lorg/jetbrains/wip/protocol/console/ConsoleMessageValue;", "vm", "Lorg/jetbrains/wip/WipVm;", "request", "Lorg/jetbrains/wip/RequestInfo;", "<init>", "(Lorg/jetbrains/wip/protocol/console/ConsoleMessageValue;Lorg/jetbrains/wip/WipVm;Lorg/jetbrains/wip/RequestInfo;)V", "print", "", "printer", "Lcom/intellij/javascript/debugger/console/ConsoleMessageBuilder;", "printFailedNetworkRequestMessage", "printParameters", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "isNotFirst", "", "xmlView", "intellij.javascript.debugger.backend"})
public final class WipConsoleMessageTask
implements ConsoleMessage {
    @NotNull
    private final ConsoleMessageValue message;
    @NotNull
    private final WipVm vm;
    @Nullable
    private final RequestInfo request;

    public WipConsoleMessageTask(@NotNull ConsoleMessageValue message, @NotNull WipVm vm, @Nullable RequestInfo request) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        this.message = message;
        this.vm = vm;
        this.request = request;
    }

    @Override
    public void print(@NotNull ConsoleMessageBuilder printer) {
        boolean willPrintStackTrace;
        boolean isFromNetwork;
        List stackTrace;
        ConsoleViewContentType contentType;
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        switch (WhenMappings.$EnumSwitchMapping$0[this.message.level().ordinal()]) {
            case 1: {
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.LOG_ERROR_OUTPUT;
                break;
            }
            case 2: {
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.LOG_WARNING_OUTPUT;
                break;
            }
            case 3: {
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.LOG_INFO_OUTPUT;
                break;
            }
            case 4: {
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.LOG_DEBUG_OUTPUT;
                break;
            }
            default: {
                ConsoleViewContentType consoleViewContentType = contentType = ConsoleViewContentType.NORMAL_OUTPUT;
            }
        }
        if (this.message.getType() == ConsoleMessageValue.Type.END_GROUP) {
            printer.groupEnd();
            return;
        }
        Intrinsics.checkNotNull((Object)contentType);
        printer.startMessage(contentType, this.message.source().toString());
        String url = this.message.getUrl();
        int line = this.message.getLine();
        int column = this.message.getColumn();
        StackTraceValue stackTraceValue = this.message.getStack();
        List list = stackTrace = stackTraceValue != null ? stackTraceValue.callFrames() : null;
        if (WhenMappings.$EnumSwitchMapping$2[this.message.source().ordinal()] == 1) {
            if (this.request == null) {
                ConsoleMessageBuilder.append$default(printer, this.message.text(), null, null, 6, null);
                String string = this.message.getUrl();
                Intrinsics.checkNotNull((Object)string);
                ConsoleMessageBuilder.addMessageLink$default(printer, string, -1, -1, null, false, null, 32, null);
            } else {
                if (this.request.getInitiator() != null) {
                    InitiatorValue initiatorValue = this.request.getInitiator();
                    Intrinsics.checkNotNull((Object)initiatorValue);
                    StackTraceValue stackTraceValue2 = initiatorValue.getStack();
                    stackTrace = stackTraceValue2 != null ? stackTraceValue2.callFrames() : null;
                    InitiatorValue initiatorValue2 = this.request.getInitiator();
                    Intrinsics.checkNotNull((Object)initiatorValue2);
                    if (!StringUtil.isEmpty((String)initiatorValue2.getUrl())) {
                        InitiatorValue initiatorValue3 = this.request.getInitiator();
                        Intrinsics.checkNotNull((Object)initiatorValue3);
                        url = initiatorValue3.getUrl();
                        InitiatorValue initiatorValue4 = this.request.getInitiator();
                        Intrinsics.checkNotNull((Object)initiatorValue4);
                        line = (int)initiatorValue4.getLineNumber();
                        column = -1;
                    }
                }
                if (this.message.level() == ConsoleMessageValue.Level.ERROR) {
                    this.printFailedNetworkRequestMessage(printer);
                } else {
                    ConsoleMessageBuilder.append$default(printer, this.message.text(), null, null, 6, null);
                }
            }
        } else {
            ConsoleMessageValue.Type type = this.message.getType();
            switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
                case 1: 
                case 2: {
                    String string;
                    List list2 = this.message.getParameters();
                    Intrinsics.checkNotNull((Object)list2);
                    RemoteObjectValue remoteObjectValue = (RemoteObjectValue)list2.get(0);
                    if (remoteObjectValue.type() == RemoteObjectValue.Type.STRING) {
                        Object object = remoteObjectValue.value();
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                        string = (String)object;
                    } else {
                        string = remoteObjectValue.getDescription();
                        if (string == null) {
                            string = "console.group()";
                        }
                    }
                    String groupName = string;
                    printer.groupStart(groupName, false);
                    break;
                }
                case 3: 
                case 4: {
                    this.printParameters(printer, contentType, false, this.message.getType() != ConsoleMessageValue.Type.DIR);
                    break;
                }
                case 5: {
                    printer.clear();
                    ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType(ConsoleMessageBuilder.Companion.getCONSOLE_INFO_KEY());
                    Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"getConsoleViewType(...)");
                    ConsoleMessageBuilder.append$default(printer, "Console was cleared", consoleViewContentType, null, 4, null);
                    break;
                }
                default: {
                    if (this.message.getType() == ConsoleMessageValue.Type.ASSERT) {
                        ConsoleMessageBuilder.append$default(printer, "Assertion failed:", contentType, null, 4, null);
                        WipConsoleMessageTask.printParameters$default(this, printer, contentType, true, false, 8, null);
                        break;
                    }
                    Collection collection = this.message.getParameters();
                    if (!(collection == null || collection.isEmpty())) {
                        WipConsoleMessageTask.printParameters$default(this, printer, contentType, false, false, 8, null);
                        break;
                    }
                    ConsoleMessageBuilder.append$default(printer, this.message.text(), contentType, null, 4, null);
                }
            }
        }
        boolean bl = isFromNetwork = this.message.source() == ConsoleMessageValue.Source.NETWORK;
        if (!isFromNetwork || this.request != null) {
            CallFrameValue callFrame;
            List list3 = stackTrace;
            Object object = callFrame = list3 != null ? (CallFrameValue)CollectionsKt.firstOrNull((List)list3) : null;
            if (callFrame != null && !(((CharSequence)callFrame.url()).length() == 0) && !Intrinsics.areEqual((Object)callFrame.url(), (Object)"undefined")) {
                ConsoleMessageBuilder.addMessageLink$default(printer, callFrame.url(), callFrame.getLineNumber() - 1, callFrame.getColumnNumber(), callFrame.functionName(), !isFromNetwork, null, 32, null);
            } else {
                CharSequence charSequence = url;
                if (!(charSequence == null || charSequence.length() == 0) && !Intrinsics.areEqual((Object)url, (Object)"undefined")) {
                    ConsoleMessageBuilder.addMessageLink$default(printer, url, line - 1, column, null, !isFromNetwork, null, 32, null);
                }
            }
        }
        boolean bl2 = willPrintStackTrace = !ContainerUtil.isEmpty((Collection)stackTrace) && (this.message.source() == ConsoleMessageValue.Source.NETWORK || this.message.level() == ConsoleMessageValue.Level.ERROR || this.message.getType() == ConsoleMessageValue.Type.TRACE);
        if (willPrintStackTrace) {
            printer.printStackTrace(contentType, this.message.getStack());
        }
        printer.endMessage();
    }

    private final void printFailedNetworkRequestMessage(ConsoleMessageBuilder printer) {
        RequestInfo requestInfo = this.request;
        Intrinsics.checkNotNull((Object)requestInfo);
        printer.appendError(requestInfo.getValue().method());
        printer.appendError(" ");
        printer.printBrowserLink(this.request.getValue().url());
        printer.appendError(" ");
        if (this.request.isFailed()) {
            String string = this.request.getFailDescription();
            Intrinsics.checkNotNull((Object)string);
            printer.appendError(string);
        } else {
            printer.appendError(String.valueOf(this.request.getStatusCode()));
            if (!StringUtil.isEmpty((String)this.request.getStatusText())) {
                printer.appendError(" (");
                String string = this.request.getStatusText();
                Intrinsics.checkNotNull((Object)string);
                printer.appendError(string);
                printer.appendError(")");
            }
        }
    }

    private final void printParameters(ConsoleMessageBuilder printer, ConsoleViewContentType contentType, boolean isNotFirst, boolean xmlView) {
        boolean isNotFirst2 = isNotFirst;
        Collection collection = this.message.getParameters();
        if (collection == null || collection.isEmpty()) {
            return;
        }
        List list = this.message.getParameters();
        Intrinsics.checkNotNull((Object)list);
        for (RemoteObjectValue objectValue : list) {
            if (isNotFirst2) {
                ConsoleMessageBuilder.append$default(printer, " ", contentType, null, 4, null);
            } else {
                isNotFirst2 = true;
            }
            CharSequence charSequence = objectValue.getObjectId();
            if (!(charSequence == null || charSequence.length() == 0)) {
                EvaluateContext evaluateContext = this.vm.getEvaluateContext();
                Intrinsics.checkNotNull((Object)evaluateContext, (String)"null cannot be cast to non-null type org.jetbrains.debugger.EvaluateContextBase<*>");
                ValueManager valueManager = ((EvaluateContextBase)evaluateContext).getValueManager();
                Intrinsics.checkNotNull((Object)valueManager, (String)"null cannot be cast to non-null type org.jetbrains.wip.WipValueManager");
                WipValueManager valueManager2 = (WipValueManager)valueManager;
                Value value = valueManager2.createValue(objectValue);
                Intrinsics.checkNotNull((Object)value);
                printer.printAndStoreValueToInspect(value, null, contentType, xmlView);
                continue;
            }
            if (objectValue.value() != null) {
                ConsoleMessageBuilder.append$default(printer, String.valueOf(objectValue.value()), contentType, null, 4, null);
                continue;
            }
            if (StringUtil.isEmpty((String)objectValue.getDescription())) continue;
            String string = objectValue.getDescription();
            Intrinsics.checkNotNull((Object)string);
            ConsoleMessageBuilder.append$default(printer, string, contentType, null, 4, null);
        }
    }

    static /* synthetic */ void printParameters$default(WipConsoleMessageTask wipConsoleMessageTask, ConsoleMessageBuilder consoleMessageBuilder, ConsoleViewContentType consoleViewContentType, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        wipConsoleMessageTask.printParameters(consoleMessageBuilder, consoleViewContentType, bl, bl2);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[ConsoleMessageValue.Level.values().length];
            try {
                nArray[ConsoleMessageValue.Level.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConsoleMessageValue.Level.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConsoleMessageValue.Level.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConsoleMessageValue.Level.DEBUG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ConsoleMessageValue.Type.values().length];
            try {
                nArray[ConsoleMessageValue.Type.START_GROUP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConsoleMessageValue.Type.START_GROUP_COLLAPSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConsoleMessageValue.Type.DIR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConsoleMessageValue.Type.DIRXML.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConsoleMessageValue.Type.CLEAR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[ConsoleMessageValue.Source.values().length];
            try {
                nArray[ConsoleMessageValue.Source.NETWORK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

