/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.chrome.wip;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.console.ConsoleMessage;
import com.intellij.javascript.debugger.console.ConsoleMessageBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.runtime.ExceptionDetailsValue;
import org.jetbrains.wip.protocol.runtime.ExceptionThrownEventData;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javascript/debugger/chrome/wip/WipExceptionThrown;", "Lcom/intellij/javascript/debugger/console/ConsoleMessage;", "message", "Lorg/jetbrains/wip/protocol/runtime/ExceptionThrownEventData;", "vm", "Lorg/jetbrains/wip/WipVm;", "<init>", "(Lorg/jetbrains/wip/protocol/runtime/ExceptionThrownEventData;Lorg/jetbrains/wip/WipVm;)V", "getMessage", "()Lorg/jetbrains/wip/protocol/runtime/ExceptionThrownEventData;", "getVm", "()Lorg/jetbrains/wip/WipVm;", "print", "", "printer", "Lcom/intellij/javascript/debugger/console/ConsoleMessageBuilder;", "intellij.javascript.debugger.backend"})
public final class WipExceptionThrown
implements ConsoleMessage {
    @NotNull
    private final ExceptionThrownEventData message;
    @NotNull
    private final WipVm vm;

    public WipExceptionThrown(@NotNull ExceptionThrownEventData message, @NotNull WipVm vm) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        this.message = message;
        this.vm = vm;
    }

    @NotNull
    public final ExceptionThrownEventData getMessage() {
        return this.message;
    }

    @NotNull
    public final WipVm getVm() {
        return this.vm;
    }

    @Override
    public void print(@NotNull ConsoleMessageBuilder printer) {
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        ConsoleViewContentType contentType = ConsoleViewContentType.LOG_ERROR_OUTPUT;
        Intrinsics.checkNotNull((Object)contentType);
        ConsoleMessageBuilder.startMessage$default(printer, contentType, null, 2, null);
        ExceptionDetailsValue details = this.message.exceptionDetails();
        ConsoleMessageBuilder.append$default(printer, details.text(), contentType, null, 4, null);
        Object object = details.getException();
        if (object != null && (object = object.getDescription()) != null) {
            Object object2;
            Object it = object;
            boolean bl = false;
            int newLinePos = StringsKt.indexOf$default((CharSequence)((CharSequence)it), (char)'\n', (int)0, (boolean)false, (int)6, null);
            if (newLinePos == -1) {
                object2 = it;
            } else {
                String string = ((String)it).substring(0, newLinePos);
                object2 = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            }
            Object errorText = object2;
            ConsoleMessageBuilder.append$default(printer, " " + (String)errorText, contentType, null, 4, null);
        }
        String url = details.getUrl();
        if (url != null) {
            ConsoleMessageBuilder.addMessageLink$default(printer, url, details.getLineNumber(), details.getColumnNumber(), null, true, null, 32, null);
        }
        printer.printStackTrace(contentType, details.getStackTrace());
        printer.endMessage();
    }
}

